/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Mar 3, 2003
 * Time: 2:13:01 PM
 * To change this template use Options | File Templates.
 */
public class SQLDatabaseConnection extends SdxObjectImpl implements DatabaseConnection {
    Connection conn = null;

    public SQLDatabaseConnection() {
    }

    public SQLDatabaseConnection(Connection conn) {
        this.conn = conn;
    }

    public void commit() throws SDXException {
        try {
            if (this.conn != null)
                this.conn.commit();
        } catch (SQLException e) {
            throw new SDXException(logger, SDXExceptionCode.ERROR_COMMIT_SQL_CONNECTION, null, e);
        }
    }

    public void rollback() throws SDXException {
        try {
            if (this.conn != null)
                this.conn.rollback();
        } catch (SQLException e) {
            throw new SDXException(logger, SDXExceptionCode.ERROR_ROLLBACK_SQL_CONNECTION, null, e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SDXException {
        try {
            if (this.conn != null)
                this.conn.setAutoCommit(autoCommit);
        } catch (SQLException e) {
            throw new SDXException(logger, SDXExceptionCode.ERROR_SET_AUTO_COMMIT_SQL_CONNECTION, null, e);
        }
    }

    /**
     * Returns the SQL connection to the datasource component
     */
    public Connection getConnection() {
        return this.conn;
    }

    public void close() throws SDXException {
        try {
            if (this.conn != null)
                this.conn.close();
        } catch (SQLException e) {
            throw new SDXException(logger, SDXExceptionCode.ERROR_COMMIT_SQL_CONNECTION, null, e);
        }
    }

    public void optimize() throws SDXException {
        //do nothing here
    }


}
