/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLizable;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XMLUtils {
    public static String xalanBugStylesheet = "<?xml version=\"1.0\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"node()|@*\"><xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy></xsl:template></xsl:stylesheet>";

    public static void stripDuplicateAttributes(Node node, Node parent) {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                Node child = doc.getFirstChild();
                while (child != null) {
                    XMLUtils.stripDuplicateAttributes(child, node);
                    child = child.getNextSibling();
                }
                break;
            }
            case 1: {
                Element elt = (Element)node;
                NamedNodeMap attrs = elt.getAttributes();
                ArrayList<Node> nodesToRemove = new ArrayList<Node>();
                int nodesToRemoveNum = 0;
                int i = 0;
                while (i < attrs.getLength()) {
                    Node a = attrs.item(i);
                    int j = 0;
                    while (j < attrs.getLength()) {
                        Node b = attrs.item(j);
                        if (i != j && a.getNodeName().equals(b.getNodeName())) {
                            nodesToRemove.add(b);
                            ++nodesToRemoveNum;
                        }
                        ++j;
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < nodesToRemoveNum) {
                    Attr nodeToDelete = (Attr)nodesToRemove.get(i2);
                    Element nodeToDeleteParent = (Element)node;
                    nodeToDeleteParent.removeAttributeNode(nodeToDelete);
                    ++i2;
                }
                nodesToRemove.clear();
                Node child = elt.getFirstChild();
                while (child != null) {
                    XMLUtils.stripDuplicateAttributes(child, node);
                    child = child.getNextSibling();
                }
                break;
            }
        }
    }

    public static XMLConsumer getConsumer(ContentHandler ch, LexicalHandler lh) {
        if (ch instanceof XMLConsumer) {
            return (XMLConsumer)ch;
        }
        return new ContentHandlerWrapper(ch, lh);
    }

    public static XMLConsumer getConsumer(ContentHandler ch) {
        return XMLUtils.getConsumer(ch, null);
    }

    public static String serializeNodeToXML(Node node) throws ProcessingException {
        return XMLUtils.serializeNode(node, XMLUtils.defaultSerializeToXMLFormat());
    }

    public static Properties defaultSerializeToXMLFormat() {
        return XMLUtils.defaultSerializeToXMLFormat(false);
    }

    public static Properties defaultSerializeToXMLFormat(boolean omitXMLDeclaration) {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("encoding", "ISO-8859-1");
        format.put("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        format.put("indent", "yes");
        return format;
    }

    public static String serializeNode(Node node, Properties format) throws ProcessingException {
        try {
            if (node == null) {
                return "";
            }
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(xalanBugStylesheet)));
            transformer.setOutputProperties(format);
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException local) {
            throw new ProcessingException("TransformerException: " + local, local);
        }
    }

    public static void data(ContentHandler contentHandler, String data) throws SAXException {
        contentHandler.characters(data.toCharArray(), 0, data.length());
    }

    public static void valueOf(ContentHandler contentHandler, String text) throws SAXException {
        if (text != null) {
            XMLUtils.data(contentHandler, text);
        }
    }

    public static void valueOf(ContentHandler contentHandler, XMLizable v) throws SAXException {
        if (v != null) {
            try {
                v.toSAX(contentHandler);
            }
            catch (ProcessingException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public static void valueOf(ContentHandler contentHandler, Node v) throws SAXException {
        if (v != null) {
            DOMStreamer streamer = new DOMStreamer(contentHandler);
            if (contentHandler instanceof LexicalHandler) {
                streamer.setLexicalHandler((LexicalHandler)((Object)contentHandler));
            }
            streamer.stream(v);
        }
    }

    public static void valueOf(ContentHandler contentHandler, Collection v) throws SAXException {
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                XMLUtils.valueOf(contentHandler, iterator.next());
            }
        }
    }

    public static void valueOf(ContentHandler contentHandler, Object v) throws SAXException {
        if (v == null) {
            return;
        }
        if (v.getClass().isArray()) {
            Object[] elements = (Object[])v;
            int i = 0;
            while (i < elements.length) {
                XMLUtils.valueOf(contentHandler, elements[i]);
                ++i;
            }
            return;
        }
        if (v instanceof XMLizable) {
            XMLUtils.valueOf(contentHandler, (XMLizable)v);
            return;
        }
        if (v instanceof Node) {
            XMLUtils.valueOf(contentHandler, (Node)v);
            return;
        }
        if (v instanceof Collection) {
            XMLUtils.valueOf(contentHandler, (Collection)v);
            return;
        }
        XMLUtils.data(contentHandler, String.valueOf(v));
    }
}

