/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.excalibur.xml.xpath.XPathProcessor;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XIncludeTransformer
extends AbstractTransformer
implements Composable,
Disposable {
    private SourceResolver resolver;
    private XPathProcessor processor = null;
    protected ComponentManager manager = null;
    public static final String XMLBASE_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLBASE_ATTRIBUTE = "base";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    public static final String XINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE = "href";
    public static final String XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE = "parse";
    protected Source base_xmlbase_uri = null;
    protected Source current_xmlbase_uri = null;
    protected Stack xmlbase_stack = new Stack();
    protected String last_xmlbase_element_uri = "";
    protected Stack xmlbase_element_uri_stack = new Stack();
    protected String last_xmlbase_element_name = "";
    protected Stack xmlbase_element_name_stack = new Stack();

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
        try {
            this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        }
        catch (Exception e) {
            this.getLogger().error("cannot obtain XPathProcessor", (Throwable)e);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String value = attr.getValue(XMLBASE_NAMESPACE_URI, XMLBASE_ATTRIBUTE);
        if (value != null) {
            try {
                this.startXMLBaseAttribute(uri, name, value);
            }
            catch (ProcessingException e) {
                this.getLogger().debug("Rethrowing exception", (Throwable)((Object)e));
                throw new SAXException((Exception)((Object)e));
            }
        }
        if (XINCLUDE_NAMESPACE_URI.equals(uri) && XINCLUDE_INCLUDE_ELEMENT.equals(name)) {
            String href = attr.getValue("", XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE);
            String parse = attr.getValue("", XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE);
            if (null == parse) {
                parse = "xml";
            }
            try {
                this.processXIncludeElement(href, parse);
            }
            catch (ProcessingException e) {
                this.getLogger().debug("Rethrowing exception", (Throwable)((Object)e));
                throw new SAXException((Exception)((Object)e));
            }
            catch (IOException e) {
                this.getLogger().debug("Rethrowing exception", (Throwable)e);
                throw new SAXException(e);
            }
            return;
        }
        super.startElement(uri, name, raw, attr);
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.last_xmlbase_element_uri.equals(uri) && this.last_xmlbase_element_name.equals(name)) {
            this.endXMLBaseAttribute();
        }
        if (uri != null && name != null && uri.equals(XINCLUDE_NAMESPACE_URI) && name.equals(XINCLUDE_INCLUDE_ELEMENT)) {
            return;
        }
        super.endElement(uri, name, raw);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("setDocumentLocator called " + locator.getSystemId());
            }
            this.base_xmlbase_uri = this.resolver.resolve(locator.getSystemId());
            if (this.base_xmlbase_uri.getSystemId().lastIndexOf(46) > this.base_xmlbase_uri.getSystemId().lastIndexOf(47)) {
                String uri = this.base_xmlbase_uri.getSystemId().substring(0, this.base_xmlbase_uri.getSystemId().lastIndexOf(47) + 1);
                this.base_xmlbase_uri.recycle();
                this.base_xmlbase_uri = null;
                this.base_xmlbase_uri = this.resolver.resolve(uri);
            }
            if (this.current_xmlbase_uri == null) {
                this.current_xmlbase_uri = this.base_xmlbase_uri;
            }
        }
        catch (Exception e) {
            this.getLogger().debug("Exception ignored", (Throwable)e);
        }
        super.setDocumentLocator(locator);
    }

    protected void startXMLBaseAttribute(String uri, String name, String value) throws ProcessingException {
        String urlLoc = value;
        if (!urlLoc.endsWith("/")) {
            urlLoc = urlLoc + "/";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XMLBase = " + urlLoc);
        }
        if (this.current_xmlbase_uri != null) {
            this.xmlbase_stack.push(this.current_xmlbase_uri);
        }
        try {
            this.current_xmlbase_uri = this.resolver.resolve(urlLoc);
            this.xmlbase_element_uri_stack.push(this.last_xmlbase_element_uri);
            this.last_xmlbase_element_uri = uri;
            this.xmlbase_element_name_stack.push(this.last_xmlbase_element_name);
            this.last_xmlbase_element_name = name;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Could not resolve '" + urlLoc + "'", e);
        }
    }

    protected void endXMLBaseAttribute() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XMLBase ended");
        }
        this.current_xmlbase_uri = this.xmlbase_stack.size() > 0 ? (Source)this.xmlbase_stack.pop() : this.base_xmlbase_uri;
        this.last_xmlbase_element_uri = (String)this.xmlbase_element_uri_stack.pop();
        this.last_xmlbase_element_name = (String)this.xmlbase_element_name_stack.pop();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processXIncludeElement(String href, String parse) throws SAXException, ProcessingException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Processing XInclude element: href=" + href + ", parse=" + parse);
            if (this.current_xmlbase_uri == null) {
                this.getLogger().debug("Base URI: null");
            } else {
                this.getLogger().debug("Base URI: " + this.current_xmlbase_uri.getSystemId());
            }
        }
        Source url = null;
        try {
            String suffix;
            int index = href.indexOf(35);
            if (index < 0) {
                url = this.current_xmlbase_uri == null ? this.resolver.resolve(href) : this.resolver.resolve(this.current_xmlbase_uri.getSystemId() + href);
                suffix = "";
            } else {
                url = this.current_xmlbase_uri == null ? this.resolver.resolve(href.substring(0, index)) : this.resolver.resolve(this.current_xmlbase_uri.getSystemId() + href.substring(0, index));
                suffix = href.substring(index + 1);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("URL: " + url + "\nSuffix: " + suffix);
            }
            if (parse.equals("text")) {
                this.getLogger().debug("Parse type is text");
                InputStream input = url.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                char[] ary = new char[1024];
                if (reader != null) {
                    while (true) {
                        void var8_14;
                        int read;
                        if ((read = reader.read(ary)) == -1) {
                            ((Reader)reader).close();
                            break;
                        }
                        super.characters(ary, 0, (int)var8_14);
                    }
                }
            } else if (parse.equals("xml")) {
                this.getLogger().debug("Parse type is XML");
                Parser parser = null;
                try {
                    block25: {
                        try {
                            parser = (Parser)this.manager.lookup(Parser.ROLE);
                            InputSource input = url.getInputSource();
                            if (suffix.startsWith("xpointer(") && suffix.endsWith(")")) {
                                String xpath = suffix.substring(9, suffix.length() - 1);
                                this.getLogger().debug("XPath is " + xpath);
                                Document document = parser.parseDocument(input);
                                NodeList list = this.processor.selectNodeList((Node)document, xpath);
                                DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
                                int length = list.getLength();
                                int i = 0;
                                while (i < length) {
                                    streamer.stream(list.item(i));
                                    ++i;
                                }
                                break block25;
                            }
                            IncludeXMLConsumer xinclude_handler = new IncludeXMLConsumer(this.contentHandler, this.lexicalHandler);
                            parser.parse(input, (ContentHandler)xinclude_handler);
                        }
                        catch (SAXException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)e);
                            throw e;
                        }
                        catch (ProcessingException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)((Object)e));
                            throw e;
                        }
                        catch (MalformedURLException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)e);
                            throw e;
                        }
                        catch (IOException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)e);
                            throw e;
                        }
                        catch (ComponentException e) {
                            this.getLogger().error("Error in processXIncludeElement", (Throwable)e);
                            throw new SAXException((Exception)((Object)e));
                        }
                    }
                    Object var15_24 = null;
                    this.manager.release((Component)parser);
                }
                catch (Throwable throwable) {
                    Object var15_25 = null;
                    this.manager.release((Component)parser);
                    throw throwable;
                }
            }
            Object var17_27 = null;
            if (url == null) return;
            url.recycle();
            return;
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            if (url == null) throw throwable;
            url.recycle();
            throw throwable;
        }
    }

    public void recycle() {
        this.resolver = null;
        if (this.base_xmlbase_uri != null) {
            this.base_xmlbase_uri.recycle();
        }
        this.base_xmlbase_uri = null;
        if (this.current_xmlbase_uri != null) {
            this.current_xmlbase_uri.recycle();
        }
        this.current_xmlbase_uri = null;
        this.xmlbase_stack = new Stack();
        this.last_xmlbase_element_uri = "";
        this.xmlbase_element_uri_stack = new Stack();
        this.last_xmlbase_element_name = "";
        this.xmlbase_element_name_stack = new Stack();
        super.recycle();
    }

    public void dispose() {
        this.manager.release((Component)this.processor);
    }
}

