/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.components.browser.Browser;
import org.apache.cocoon.components.deli.Deli;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.XMLConsumer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TraxTransformer
extends AbstractTransformer
implements Transformer,
Composable,
Configurable,
Cacheable,
Disposable {
    private Browser browser = null;
    private Deli deli = null;
    private boolean useDeli = false;
    private boolean _useDeli = false;
    private boolean useParameters = false;
    private boolean _useParameters = false;
    private boolean useBrowserCap = false;
    private boolean _useBrowserCap = false;
    private boolean useCookies = false;
    private boolean _useCookies = false;
    private boolean useSessionInfo = false;
    private boolean _useSessionInfo = false;
    private ComponentManager manager;
    TransformerHandler transformerHandler;
    private Source inputSource;
    private Parameters par;
    private Map objectModel;
    private XSLTProcessor xsltProcessor;
    private boolean finishedDocument = false;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration child = conf.getChild("use-request-parameters");
            this._useParameters = this.useParameters = child.getValueAsBoolean(false);
            child = conf.getChild("use-cookies");
            this._useCookies = this.useCookies = child.getValueAsBoolean(false);
            child = conf.getChild("use-browser-capabilities-db");
            this._useBrowserCap = this.useBrowserCap = child.getValueAsBoolean(false);
            child = conf.getChild("use-session-info");
            this._useSessionInfo = this.useSessionInfo = child.getValueAsBoolean(false);
            child = conf.getChild("use-deli");
            this._useDeli = this.useDeli = child.getValueAsBoolean(false);
            child = conf.getChild("xslt-processor-role");
            String xsltRole = child.getValue("org.apache.cocoon.components.xslt.XSLTProcessor");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Use parameters is " + this.useParameters + " for " + this);
                this.getLogger().debug("Use cookies is " + this.useCookies + " for " + this);
                this.getLogger().debug("Use browser capabilities is " + this.useBrowserCap + " for " + this);
                this.getLogger().debug("Use session info is " + this.useSessionInfo + " for " + this);
                this.getLogger().debug("Use DELI is " + this.useDeli + " for " + this);
                this.getLogger().debug("Use XSLTProcessor of role " + xsltRole);
            }
            try {
                this.xsltProcessor = (XSLTProcessor)this.manager.lookup(xsltRole);
            }
            catch (ComponentException e) {
                throw new ConfigurationException("Cannot load XSLT processor", (Throwable)e);
            }
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Looking up org.apache.cocoon.components.browser.Browser");
        }
        this.browser = (Browser)manager.lookup("org.apache.cocoon.components.browser.Browser");
        if (this.manager.hasComponent("org.apache.cocoon.components.deli.Deli")) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Looking up org.apache.cocoon.components.deli.Deli");
                }
                this.deli = (Deli)this.manager.lookup("org.apache.cocoon.components.deli.Deli");
            }
            catch (ComponentException e) {
                this.getLogger().debug("Deli is not available");
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().debug("Deli is not available");
            }
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws SAXException, ProcessingException, IOException {
        if (src == null) {
            throw new ProcessingException("Stylesheet URI can't be null");
        }
        this.par = par;
        this.objectModel = objectModel;
        this.inputSource = resolver.resolve(src);
        this.xsltProcessor.setSourceResolver(resolver);
        this._useParameters = par.getParameterAsBoolean("use-request-parameters", this.useParameters);
        this._useBrowserCap = par.getParameterAsBoolean("use-browser-capabilities-db", this.useBrowserCap);
        this._useCookies = par.getParameterAsBoolean("use-cookies", this.useCookies);
        this._useSessionInfo = par.getParameterAsBoolean("use-session-info", this.useSessionInfo);
        this._useDeli = par.getParameterAsBoolean("use-deli", this.useDeli);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using stylesheet: '" + this.inputSource.getSystemId() + "' in " + this + ", last modified: " + this.inputSource.getLastModified());
        }
        this.transformerHandler = this.xsltProcessor.getTransformerHandler(this.inputSource);
    }

    public long generateKey() {
        if (this.inputSource.getLastModified() != 0L) {
            HashMap map = this.getLogicSheetParameters();
            if (map == null) {
                return HashUtil.hash(this.inputSource.getSystemId());
            }
            StringBuffer sb = new StringBuffer(this.inputSource.getSystemId());
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                sb.append(';');
                Map.Entry entry = i.next();
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
            }
            return HashUtil.hash(sb.toString());
        }
        return 0L;
    }

    public CacheValidity generateValidity() {
        return this.xsltProcessor.getTransformerValidity(this.inputSource);
    }

    public void setConsumer(XMLConsumer consumer) {
        HashMap map = this.getLogicSheetParameters();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.transformerHandler.getTransformer().setParameter(name, map.get(name));
            }
        }
        super.setContentHandler(this.transformerHandler);
        super.setLexicalHandler(this.transformerHandler);
        if (this.transformerHandler instanceof Loggable) {
            ((Loggable)this.transformerHandler).setLogger(this.getLogger());
        }
        SAXResult result = new SAXResult(consumer);
        result.setLexicalHandler(consumer);
        this.transformerHandler.setResult(result);
    }

    private HashMap getLogicSheetParameters() {
        Cookie[] cookies;
        Request request;
        Enumeration parameters;
        String value;
        String name;
        String[] params;
        HashMap<String, Object> map = null;
        if (this.par != null && (params = this.par.getNames()) != null) {
            int i = 0;
            while (i < params.length) {
                name = params[i];
                if (TraxTransformer.isValidXSLTParameterName(name) && (value = this.par.getParameter(name, null)) != null) {
                    if (map == null) {
                        map = new HashMap();
                    }
                    map.put(name, value);
                }
                ++i;
            }
        }
        if (this._useParameters && (parameters = (request = ObjectModelHelper.getRequest(this.objectModel)).getParameterNames()) != null) {
            while (parameters.hasMoreElements()) {
                name = (String)parameters.nextElement();
                if (!TraxTransformer.isValidXSLTParameterName(name)) continue;
                value = request.getParameter(name);
                if (map == null) {
                    map = new HashMap();
                }
                map.put(name, value);
            }
        }
        if (this._useSessionInfo) {
            Session session;
            request = ObjectModelHelper.getRequest(this.objectModel);
            if (map == null) {
                map = new HashMap<String, Object>(5);
            }
            if ((session = request.getSession(false)) != null) {
                map.put("session-available", "true");
                map.put("session-is-new", session.isNew() ? "true" : "false");
                map.put("session-id-from-cookie", request.isRequestedSessionIdFromCookie() ? "true" : "false");
                map.put("session-id-from-url", request.isRequestedSessionIdFromURL() ? "true" : "false");
                map.put("session-valid", request.isRequestedSessionIdValid() ? "true" : "false");
                map.put("session-id", session.getId());
            } else {
                map.put("session-available", "false");
            }
        }
        if (this._useCookies && (cookies = (request = ObjectModelHelper.getRequest(this.objectModel)).getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                String name2 = cookies[i].getName();
                if (TraxTransformer.isValidXSLTParameterName(name2)) {
                    String value2 = cookies[i].getValue();
                    if (map == null) {
                        map = new HashMap();
                    }
                    map.put(name2, value2);
                }
                ++i;
            }
        }
        if (this._useBrowserCap) {
            try {
                String agent;
                String accept;
                request = ObjectModelHelper.getRequest(this.objectModel);
                if (map == null) {
                    map = new HashMap();
                }
                if ((accept = request.getParameter("accept")) == null) {
                    accept = request.getHeader("accept");
                }
                if ((agent = request.getParameter("user-agent")) == null) {
                    agent = request.getHeader("user-agent");
                }
                map.put("accept", accept);
                map.put("user-agent", URLEncoder.encode(agent));
                HashMap agmap = this.browser.getBrowser(agent, accept);
                map.put("browser", agmap);
                String browserMedia = this.browser.getMedia(agmap);
                map.put("browser-media", browserMedia);
                Document uaCapabilities = this.browser.getUACapabilities(agmap);
                map.put("ua-capabilities", uaCapabilities);
            }
            catch (Exception e) {
                this.getLogger().error("Error setting Browser info", (Throwable)e);
            }
        }
        if (this.deli != null && this._useDeli) {
            try {
                request = ObjectModelHelper.getRequest(this.objectModel);
                if (map == null) {
                    map = new HashMap();
                }
                Document deliCapabilities = this.deli.getUACapabilities(request);
                map.put("deli-capabilities", deliCapabilities);
                String accept = request.getParameter("accept");
                if (accept == null) {
                    accept = request.getHeader("accept");
                }
                map.put("accept", accept);
            }
            catch (Exception e) {
                this.getLogger().error("Error setting DELI info", (Throwable)e);
            }
        }
        return map;
    }

    static boolean isValidXSLTParameterName(String name) {
        if (name.length() == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int i = name.length() - 1;
        while (i > 1) {
            c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.') {
                return false;
            }
            --i;
        }
        return true;
    }

    public void dispose() {
        this.manager.release((Component)this.browser);
        this.manager.release((Component)this.xsltProcessor);
        this.manager.release((Component)this.deli);
        this.browser = null;
        this.xsltProcessor = null;
        this.deli = null;
        this.manager = null;
    }

    public void recycle() {
        this.xsltProcessor.setSourceResolver(null);
        this.transformerHandler = null;
        this.objectModel = null;
        if (this.inputSource != null) {
            this.inputSource.recycle();
            this.inputSource = null;
        }
        this.par = null;
        if (!this.finishedDocument) {
            try {
                super.endDocument();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.finishedDocument = false;
        super.recycle();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.finishedDocument = true;
    }
}

