/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.InputStream;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.AbstractSitemap;
import org.apache.cocoon.sitemap.Handler;
import org.apache.cocoon.sitemap.Manager;
import org.apache.cocoon.util.ClassUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class SitemapManager
extends Manager
implements Processor,
Configurable {
    protected String sitemapFileName;
    protected Handler sitemapHandler;

    public void configure(Configuration sconf) throws ConfigurationException {
        Configuration rolesConfig;
        super.configure(sconf);
        this.sitemapFileName = sconf.getAttribute("file");
        boolean checkReload = sconf.getAttributeAsBoolean("check-reload", true);
        boolean reloadAsynchron = sconf.getAttributeAsBoolean("reload-method", false);
        long checkDelay = sconf.getAttributeAsLong("check-delay", 1L) * 1000L;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sitemap location = " + this.sitemapFileName);
            this.getLogger().debug("Checking sitemap reload = " + checkReload);
            this.getLogger().debug("Reloading sitemap asynchron = " + reloadAsynchron);
            this.getLogger().debug("Sitemap check delay = " + checkDelay + " sec");
        }
        Parser p = null;
        try {
            try {
                p = (Parser)this.manager.lookup(Parser.ROLE);
                SAXConfigurationHandler b = new SAXConfigurationHandler();
                InputStream inputStream = ClassUtils.getResource("org/apache/cocoon/sitemap/sitemap.roles").openStream();
                InputSource is = new InputSource(inputStream);
                is.setSystemId("org/apache/cocoon/sitemap/sitemap.roles");
                p.parse(is, (ContentHandler)b);
                rolesConfig = b.getConfiguration();
            }
            catch (Exception e) {
                this.getLogger().error("Could not configure Cocoon environment", (Throwable)e);
                throw new ConfigurationException("Error trying to load configurations", (Throwable)e);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.manager.release((Component)p);
            throw throwable;
        }
        this.manager.release((Component)p);
        DefaultRoleManager sitemapRoleManager = new DefaultRoleManager();
        sitemapRoleManager.setLogger(this.getLogger());
        sitemapRoleManager.configure(rolesConfig);
        AbstractSitemap.setRoleManager((RoleManager)sitemapRoleManager, sconf);
        AbstractSitemap.setLogKitManager(this.sitemapLogKitManager);
        try {
            this.sitemapHandler = this.createHandler(this.manager, this.sitemapFileName, checkReload, reloadAsynchron, checkDelay);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create sitemap handler", (Throwable)e);
        }
    }

    public void generateSitemap(Environment environment) throws Exception {
        this.sitemapHandler.regenerate(environment);
    }

    public boolean process(Environment environment) throws Exception {
        return this.invoke(this.sitemapHandler, environment, "", this.sitemapFileName);
    }

    public boolean process(Environment environment, StreamPipeline pipeline, EventPipeline eventPipeline) throws Exception {
        return this.invoke(this.sitemapHandler, environment, "", this.sitemapFileName, pipeline, eventPipeline);
    }

    public void dispose() {
        this.sitemapHandler.dispose();
        this.sitemapHandler = null;
        super.dispose();
    }
}

