/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.language.generator.ProgramGenerator;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.source.CocoonSourceFactory;
import org.apache.cocoon.components.source.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.source.SourceHandler;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.sitemap.Sitemap;
import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

public class Handler
extends AbstractLoggable
implements Runnable,
Contextualizable,
Composable,
Processor,
Disposable,
SourceResolver {
    protected ComponentManager manager;
    protected ProgramGenerator programGenerator;
    protected SourceHandler sourceHandler;
    protected String sourceFileName;
    protected org.apache.cocoon.environment.Source source;
    protected String contextFileName;
    protected Sitemap sitemap = null;
    protected boolean check_reload = true;
    protected Thread regeneration;
    protected volatile boolean isRegenerationRunning = false;
    protected Exception exception;
    protected long checkDelay = 10000L;

    public void contextualize(Context context) throws ContextException {
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.sourceHandler = (SourceHandler)manager.lookup("org.apache.cocoon.components.source.SourceHandler");
        this.programGenerator = (ProgramGenerator)this.manager.lookup("org.apache.cocoon.components.language.generator.ProgramGenerator");
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setCheckReload(boolean check_reload) {
        this.check_reload = check_reload;
    }

    public void setCheckDelay(long delay) {
        this.checkDelay = delay;
    }

    protected boolean available() {
        return this.sitemap != null;
    }

    protected boolean hasChanged() {
        if (this.available()) {
            if (this.check_reload) {
                return this.sitemap.modifiedSince(this.source.getLastModified());
            }
            return false;
        }
        return true;
    }

    protected boolean isRegenerating() {
        return this.isRegenerationRunning;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void regenerateAsynchronously(Environment environment) throws Exception {
        if (this.sourceFileName.charAt(this.sourceFileName.length() - 1) == '/') {
            this.sourceFileName = this.sourceFileName + "sitemap.xmap";
        }
        SourceHandler oldSourceHandler = environment.getSourceHandler();
        try {
            block10: {
                environment.setSourceHandler(this.sourceHandler);
                if (this.source != null) {
                    this.source.recycle();
                }
                this.source = new DelayedRefreshSourceWrapper(environment.resolve(this.sourceFileName), this.checkDelay);
                org.apache.cocoon.environment.Source contextSource = null;
                try {
                    contextSource = environment.resolve("");
                    this.contextFileName = contextSource.getSystemId();
                    Object var5_5 = null;
                    if (contextSource == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (contextSource != null) {
                        contextSource.recycle();
                    }
                    throw throwable;
                }
                contextSource.recycle();
            }
            Object var7_8 = null;
            environment.setSourceHandler(oldSourceHandler);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            environment.setSourceHandler(oldSourceHandler);
            throw throwable;
        }
        if (!this.isRegenerationRunning) {
            this.isRegenerationRunning = true;
            this.regeneration = new Thread(this);
            try {
                this.regeneration.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.exception = null;
            this.regeneration.start();
        }
    }

    protected void regenerate(Environment environment) throws Exception {
        this.getLogger().debug("Beginning sitemap regeneration");
        Handler handler = this;
        synchronized (handler) {
            if (!this.available() || this.hasChanged()) {
                if (this.regeneration == null) {
                    this.regenerateAsynchronously(environment);
                }
                if (this.regeneration != null) {
                    this.regeneration.join();
                }
            }
        }
        this.throwEventualException();
    }

    public boolean process(Environment environment) throws Exception {
        boolean bl;
        this.checkSanity();
        SourceHandler oldSourceHandler = environment.getSourceHandler();
        CocoonComponentManager.enterEnvironment(environment, environment.getObjectModel(), this);
        environment.setComponentManager(this.manager);
        try {
            environment.setSourceHandler(this.sourceHandler);
            bl = this.sitemap.process(environment);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CocoonComponentManager.leaveEnvironment();
            environment.setSourceHandler(oldSourceHandler);
            throw throwable;
        }
        CocoonComponentManager.leaveEnvironment();
        environment.setSourceHandler(oldSourceHandler);
        return bl;
    }

    public boolean process(Environment environment, StreamPipeline pipeline, EventPipeline eventPipeline) throws Exception {
        boolean bl;
        this.checkSanity();
        SourceHandler oldSourceHandler = environment.getSourceHandler();
        CocoonComponentManager.enterEnvironment(environment, environment.getObjectModel(), this);
        environment.setComponentManager(this.manager);
        try {
            environment.setSourceHandler(this.sourceHandler);
            bl = this.sitemap.process(environment, pipeline, eventPipeline);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CocoonComponentManager.leaveEnvironment();
            environment.setSourceHandler(oldSourceHandler);
            throw throwable;
        }
        CocoonComponentManager.leaveEnvironment();
        environment.setSourceHandler(oldSourceHandler);
        return bl;
    }

    private void checkSanity() throws Exception {
        this.throwEventualException();
        if (this.sitemap == null) {
            this.getLogger().fatalError("Sitemap is not set for the Handler!!!!");
            throw new RuntimeException("The Sitemap is null, this should never be!");
        }
    }

    public void run() {
        Sitemap smap = null;
        String markupLanguage = "sitemap";
        String programmingLanguage = "java";
        try {
            block6: {
                try {
                    smap = (Sitemap)this.programGenerator.load(this.manager, this.source, markupLanguage, programmingLanguage, (SourceResolver)this);
                    if (smap instanceof AbstractLoggable) {
                        ((AbstractLoggable)smap).setLogger(this.getLogger());
                    }
                    Sitemap oldSitemap = this.sitemap;
                    this.sitemap = smap;
                    this.programGenerator.release(oldSitemap);
                    this.sourceHandler.addFactory("cocoon", new CocoonSourceFactory(this.sitemap, this.sitemap.getComponentManager()));
                    this.getLogger().debug("Sitemap regeneration complete");
                    if (this.sitemap != null) {
                        this.getLogger().debug("The sitemap has been successfully compiled!");
                        break block6;
                    }
                    this.getLogger().debug("No errors, but the sitemap has not been set.");
                }
                catch (Throwable t) {
                    this.getLogger().error("Error compiling sitemap", t);
                    this.exception = t instanceof Exception ? (Exception)t : new ProcessingException("Error compiling sitemap", t);
                    Object var6_7 = null;
                    this.regeneration = null;
                    this.isRegenerationRunning = false;
                }
            }
            Object var6_6 = null;
            this.regeneration = null;
            this.isRegenerationRunning = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.regeneration = null;
            this.isRegenerationRunning = false;
            throw throwable;
        }
    }

    public void throwEventualException() throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void dispose() {
        if (this.sitemap != null) {
            this.programGenerator.release(this.sitemap);
            this.sitemap = null;
        }
        if (this.source != null) {
            this.programGenerator.remove(this.source);
            this.source.recycle();
            this.source = null;
        }
        this.manager.release((Component)this.programGenerator);
        this.programGenerator = null;
        this.manager.release((Component)this.sourceHandler);
        this.sourceHandler = null;
        this.sourceFileName = null;
        this.exception = null;
        this.check_reload = true;
        this.regeneration = null;
        this.isRegenerationRunning = false;
        this.manager = null;
    }

    public org.apache.cocoon.environment.Source resolve(String systemId) throws ProcessingException, SAXException, IOException {
        if (systemId == null) {
            throw new SAXException("Invalid System ID");
        }
        URL context = new URL(this.contextFileName);
        if (systemId.length() == 0) {
            return this.sourceHandler.getSource(null, context, systemId);
        }
        if (systemId.indexOf(":") > 1) {
            return this.sourceHandler.getSource(null, systemId);
        }
        if (systemId.charAt(0) == '/') {
            return this.sourceHandler.getSource(null, context.getProtocol() + ":" + systemId);
        }
        return this.sourceHandler.getSource(null, context, systemId);
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException, ComponentException {
        return this.resolveURI(location, null, null);
    }

    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, ComponentException {
        throw new RuntimeException("Handler.resolveURI() is not implemented yet.");
    }

    public void release(Source source) {
        throw new RuntimeException("Handler.release() is not implemented yet.");
    }
}

