/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.AggregatedCacheValidity;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.TimeStampCacheValidity;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentAggregator
extends ContentHandlerWrapper
implements Generator,
Cacheable,
Recyclable {
    protected Element rootElement;
    protected ArrayList parts = new ArrayList();
    private AttributesImpl emptyAttrs = new AttributesImpl();
    private int rootElementIndex;
    protected Element currentElement;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContentAggregator: generating aggregated content");
        }
        this.contentHandler.startDocument();
        this.startElem(this.rootElement);
        try {
            int i = 0;
            while (true) {
                block11: {
                    Object var4_3;
                    if (i >= this.parts.size()) {
                        Object var6_5 = null;
                        break;
                    }
                    Part part = (Part)this.parts.get(i);
                    int n = this.rootElementIndex = part.stripRootElement ? -1 : 0;
                    if (part.element != null) {
                        this.currentElement = part.element;
                        this.startElem(part.element);
                    } else {
                        this.currentElement = this.rootElement;
                    }
                    try {
                        part.source.toSAX(this);
                        var4_3 = null;
                        if (part.element == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        if (part.element != null) {
                            this.endElem(part.element);
                        }
                        throw throwable;
                    }
                    this.endElem(part.element);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endElem(this.rootElement);
            this.contentHandler.endDocument();
            throw throwable;
        }
        this.endElem(this.rootElement);
        this.contentHandler.endDocument();
        this.getLogger().debug("ContentAggregator: finished aggregating content");
    }

    public long generateKey() {
        try {
            long key = HashUtil.hash("CA(" + this.rootElement.prefix + ':' + this.rootElement.name + '<' + this.rootElement.namespace + ">)");
            int i = 0;
            while (i < this.parts.size()) {
                Part part = (Part)this.parts.get(i);
                Source current = part.source;
                if (current.getLastModified() == 0L) {
                    return 0L;
                }
                key = part.element == null ? (key += HashUtil.hash("P=" + part.stripRootElement + ':' + current.getSystemId() + ';')) : (key += HashUtil.hash("P=" + part.element.prefix + ':' + part.element.name + '<' + part.element.namespace + ">:" + part.stripRootElement + ':' + current.getSystemId() + ';'));
                ++i;
            }
            return key;
        }
        catch (Exception e) {
            this.getLogger().error("ContentAggregator: could not generateKey", (Throwable)e);
            return 0L;
        }
    }

    public CacheValidity generateValidity() {
        try {
            AggregatedCacheValidity v = new AggregatedCacheValidity();
            int i = 0;
            while (i < this.parts.size()) {
                Source current = ((Part)this.parts.get((int)i)).source;
                if (current.getLastModified() == 0L) {
                    return null;
                }
                v.add(new TimeStampCacheValidity(current.getLastModified()));
                ++i;
            }
            return v;
        }
        catch (Exception e) {
            this.getLogger().error("ContentAggregator: could not generateKey", (Throwable)e);
            return null;
        }
    }

    public void setRootElement(String element, String namespace, String prefix) {
        this.rootElement = new Element(element, namespace, prefix);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContentAggregator: root element='" + element + "' ns='" + namespace + "' prefix='" + prefix + "'");
        }
    }

    public void addPart(String uri, String element, String namespace, String stripRootElement, String prefix) {
        Element elem = null;
        if (!element.equals("")) {
            elem = namespace.equals("") ? new Element(element, this.rootElement.namespace, this.rootElement.prefix) : new Element(element, namespace, prefix);
        }
        this.parts.add(new Part(uri, elem, stripRootElement));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContentAggregator: part uri='" + uri + "' element='" + element + "' ns='" + namespace + "' stripRootElement='" + stripRootElement + "' prefix='" + prefix + "'");
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler(consumer);
        this.setLexicalHandler(consumer);
    }

    public void recycle() {
        super.recycle();
        this.rootElement = null;
        Iterator i = this.parts.iterator();
        while (i.hasNext()) {
            Source source = ((Part)i.next()).source;
            if (null == source) continue;
            source.recycle();
        }
        this.parts.clear();
        this.currentElement = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        int i = 0;
        while (i < this.parts.size()) {
            Part current = (Part)this.parts.get(i);
            current.source = resolver.resolve(current.uri);
            ++i;
        }
    }

    private void startElem(Element element) throws SAXException {
        String qname;
        String string = qname = element.prefix.equals("") ? element.name : element.prefix + ':' + element.name;
        if (!element.namespace.equals("")) {
            this.contentHandler.startPrefixMapping(element.prefix, element.namespace);
        }
        this.contentHandler.startElement(element.namespace, element.name, qname, this.emptyAttrs);
    }

    private void endElem(Element element) throws SAXException {
        String qname = element.prefix.equals("") ? element.name : element.prefix + ':' + element.name;
        this.contentHandler.endElement(element.namespace, element.name, qname);
        if (!element.namespace.equals("")) {
            this.contentHandler.endPrefixMapping(element.prefix);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String raw, Attributes atts) throws SAXException {
        ++this.rootElementIndex;
        if (this.rootElementIndex == 0) {
            this.getLogger().debug("ContentAggregator: skipping root element start event.");
            return;
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            String qname = this.currentElement.prefix.equals("") ? localName : this.currentElement.prefix + ':' + localName;
            this.contentHandler.startElement(this.currentElement.namespace, localName, qname, atts);
        } else {
            this.contentHandler.startElement(namespaceURI, localName, raw, atts);
        }
    }

    public void endElement(String namespaceURI, String localName, String raw) throws SAXException {
        --this.rootElementIndex;
        if (this.rootElementIndex == -1) {
            this.getLogger().debug("ContentAggregator: skipping root element end event.");
            return;
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            String qname = this.currentElement.prefix.equals("") ? localName : this.currentElement.prefix + ':' + localName;
            this.contentHandler.endElement(this.currentElement.namespace, localName, qname);
        } else {
            this.contentHandler.endElement(namespaceURI, localName, raw);
        }
    }

    protected final class Element {
        public String namespace;
        public String prefix;
        public String name;

        public Element(String name, String namespace, String prefix) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.name = name;
        }
    }

    protected final class Part {
        public String uri;
        public Element element;
        public Source source;
        boolean stripRootElement;

        public Part(String uri, Element element, String stripRoot) {
            this.uri = uri;
            this.element = element;
            this.stripRootElement = stripRoot.equals("yes") || stripRoot.equals("true");
        }
    }
}

