/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.cocoon.servlet.ParanoidClassLoader;

public class BootstrapServlet
extends HttpServlet {
    public static final String SERVLET_CLASS = "org.apache.cocoon.servlet.CocoonServlet";
    protected Servlet servlet;
    protected ClassLoader classloader;
    protected ServletContext context;

    public void init(ServletConfig config2) throws ServletException {
        File contextDir;
        this.context = config2.getServletContext();
        this.context.log("getRealPath(\"/\") = " + this.context.getRealPath("/"));
        String contextDirParam = config2.getInitParameter("context-directory");
        if (contextDirParam == null) {
            contextDirParam = config2.getInitParameter("context-dir");
            if (contextDirParam == null) {
                String msg = "The 'context-directory' parameter must be set to the root of the servlet context";
                this.context.log(msg);
                throw new ServletException(msg);
            }
            this.context.log("Parameter 'context-dir' is deprecated - use 'context-directory'");
        }
        if (contextDirParam.endsWith("/")) {
            contextDirParam = contextDirParam.substring(0, contextDirParam.length() - 1);
        }
        if (!(contextDir = new File(contextDirParam)).exists()) {
            String msg = "Context dir '" + contextDir + "' doesn't exist";
            this.context.log(msg);
            throw new ServletException(msg);
        }
        if (!contextDir.isDirectory()) {
            String msg = "Context dir '" + contextDir + "' should be a directory";
            this.context.log(msg);
            throw new ServletException(msg);
        }
        this.context.log("Context dir set to " + contextDir);
        this.classloader = this.getClassLoader(contextDirParam);
        try {
            Class<?> servletClass = this.classloader.loadClass(SERVLET_CLASS);
            this.servlet = (Servlet)servletClass.newInstance();
        }
        catch (Exception e) {
            this.context.log("Cannot load servlet", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        Thread.currentThread().setContextClassLoader(this.classloader);
        ContextWrapper newContext = new ContextWrapper(this.context, contextDirParam);
        ConfigWrapper newConfig = new ConfigWrapper(config2, newContext);
        super.init((ServletConfig)newConfig);
        this.servlet.init((ServletConfig)newConfig);
    }

    protected ClassLoader getClassLoader(String contextDirParam) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File classDir = new File(contextDirParam + "/WEB-INF/classes");
            if (classDir.exists()) {
                if (!classDir.isDirectory()) {
                    String msg = classDir + " exists but is not a directory";
                    this.context.log(msg);
                    throw new ServletException(msg);
                }
                URL classURL = classDir.toURL();
                this.context.log("Adding class directory " + classURL);
                urlList.add(classURL);
            }
            File libDir = new File(contextDirParam + "/WEB-INF/lib");
            File[] libraries = libDir.listFiles();
            int i = 0;
            while (i < libraries.length) {
                URL lib = libraries[i].toURL();
                this.context.log("Adding class library " + lib);
                urlList.add(lib);
                ++i;
            }
        }
        catch (MalformedURLException mue) {
            this.context.log("Malformed url", (Throwable)mue);
            throw new ServletException((Throwable)mue);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return ParanoidClassLoader.newInstance(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Thread.currentThread().setContextClassLoader(this.classloader);
        this.servlet.service(request, response);
    }

    public void destroy() {
        super.destroy();
        Thread.currentThread().setContextClassLoader(this.classloader);
        this.servlet.destroy();
    }

    public static class ContextWrapper
    implements ServletContext {
        ServletContext context;
        String contextRoot;

        public ContextWrapper(ServletContext context, String contextRoot) {
            this.context = context;
            this.contextRoot = contextRoot;
        }

        public ServletContext getContext(String param) {
            return this.context.getContext(param);
        }

        public int getMajorVersion() {
            return this.context.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.context.getMinorVersion();
        }

        public String getMimeType(String param) {
            return this.context.getMimeType(param);
        }

        public URL getResource(String path) throws MalformedURLException {
            File file = new File(this.contextRoot + path);
            if (file.exists()) {
                URL result = file.toURL();
                return result;
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                return url == null ? null : url.openStream();
            }
            catch (Exception e) {
                this.context.log("getResourceAsStream(" + path + ") failed", (Throwable)e);
                return null;
            }
        }

        public RequestDispatcher getRequestDispatcher(String param) {
            return this.context.getRequestDispatcher(param);
        }

        public RequestDispatcher getNamedDispatcher(String param) {
            return this.context.getNamedDispatcher(param);
        }

        public Servlet getServlet(String param) throws ServletException {
            return this.context.getServlet(param);
        }

        public Enumeration getServlets() {
            return this.context.getServlets();
        }

        public Enumeration getServletNames() {
            return this.context.getServletNames();
        }

        public void log(String msg) {
            this.context.log(msg);
        }

        public void log(Exception ex, String msg) {
            this.context.log(ex, msg);
        }

        public void log(String msg, Throwable thr) {
            this.context.log(msg, thr);
        }

        public String getRealPath(String path) {
            String result = this.contextRoot + path;
            return result;
        }

        public String getServerInfo() {
            return this.context.getServerInfo();
        }

        public String getInitParameter(String param) {
            return this.context.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return this.context.getInitParameterNames();
        }

        public Object getAttribute(String param) {
            Object result = this.context.getAttribute(param);
            return result;
        }

        public Enumeration getAttributeNames() {
            return this.context.getAttributeNames();
        }

        public void setAttribute(String name, Object value) {
            this.context.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this.context.removeAttribute(name);
        }

        public Set getResourcePaths(String param) {
            return null;
        }

        public String getServletContextName() {
            return "Cocoon context";
        }
    }

    public static class ConfigWrapper
    implements ServletConfig {
        ServletConfig config;
        ServletContext context;

        public ConfigWrapper(ServletConfig config2, ServletContext context) {
            this.config = config2;
            this.context = context;
        }

        public String getServletName() {
            return this.config.getServletName();
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String name) {
            return this.config.getInitParameter(name);
        }
    }
}

