/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.generation.ComposerGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ScriptGenerator
extends ComposerGenerator
implements Configurable {
    protected BSFLanguage[] additionalLanguages;
    private Source inputSource;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration languagesToAdd = conf.getChild("add-languages");
            Configuration[] languages = languagesToAdd.getChildren("language");
            this.additionalLanguages = new BSFLanguage[languages.length];
            int i = 0;
            while (i < languages.length) {
                Configuration language = languages[i];
                BSFLanguage bsfLanguage = new BSFLanguage();
                bsfLanguage.name = language.getAttribute("name");
                bsfLanguage.engineSrc = language.getAttribute("src");
                this.getLogger().debug("Configuring ScriptGenerator with additional BSF language " + bsfLanguage.name);
                this.getLogger().debug("Configuring ScriptGenerator with BSF engine " + bsfLanguage.engineSrc);
                Configuration[] extensions = language.getChildren("extension");
                bsfLanguage.extensions = new String[extensions.length];
                int j = 0;
                while (j < extensions.length) {
                    bsfLanguage.extensions[i] = extensions[i].getValue();
                    this.getLogger().debug("Configuring ScriptGenerator with lang extension " + bsfLanguage.extensions[i]);
                    ++j;
                }
                this.additionalLanguages[i] = bsfLanguage;
                ++i;
            }
        }
    }

    public void recycle() {
        super.recycle();
        if (this.inputSource != null) {
            this.inputSource.recycle();
            this.inputSource = null;
        }
    }

    public void generate() throws ProcessingException {
        Parser parser = null;
        try {
            try {
                this.getLogger().debug("processing file [" + this.source + "]");
                this.inputSource = this.resolver.resolve(this.source);
                this.getLogger().debug("file resolved to [" + this.inputSource.getSystemId() + "]");
                InputStreamReader in = new InputStreamReader(this.inputSource.getInputStream());
                BSFManager mgr = new BSFManager();
                if (this.additionalLanguages != null) {
                    int i = 0;
                    while (i < this.additionalLanguages.length) {
                        this.getLogger().debug("adding BSF language " + this.additionalLanguages[i].name + " with engine " + this.additionalLanguages[i].engineSrc);
                        BSFManager.registerScriptingEngine((String)this.additionalLanguages[i].name, (String)this.additionalLanguages[i].engineSrc, (String[])this.additionalLanguages[i].extensions);
                        ++i;
                    }
                }
                StringBuffer output = new StringBuffer();
                mgr.registerBean("resolver", (Object)this.resolver);
                mgr.registerBean("source", (Object)this.source);
                mgr.registerBean("objectModel", (Object)this.objectModel);
                mgr.registerBean("parameters", (Object)this.parameters);
                mgr.registerBean("output", (Object)output);
                mgr.registerBean("logger", (Object)this.getLogger());
                this.getLogger().debug("BSFManager execution begining");
                mgr.exec(BSFManager.getLangFromFilename((String)this.inputSource.getSystemId()), this.inputSource.getSystemId(), 0, 0, (Object)IOUtils.getStringFromReader((Reader)in));
                this.getLogger().debug("BSFManager execution complete");
                this.getLogger().debug("output = [" + output.toString() + "]");
                InputSource xmlInput = new InputSource(new StringReader(output.toString()));
                parser = (Parser)this.manager.lookup(Parser.ROLE);
                parser.parse(xmlInput, (ContentHandler)this.xmlConsumer);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException("Could not load script " + this.inputSource.getSystemId(), e);
            }
            catch (BSFException e) {
                throw new ProcessingException("Exception in ScriptGenerator.generate()", e);
            }
            catch (Exception e) {
                throw new ProcessingException("Exception in ScriptGenerator.generate()", e);
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    protected class BSFLanguage {
        public String name;
        public String engineSrc;
        public String[] extensions;

        protected BSFLanguage() {
        }
    }
}

