/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServletGenerator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RequestGenerator
extends ServletGenerator
implements Parameterizable {
    private String URI = "http://xml.apache.org/cocoon/requestgenerator/2.0";
    private String global_container_encoding;
    private String global_form_encoding;
    private String container_encoding;
    private String form_encoding;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.global_container_encoding = parameters.getParameter("container-encoding", "ISO-8859-1");
        this.global_form_encoding = parameters.getParameter("form-encoding", null);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.container_encoding = par.getParameter("container-encoding", this.global_container_encoding);
        this.form_encoding = par.getParameter("form-encoding", this.global_form_encoding);
    }

    public void generate() throws SAXException {
        Request request = ObjectModelHelper.getRequest(this.objectModel);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", this.URI);
        AttributesImpl attr = new AttributesImpl();
        this.attribute(attr, "target", request.getRequestURI());
        this.attribute(attr, "source", this.source != null ? this.source : "");
        this.start("request", attr);
        this.data("\n");
        this.data("\n");
        this.data("  ");
        this.start("requestHeaders", attr);
        this.data("\n");
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            this.attribute(attr, "name", header);
            this.data("    ");
            this.start("header", attr);
            this.data(request.getHeader(header));
            this.end("header");
            this.data("\n");
        }
        this.data("  ");
        this.end("requestHeaders");
        this.data("\n");
        this.data("\n");
        this.data("  ");
        this.start("requestParameters", attr);
        this.data("\n");
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            this.attribute(attr, "name", parameter);
            this.data("    ");
            this.start("parameter", attr);
            this.data("\n");
            String[] values = request.getParameterValues(parameter);
            if (values != null) {
                int x = 0;
                while (x < values.length) {
                    this.data("      ");
                    this.start("value", attr);
                    if (this.form_encoding != null) {
                        try {
                            this.data(new String(values[x].getBytes(this.container_encoding), this.form_encoding));
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
                        }
                    } else {
                        this.data(values[x]);
                    }
                    this.end("value");
                    this.data("\n");
                    ++x;
                }
            }
            this.data("    ");
            this.end("parameter");
            this.data("\n");
        }
        this.data("  ");
        this.end("requestParameters");
        this.data("\n");
        this.data("\n");
        this.data("  ");
        this.start("configurationParameters", attr);
        this.data("\n");
        String[] confparams = this.parameters.getNames();
        int i = 0;
        while (i < confparams.length) {
            this.attribute(attr, "name", confparams[i]);
            this.data("    ");
            this.start("parameter", attr);
            this.data(this.parameters.getParameter(confparams[i], ""));
            this.end("parameter");
            this.data("\n");
            ++i;
        }
        this.data("  ");
        this.end("configurationParameters");
        this.data("\n");
        this.data("\n");
        this.end("request");
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private void attribute(AttributesImpl attr, String name, String value) {
        attr.addAttribute("", name, name, "CDATA", value);
    }

    private void start(String name, AttributesImpl attr) throws SAXException {
        this.contentHandler.startElement(this.URI, name, name, attr);
        attr.clear();
    }

    private void end(String name) throws SAXException {
        this.contentHandler.endElement(this.URI, name, name);
    }

    private void data(String data) throws SAXException {
        this.contentHandler.characters(data.toCharArray(), 0, data.length());
    }
}

