/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.components.request.RequestFactory;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.http.HttpContext;
import org.apache.cocoon.environment.http.HttpRequest;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.util.NetUtils;

public class HttpEnvironment
extends AbstractEnvironment
implements Redirector {
    public static final String HTTP_REQUEST_OBJECT = "httprequest";
    public static final String HTTP_RESPONSE_OBJECT = "httpresponse";
    public static final String HTTP_SERVLET_CONTEXT = "httpservletcontext";
    private HttpRequest request = null;
    private HttpResponse response = null;
    private HttpContext webcontext = null;
    private OutputStream outputStream = null;
    private String contentType = null;
    private boolean hasRedirected = false;

    public HttpEnvironment(String uri, URL rootURL, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, HttpContext context, String containerEncoding, String defaultFormEncoding, RequestFactory requestFactory) throws MalformedURLException, IOException {
        super(uri, req.getParameter("cocoon-view"), rootURL, HttpEnvironment.extractAction(req));
        this.request = new HttpRequest(req, this, requestFactory);
        this.request.setCharacterEncoding(defaultFormEncoding);
        this.request.setContainerEncoding(containerEncoding);
        this.response = new HttpResponse(res);
        this.webcontext = context;
        this.outputStream = this.response.getOutputStream();
        this.objectModel.put("request", this.request);
        this.objectModel.put("response", this.response);
        this.objectModel.put("context", this.webcontext);
        this.objectModel.put(HTTP_REQUEST_OBJECT, req);
        this.objectModel.put(HTTP_RESPONSE_OBJECT, res);
        this.objectModel.put(HTTP_SERVLET_CONTEXT, servletContext);
    }

    private static final String extractAction(HttpServletRequest req) {
        String action = req.getParameter("cocoon-action");
        if (action != null) {
            return action;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("cocoon-action-")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                return name.substring("cocoon-action-".length(), name.length() - 2);
            }
            return name.substring("cocoon-action-".length());
        }
        return null;
    }

    public void redirect(boolean sessionmode, String newURL) throws IOException {
        if (this.request == null) {
            this.getLogger().debug("redirect: something's broken, request = null");
            return;
        }
        this.hasRedirected = true;
        if (sessionmode) {
            Session session = null;
            this.getLogger().debug("redirect: entering session mode");
            String s = this.request.getRequestedSessionId();
            if (s != null) {
                this.getLogger().debug("Old session ID found in request, id = " + s);
                if (this.request.isRequestedSessionIdValid()) {
                    this.getLogger().debug("And this old session ID is valid");
                }
            }
            if ((session = this.request.getSession(true)) == null) {
                this.getLogger().debug("redirect session mode: unable to get session object!");
            }
            this.getLogger().debug("redirect: session mode completed, id = " + session.getId());
        }
        String redirect = this.response.encodeRedirectURL(newURL);
        if (!newURL.startsWith("/") && newURL.indexOf(58) == -1 && redirect.indexOf(58) != -1) {
            this.getLogger().debug("Redirect: WebSpehere Bug Detected!");
            String base = NetUtils.getPath(this.request.getRequestURI());
            if (base.startsWith("/")) {
                base = base.substring(1);
            }
            redirect = this.response.encodeRedirectURL(base + '/' + newURL);
        }
        this.getLogger().debug("Sending redirect to '" + redirect + "'");
        this.response.sendRedirect(redirect);
    }

    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    public void setStatus(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentLength(int length) {
        this.response.setContentLength(length);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public boolean isResponseModified(long lastModified) {
        return true;
    }

    public void setResponseIsNotModified() {
        this.response.setStatus(304);
    }

    public boolean tryResetResponse() {
        try {
            if (!this.response.isCommitted()) {
                this.response.reset();
                this.getLogger().debug("Response successfully reset");
                return true;
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Problem resetting response", (Throwable)e);
        }
        this.getLogger().debug("Response wasn't reset");
        return false;
    }
}

