/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.environment.Context;

public final class HttpContext
implements Context {
    private final ServletContext servletContext;

    public HttpContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object getAttribute(String name) {
        return this.servletContext.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.servletContext.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.servletContext.removeAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public String getRealPath(String path) {
        if (path.equals("/")) {
            String value = this.servletContext.getRealPath(path);
            if (value == null) {
                try {
                    value = this.servletContext.getResource("/WEB-INF").toString();
                }
                catch (MalformedURLException mue) {
                    throw new CascadingRuntimeException("Cannot determine the base URL for " + path, (Throwable)mue);
                }
                value = value.substring(0, value.length() - "WEB-INF".length());
            }
            return value;
        }
        return this.servletContext.getRealPath(path);
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }
}

