/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.PipelineEventComponentProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.PatternException;

public class SerializeNode
extends PipelineEventComponentProcessingNode {
    private String serializerName;
    private String mimeType;
    private int statusCode;

    public SerializeNode(String name, String mimeType, int statusCode) throws PatternException {
        this.serializerName = name;
        this.mimeType = mimeType;
        this.statusCode = statusCode;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        ProcessingNode viewNode;
        String cocoonView;
        if (this.views != null && (cocoonView = env.getView()) != null && (viewNode = (ProcessingNode)this.views.get(cocoonView)) != null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Jumping to view " + cocoonView + " from serializer at " + this.getLocation());
            }
            return viewNode.invoke(env, context);
        }
        if (env.getObjectModel().containsKey("link")) {
            context.getEventPipeline().addTransformer("<translator>", null, Parameters.EMPTY_PARAMETERS);
        }
        StreamPipeline pipeline = context.getStreamPipeline();
        List mapStack = context.getMapStack();
        Map objectModel = env.getObjectModel();
        if (this.mimeType == null) {
            pipeline.setSerializer(this.serializerName, null, Parameters.EMPTY_PARAMETERS);
        } else {
            pipeline.setSerializer(this.serializerName, null, Parameters.EMPTY_PARAMETERS, this.mimeType);
        }
        if (this.statusCode >= 0) {
            env.setStatus(this.statusCode);
        }
        if (!context.isInternalRequest()) {
            return pipeline.process(env);
        }
        return true;
    }
}

