/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.pipeline.NonCachingEventPipeline;
import org.apache.cocoon.components.profiler.Profiler;
import org.apache.cocoon.components.profiler.ProfilerData;
import org.apache.cocoon.environment.Environment;

public class ProfilingNonCachingEventPipeline
extends NonCachingEventPipeline
implements Recyclable,
Composable,
Disposable {
    private ComponentManager manager;
    private Profiler profiler;
    private ProfilerData data = null;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        try {
            this.manager = manager;
            this.profiler = (Profiler)manager.lookup("org.apache.cocoon.components.profiler.Profiler");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.profiler != null) {
            this.manager.release((Component)this.profiler);
            this.profiler = null;
        }
        this.manager = null;
    }

    public void setGenerator(String role, String source, Parameters param, Exception e) throws Exception {
        super.setGenerator(role, source, param, e);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.setGenerator(this.generator, role, source);
    }

    public void setGenerator(String role, String source, Parameters param) throws Exception {
        super.setGenerator(role, source, param);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.setGenerator(this.generator, role, source);
    }

    public void addTransformer(String role, String source, Parameters param) throws Exception {
        super.addTransformer(role, source, param);
        if (this.data == null) {
            this.data = new ProfilerData();
        }
        this.data.addComponent(this.transformers.get(this.transformers.size() - 1), role, source);
    }

    public boolean process(Environment environment) throws Exception {
        this.data.addComponent(this.xmlConsumer, null, null);
        environment.getObjectModel().put("profiler", this.data);
        long time = System.currentTimeMillis();
        boolean result = super.process(environment);
        this.data.setTime(0, System.currentTimeMillis() - time);
        this.profiler.addResult(environment.getURI(), this.data);
        return result;
    }

    public void recycle() {
        this.data = null;
        super.recycle();
    }
}

