/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Vector;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.cocoon.util.ClassUtils;
import org.apache.log.Logger;

public class RepositoryClassLoader
extends URLClassLoader
implements Loggable {
    protected Logger log;

    public RepositoryClassLoader() {
        super(new URL[0], ClassUtils.getClassLoader());
    }

    public RepositoryClassLoader(URL[] urls) {
        super(urls, ClassUtils.getClassLoader());
    }

    public RepositoryClassLoader(URL[] urls, ClassLoader parentClassLoader) {
        super(urls, parentClassLoader);
    }

    public void setLogger(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    protected RepositoryClassLoader(Vector repositories) {
        this();
        Iterator i = repositories.iterator();
        while (i.hasNext()) {
            try {
                this.addDirectory((File)i.next());
            }
            catch (IOException ioe) {
                this.log.error("Repository could not be added", (Throwable)ioe);
            }
        }
    }

    public void addDirectory(File repository) throws IOException {
        try {
            this.addURL(repository.getCanonicalFile().toURL());
        }
        catch (MalformedURLException mue) {
            this.log.error("The repository had a bad URL", (Throwable)mue);
            throw new IOException("Could not add repository");
        }
    }

    public void addDirectory(String repository) throws IOException {
        try {
            File file = new File(repository);
            this.addURL(file.getCanonicalFile().toURL());
        }
        catch (MalformedURLException mue) {
            this.log.error("The repository had a bad URL", (Throwable)mue);
            throw new IOException("Could not add repository");
        }
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public Class defineClass(byte[] b) throws ClassFormatError {
        return super.defineClass(null, b, 0, b.length);
    }
}

