/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.acting.modular.DatabaseAction;
import org.apache.cocoon.components.modules.database.AutoIncrementModule;
import org.apache.cocoon.util.HashMap;

public class DatabaseAddAction
extends DatabaseAction {
    protected int processRow(Map objectModel, Connection conn, PreparedStatement statement, String outputMode, Configuration table, DatabaseAction.CacheHelper queryData, Object[][] columnValues, int rowIndex, Map results) throws SQLException, ConfigurationException, Exception {
        int currentIndex = 1;
        int i = 0;
        while (i < queryData.columns.length) {
            DatabaseAction.Column col = queryData.columns[i];
            if (col.isAutoIncrement && col.isKey) {
                currentIndex += this.setKeyAuto(table, col, currentIndex, rowIndex, conn, statement, objectModel, outputMode, results);
            } else {
                this.setOutput(objectModel, outputMode, results, table, col.columnConf, rowIndex, columnValues[i][col.isSet ? rowIndex : 0]);
                this.setColumn(statement, currentIndex, col.columnConf, columnValues[i][col.isSet ? rowIndex : 0]);
                ++currentIndex;
            }
            ++i;
        }
        int rowCount = statement.executeUpdate();
        int i2 = 0;
        while (i2 < queryData.columns.length) {
            if (queryData.columns[i2].isAutoIncrement && queryData.columns[i2].isKey) {
                this.storeKeyValue(table, queryData.columns[i2], rowIndex, conn, statement, objectModel, outputMode, results);
            }
            ++i2;
        }
        return rowCount;
    }

    protected int setKeyAuto(Configuration table, DatabaseAction.Column column, int currentIndex, int rowIndex, Connection conn, PreparedStatement statement, Map objectModel, String outputMode, Map results) throws ConfigurationException, SQLException, ComponentException, Exception {
        int columnCount;
        block9: {
            ComponentSelector autoincrSelector;
            block10: {
                columnCount = 0;
                autoincrSelector = null;
                AutoIncrementModule autoincr = null;
                try {
                    autoincrSelector = (ComponentSelector)this.manager.lookup("org.apache.cocoon.components.modules.database.AutoIncrementModuleSelector");
                    if (column.mode != null && autoincrSelector != null && autoincrSelector.hasComponent((Object)column.mode)) {
                        autoincr = (AutoIncrementModule)autoincrSelector.select((Object)column.mode);
                    }
                    if (autoincr.includeInQuery()) {
                        if (autoincr.includeAsValue()) {
                            Object value = autoincr.getPreValue(table, column.columnConf, column.modeConf, conn, objectModel);
                            this.setColumn(objectModel, outputMode, results, table, column.columnConf, rowIndex, value, statement, currentIndex);
                            columnCount = 1;
                        }
                    } else if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Automatically setting key");
                    }
                    Object var15_14 = null;
                    if (autoincrSelector == null) break block9;
                    if (autoincr == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    if (autoincrSelector != null) {
                        if (autoincr != null) {
                            autoincrSelector.release((Component)autoincr);
                        }
                        this.manager.release((Component)autoincrSelector);
                    }
                    throw throwable;
                }
                autoincrSelector.release((Component)autoincr);
            }
            this.manager.release((Component)autoincrSelector);
            {
            }
        }
        return columnCount;
    }

    protected void storeKeyValue(Configuration tableConf, DatabaseAction.Column key, int rowIndex, Connection conn, Statement statement, Map objectModel, String outputMode, Map results) throws SQLException, ConfigurationException, ComponentException {
        block6: {
            ComponentSelector autoincrSelector;
            block7: {
                autoincrSelector = null;
                AutoIncrementModule autoincr = null;
                try {
                    autoincrSelector = (ComponentSelector)this.manager.lookup("org.apache.cocoon.components.modules.database.AutoIncrementModuleSelector");
                    if (key.mode != null && autoincrSelector != null && autoincrSelector.hasComponent((Object)key.mode)) {
                        autoincr = (AutoIncrementModule)autoincrSelector.select((Object)key.mode);
                    }
                    if (!autoincr.includeAsValue()) {
                        Object value = autoincr.getPostValue(tableConf, key.columnConf, key.modeConf, conn, statement, objectModel);
                        this.setOutput(objectModel, outputMode, results, tableConf, key.columnConf, rowIndex, value);
                    }
                    Object var13_12 = null;
                    if (autoincrSelector == null) break block6;
                    if (autoincr == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (autoincrSelector != null) {
                        if (autoincr != null) {
                            autoincrSelector.release((Component)autoincr);
                        }
                        this.manager.release((Component)autoincrSelector);
                    }
                    throw throwable;
                }
                autoincrSelector.release((Component)autoincr);
            }
            this.manager.release((Component)autoincrSelector);
            {
            }
        }
    }

    protected String selectMode(boolean isAutoIncrement, Map modes) {
        if (isAutoIncrement) {
            return (String)modes.get(DatabaseAction.MODE_AUTOINCR);
        }
        return (String)modes.get(DatabaseAction.MODE_OTHERS);
    }

    protected boolean honourAutoIncrement() {
        return true;
    }

    protected Object[][] getColumnValues(Configuration tableConf, DatabaseAction.CacheHelper queryData, Map objectModel) throws ConfigurationException, ComponentException {
        Object[][] columnValues = new Object[queryData.columns.length][];
        int i = 0;
        while (i < queryData.columns.length) {
            columnValues[i] = this.getColumnValue(tableConf, queryData.columns[i], objectModel);
            ++i;
        }
        return columnValues;
    }

    protected DatabaseAction.CacheHelper getQuery(Configuration table, Map modeTypes, Map defaultModeNames) throws ConfigurationException, ComponentException {
        DatabaseAction.LookUpKey lookUpKey = new DatabaseAction.LookUpKey(table, modeTypes);
        DatabaseAction.CacheHelper queryData = null;
        HashMap hashMap = this.cachedQueryData;
        synchronized (hashMap) {
            queryData = (DatabaseAction.CacheHelper)this.cachedQueryData.get(lookUpKey);
            if (queryData == null) {
                Configuration[] values = table.getChild("values").getChildren("value");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                queryData = new DatabaseAction.CacheHelper(keys.length, keys.length + values.length);
                this.fillModes(keys, true, defaultModeNames, modeTypes, queryData);
                this.fillModes(values, false, defaultModeNames, modeTypes, queryData);
                StringBuffer queryBuffer = new StringBuffer("INSERT INTO ");
                StringBuffer valueBuffer = new StringBuffer(") VALUES (");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" (");
                int actualColumns = 0;
                int i = 0;
                while (i < queryData.columns.length) {
                    block18: {
                        if (actualColumns > 0) {
                            queryBuffer.append(", ");
                            valueBuffer.append(", ");
                        }
                        if (queryData.columns[i].isKey && queryData.columns[i].isAutoIncrement) {
                            ComponentSelector autoincrSelector;
                            block19: {
                                Object var17_15;
                                autoincrSelector = null;
                                AutoIncrementModule autoincr = null;
                                try {
                                    autoincrSelector = (ComponentSelector)this.manager.lookup("org.apache.cocoon.components.modules.database.AutoIncrementModuleSelector");
                                    if (queryData.columns[i].mode != null && autoincrSelector != null && autoincrSelector.hasComponent((Object)queryData.columns[i].mode)) {
                                        autoincr = (AutoIncrementModule)autoincrSelector.select((Object)queryData.columns[i].mode);
                                        if (autoincr.includeInQuery()) {
                                            ++actualColumns;
                                            queryBuffer.append(queryData.columns[i].columnConf.getAttribute("name"));
                                            if (autoincr.includeAsValue()) {
                                                valueBuffer.append("?");
                                            } else {
                                                valueBuffer.append(autoincr.getSubquery(table, queryData.columns[i].columnConf, queryData.columns[i].modeConf));
                                            }
                                        }
                                    } else {
                                        if (this.getLogger().isErrorEnabled()) {
                                            this.getLogger().error("Could not find mode description " + queryData.columns[i].mode + " for column #" + i);
                                        }
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug("Column data " + queryData.columns[i]);
                                        }
                                        throw new ConfigurationException("Could not find mode description " + queryData.columns[i].mode + " for column " + i);
                                    }
                                    var17_15 = null;
                                    if (autoincrSelector == null) break block18;
                                    if (autoincr == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    var17_15 = null;
                                    if (autoincrSelector != null) {
                                        if (autoincr != null) {
                                            autoincrSelector.release(autoincr);
                                        }
                                        this.manager.release((Component)autoincrSelector);
                                    }
                                    throw throwable;
                                }
                                autoincrSelector.release((Component)autoincr);
                            }
                            this.manager.release((Component)autoincrSelector);
                            {
                                break block18;
                            }
                        }
                        ++actualColumns;
                        queryBuffer.append(queryData.columns[i].columnConf.getAttribute("name"));
                        valueBuffer.append("?");
                    }
                    ++i;
                }
                valueBuffer.append(")");
                queryBuffer.append((Object)valueBuffer);
                queryData.queryString = queryBuffer.toString();
                this.cachedQueryData.put(lookUpKey, queryData);
            }
        }
        return queryData;
    }
}

