/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractConfigurableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class SessionPropagatorAction
extends AbstractConfigurableAction
implements ThreadSafe {
    private Object[] defaults = new Object[0];

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            String[] names = new String[]{};
            super.configure(conf);
            this.defaults = this.settings.keySet().toArray();
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Request req = ObjectModelHelper.getRequest(objectModel);
        HashMap<String, String> actionMap = new HashMap<String, String>();
        HashMap<String, Integer> isDone = new HashMap<String, Integer>();
        Integer dummy = new Integer(1);
        if (req == null) {
            this.getLogger().debug("SESSIONPROPAGATOR: no request object");
            return null;
        }
        Session session = req.getSession(false);
        if (session == null) {
            this.getLogger().debug("SESSIONPROPAGATOR: no session object");
            return null;
        }
        try {
            String[] names = parameters.getNames();
            int i = 0;
            while (i < names.length) {
                String sessionParamName = names[i];
                if (sessionParamName == null || "".equals(sessionParamName.trim())) {
                    return null;
                }
                isDone.put(sessionParamName, dummy);
                String value = parameters.getParameter(sessionParamName);
                this.getLogger().debug("SESSIONPROPAGATOR: propagating value " + value + " to session attribute " + sessionParamName);
                session.setAttribute(sessionParamName, value);
                actionMap.put(sessionParamName, value);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.defaults.length) {
                if (!isDone.containsKey(this.defaults[i2])) {
                    String sessionParamName = (String)this.defaults[i2];
                    if (sessionParamName == null || "".equals(sessionParamName.trim())) {
                        return null;
                    }
                    isDone.put(sessionParamName, dummy);
                    String value = parameters.getParameter(sessionParamName);
                    this.getLogger().debug("SESSIONPROPAGATOR: propagating value " + value + " to session attribute " + sessionParamName);
                    session.setAttribute(sessionParamName, value);
                    actionMap.put(sessionParamName, value);
                }
                ++i2;
            }
            this.getLogger().debug("SESSIONPROPAGATOR: all params propagated to session");
            return Collections.unmodifiableMap(actionMap);
        }
        catch (Exception e) {
            this.getLogger().debug("exception: ", (Throwable)e);
            return null;
        }
    }
}

