/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.tools.jpeg;

class DCT {
    private Object[] quantum = new Object[2];
    private Object[] divisors = new Object[2];
    private static int dctBlockSize = 8;

    DCT(int n) {
        this.initMatrix(n);
    }

    public void dispose() {
    }

    int[] getQuantumArray(int n) {
        return (int[])this.quantum[n];
    }

    int[] quantizeBlock(double[][] dArray, int n) {
        int[] nArray = new int[dctBlockSize * dctBlockSize];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            int n4 = 0;
            while (n4 < 8) {
                nArray[n2] = (int)Math.round(dArray[n3][n4] * ((double[])this.divisors[n])[n2]);
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }

    private void initMatrix(int n) {
        int n2;
        double[] dArray = new double[]{1.0, 1.387039845, 1.306562965, 1.175875602, 1.0, 0.785694958, 0.5411961, 0.275899379};
        if (n <= 0) {
            n = 1;
        } else if (n > 100) {
            n = 100;
        }
        n = n < 50 ? 5000 / n : 200 - n * 2;
        int[] nArray = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
        int n3 = 0;
        while (n3 < 64) {
            n2 = (nArray[n3] * n + 50) / 100;
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            nArray[n3] = n2;
            ++n3;
        }
        n2 = 0;
        double[] dArray2 = new double[dctBlockSize * dctBlockSize];
        int n4 = 0;
        while (n4 < 8) {
            int n5 = 0;
            while (n5 < 8) {
                dArray2[n2] = 1.0 / ((double)nArray[n2] * dArray[n4] * dArray[n5] * 8.0);
                ++n2;
                ++n5;
            }
            ++n4;
        }
        int[] nArray2 = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        int n6 = 0;
        while (n6 < 64) {
            int n7 = (nArray2[n6] * n + 50) / 100;
            if (n7 <= 0) {
                n7 = 1;
            }
            if (n7 >= 255) {
                n7 = 255;
            }
            nArray2[n6] = n7;
            ++n6;
        }
        n2 = 0;
        double[] dArray3 = new double[dctBlockSize * dctBlockSize];
        int n8 = 0;
        while (n8 < 8) {
            int n9 = 0;
            while (n9 < 8) {
                dArray3[n2] = 1.0 / ((double)nArray2[n2] * dArray[n8] * dArray[n9] * 8.0);
                ++n2;
                ++n9;
            }
            ++n8;
        }
        this.quantum[0] = nArray;
        this.divisors[0] = dArray2;
        this.quantum[1] = nArray2;
        this.divisors[1] = dArray3;
    }

    private double[][] forwardDCTExtreme(float[][] fArray) {
        double[][] dArray = new double[dctBlockSize][dctBlockSize];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                int n3 = 0;
                while (n3 < 8) {
                    int n4 = 0;
                    while (n4 < 8) {
                        double[] dArray2 = dArray[n];
                        int n5 = n2;
                        dArray2[n5] = dArray2[n5] + (double)fArray[n3][n4] * Math.cos((double)(2 * n3 + 1) * (double)n2 * Math.PI / 16.0) * Math.cos((double)(2 * n4 + 1) * (double)n * Math.PI / 16.0);
                        ++n4;
                    }
                    ++n3;
                }
                double[] dArray3 = dArray[n];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] * (0.25 * (n2 == 0 ? 1.0 / Math.sqrt(2.0) : 1.0) * (n == 0 ? 1.0 / Math.sqrt(2.0) : 1.0));
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    double[][] forwardDCT(float[][] fArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double[][] dArray = new double[dctBlockSize][dctBlockSize];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                dArray[n][n2] = (double)fArray[n][n2] - 128.0;
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < 8) {
            d19 = dArray[n][0] + dArray[n][7];
            d18 = dArray[n][0] - dArray[n][7];
            d17 = dArray[n][1] + dArray[n][6];
            d16 = dArray[n][1] - dArray[n][6];
            d15 = dArray[n][2] + dArray[n][5];
            d14 = dArray[n][2] - dArray[n][5];
            d13 = dArray[n][3] + dArray[n][4];
            d12 = dArray[n][3] - dArray[n][4];
            d11 = d19 + d13;
            d10 = d19 - d13;
            d9 = d17 + d15;
            d8 = d17 - d15;
            dArray[n][0] = d11 + d9;
            dArray[n][4] = d11 - d9;
            d7 = (d8 + d10) * 0.707106781;
            dArray[n][2] = d10 + d7;
            dArray[n][6] = d10 - d7;
            d11 = d12 + d14;
            d9 = d14 + d16;
            d8 = d16 + d18;
            d6 = (d11 - d8) * 0.382683433;
            d5 = 0.5411961 * d11 + d6;
            d4 = 1.306562965 * d8 + d6;
            d3 = d9 * 0.707106781;
            d2 = d18 + d3;
            d = d18 - d3;
            dArray[n][5] = d + d5;
            dArray[n][3] = d - d5;
            dArray[n][1] = d2 + d4;
            dArray[n][7] = d2 - d4;
            ++n;
        }
        n = 0;
        while (n < 8) {
            d19 = dArray[0][n] + dArray[7][n];
            d18 = dArray[0][n] - dArray[7][n];
            d17 = dArray[1][n] + dArray[6][n];
            d16 = dArray[1][n] - dArray[6][n];
            d15 = dArray[2][n] + dArray[5][n];
            d14 = dArray[2][n] - dArray[5][n];
            d13 = dArray[3][n] + dArray[4][n];
            d12 = dArray[3][n] - dArray[4][n];
            d11 = d19 + d13;
            d10 = d19 - d13;
            d9 = d17 + d15;
            d8 = d17 - d15;
            dArray[0][n] = d11 + d9;
            dArray[4][n] = d11 - d9;
            d7 = (d8 + d10) * 0.707106781;
            dArray[2][n] = d10 + d7;
            dArray[6][n] = d10 - d7;
            d11 = d12 + d14;
            d9 = d14 + d16;
            d8 = d16 + d18;
            d6 = (d11 - d8) * 0.382683433;
            d5 = 0.5411961 * d11 + d6;
            d4 = 1.306562965 * d8 + d6;
            d3 = d9 * 0.707106781;
            d2 = d18 + d3;
            d = d18 - d3;
            dArray[5][n] = d + d5;
            dArray[3][n] = d - d5;
            dArray[1][n] = d2 + d4;
            dArray[7][n] = d2 - d4;
            ++n;
        }
        return dArray;
    }

    private int[] quantizeBlockExtreme(double[][] dArray, int n) {
        int[] nArray = new int[dctBlockSize * dctBlockSize];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            int n4 = 0;
            while (n4 < 8) {
                nArray[n2] = (int)Math.round(dArray[n3][n4] / (double)((int[])this.quantum[n])[n2]);
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }
}

