/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.testdocs;

import java.io.IOException;
import org.jfor.jfor.rtflib.rtfdoc.RtfDocumentArea;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraph;
import org.jfor.jfor.rtflib.rtfdoc.RtfSection;
import org.jfor.jfor.rtflib.rtfdoc.RtfTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfTableCell;
import org.jfor.jfor.rtflib.rtfdoc.RtfTableRow;
import org.jfor.jfor.rtflib.testdocs.TestDocument;

class NestedTable
extends TestDocument {
    private static final int MM_TO_TWIPS = 56;

    NestedTable() {
    }

    protected void generateDocument(RtfDocumentArea rtfDocumentArea, RtfSection rtfSection) throws IOException {
        rtfSection.newParagraph().newText("This document demonstrates pseudo-nested tables created using merged table cells");
        this.firstTestTable(rtfSection);
        RtfParagraph rtfParagraph = rtfSection.newParagraph();
        rtfParagraph.newText("Test continues on next page.");
        rtfParagraph.newPageBreak();
        this.secondTestTable(rtfSection);
        rtfParagraph = rtfSection.newParagraph();
        rtfParagraph.newText("Test continues on next page.");
        rtfParagraph.newPageBreak();
        this.thirdTestTable(rtfSection);
        rtfSection.newParagraph().newText("End of nested tables test document");
    }

    private void firstTestTable(RtfSection rtfSection) throws IOException {
        rtfSection.newParagraph().newText("First test: table with one nested table in cell 1,1");
        RtfTable rtfTable = rtfSection.newTable();
        RtfTableRow rtfTableRow = rtfTable.newTableRow();
        RtfTableCell rtfTableCell = rtfTableRow.newTableCell(8960);
        rtfTableCell.newParagraph().newText("cell 0,0, width 160mm, only cell in this row.");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(2240).newParagraph().newText("cell 1,0, width 40mm, to the left of nested table.");
        rtfTableCell = rtfTableRow.newTableCell(4480);
        rtfTableCell.newParagraph().newText("cell 1,1, width 80mm, this text is followed by a nested table in the same cell, followed by text that says 'AFTER NESTED TABLE'.");
        this.fillNestedTable(rtfTableCell.newTable(), 1);
        rtfTableCell.newParagraph().newText("AFTER NESTED TABLE");
        rtfTableRow.newTableCell(2240).newParagraph().newText("cell 1,2, width 40mm, to the right of nested table.");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(4480).newParagraph().newText("cell 2,0, width 80mm, this row has two cells.");
        rtfTableRow.newTableCell(4480).newParagraph().newText("cell 2,1, width 80mm, last cell.");
    }

    private void secondTestTable(RtfSection rtfSection) throws IOException {
        rtfSection.newParagraph().newText("Second test: table with two nested tables in cell 1,1");
        RtfTable rtfTable = rtfSection.newTable();
        RtfTableRow rtfTableRow = rtfTable.newTableRow();
        RtfTableCell rtfTableCell = rtfTableRow.newTableCell(8960);
        rtfTableCell.newParagraph().newText("second test table: cell 0,0, width 160mm, only cell in this row.");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(2240).newParagraph().newText("cell 1,0, width 40mm, to the left of nested tables.");
        rtfTableCell = rtfTableRow.newTableCell(4480);
        rtfTableCell.newParagraph().newText("cell 1,1, width 80mm, this text is followed by a nested table in the same cell, followed by text that says 'BETWEEN', then another table, then 'AFTER'.");
        this.fillNestedTable(rtfTableCell.newTable(), 2);
        rtfTableCell.newParagraph().newText("BETWEEN");
        this.fillNestedTable(rtfTableCell.newTable(), 3);
        rtfTableCell.newParagraph().newText("AFTER");
        rtfTableRow.newTableCell(2240).newParagraph().newText("cell 1,2, width 40mm, to the right of nested table.");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(4480).newParagraph().newText("cell 2,0, width 80mm, this row has two cells.");
        rtfTableRow.newTableCell(4480).newParagraph().newText("cell 2,1, width 80mm, last cell.");
    }

    private void thirdTestTable(RtfSection rtfSection) throws IOException {
        rtfSection.newParagraph().newText("Third test: table with two nested tables in cell 1,1 and one nested table in cell 0,1");
        RtfTable rtfTable = rtfSection.newTable();
        RtfTableRow rtfTableRow = rtfTable.newTableRow();
        RtfTableCell rtfTableCell = rtfTableRow.newTableCell(4480);
        rtfTableCell.newParagraph().newText("third test table: cell 0,0, width 40mm, the cell to its right contains a nested table with no other text.");
        rtfTableCell = rtfTableRow.newTableCell(4480);
        this.fillNestedTable(rtfTableCell.newTable(), 4);
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(2240).newParagraph().newText("cell 1,0, width 40mm, to the left of nested tables.");
        rtfTableCell = rtfTableRow.newTableCell(4480);
        rtfTableCell.newParagraph().newText("cell 1,1, width 80mm, this text is followed by a nested table in the same cell, followed by text that says 'BETWEEN', then another table, then 'AFTER'.");
        this.fillNestedTable(rtfTableCell.newTable(), 5);
        rtfTableCell.newParagraph().newText("BETWEEN");
        this.fillNestedTable(rtfTableCell.newTable(), 6);
        rtfTableCell.newParagraph().newText("AFTER");
        rtfTableRow.newTableCell(2240).newParagraph().newText("cell 1,2, width 40mm, to the right of nested table.");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(4480).newParagraph().newText("cell 2,0, width 80mm, this row has two cells.");
        rtfTableRow.newTableCell(4480).newParagraph().newText("cell 2,1, width 80mm, last cell.");
    }

    private void fillNestedTable(RtfTable rtfTable, int n) throws IOException {
        String string = "TABLE " + n;
        RtfTableRow rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(4480).newParagraph().newText(string + ":nested cell 0,0. Nested table contains 3 rows with 1,2 and 3 cells respectively");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(2240).newParagraph().newText(string + ":nested cell 1,0, 40mm.");
        rtfTableRow.newTableCell(2240).newParagraph().newText(string + ":nested cell 1,1, 40mm.");
        rtfTableRow = rtfTable.newTableRow();
        rtfTableRow.newTableCell(1680).newParagraph().newText(string + ":nested cell 2,0, 30mm.");
        rtfTableRow.newTableCell(1680).newParagraph().newText(string + ":nested cell 2,1, 30mm.");
        rtfTableRow.newTableCell(1120).newParagraph().newText(string + ":nested cell 2,2, 20mm.");
    }
}

