/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.ObjectDatabaseCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

class ObjectDatabaseFile {
    protected static final long DEL_LIST_END = -1L;
    protected static final byte IS_DELETED = 0;
    protected static final byte IS_ACTIVE = 1;
    protected RandomAccessFile dataFile;
    protected String fileName;
    protected long firstDel;

    public ObjectDatabaseFile(String string, boolean bl) throws IOException {
        if (bl) {
            File file = new File(string);
            file.delete();
        }
        this.fileName = new String(string);
        this.dataFile = new RandomAccessFile(string, "rw");
        this.constructorHelper();
    }

    public ObjectDatabaseFile(File file) throws IOException {
        this.fileName = new String(file.getName());
        this.dataFile = new RandomAccessFile(file, "rw");
        this.constructorHelper();
    }

    protected void constructorHelper() throws IOException {
        if (this.dataFile.length() == 0L) {
            this.dataFile.writeLong(-1L);
            this.firstDel = -1L;
        } else {
            this.firstDel = this.dataFile.readLong();
        }
    }

    public long writeObject(Serializable serializable) throws IOException {
        long l;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        int n2 = n = byteArrayOutputStream.size();
        if (this.firstDel == -1L) {
            l = this.dataFile.length();
            this.dataFile.seek(l);
        } else {
            long l2 = -1L;
            l = this.firstDel;
            while (true) {
                this.dataFile.seek(l);
                byte by = this.dataFile.readByte();
                this.dataFile.readInt();
                n2 = this.dataFile.readInt();
                long l3 = this.dataFile.readLong();
                if (by == 1) {
                    throw new IOException("corrupt delete list");
                }
                if (n2 >= n) {
                    if (l2 == -1L) {
                        this.firstDel = l3;
                        this.dataFile.seek(0L);
                        this.dataFile.writeLong(this.firstDel);
                    } else {
                        this.dataFile.seek(l2 + 1L + 4L + 4L);
                        this.dataFile.writeLong(l3);
                    }
                    this.dataFile.seek(l);
                    break;
                }
                l2 = l;
                if (l3 == -1L) {
                    l = this.dataFile.length();
                    this.dataFile.seek(l);
                    break;
                }
                l = l3;
            }
        }
        this.dataFile.writeByte(1);
        this.dataFile.writeInt(n);
        this.dataFile.writeInt(n2);
        this.dataFile.writeLong(-1L);
        this.dataFile.write(byteArrayOutputStream.toByteArray());
        return l;
    }

    public void rewriteObject(Serializable serializable) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        int n2 = n = byteArrayOutputStream.size();
        this.dataFile.writeByte(1);
        this.dataFile.writeInt(n);
        this.dataFile.writeInt(n2);
        this.dataFile.writeLong(-1L);
        this.dataFile.write(byteArrayOutputStream.toByteArray());
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        int n;
        int n2;
        while ((n2 = this.dataFile.readByte()) != 1) {
            this.dataFile.skipBytes(4);
            n = this.dataFile.readInt();
            this.dataFile.skipBytes(n + 8);
        }
        n2 = this.dataFile.readInt();
        n = this.dataFile.readInt();
        this.dataFile.skipBytes(8);
        byte[] byArray = new byte[n2];
        this.dataFile.readFully(byArray);
        int n3 = n - n2;
        if (n3 > 0) {
            this.dataFile.skipBytes(n3);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public void delete() throws IOException {
        long l = this.dataFile.getFilePointer();
        byte by = this.dataFile.readByte();
        if (by == 0) {
            return;
        }
        this.dataFile.seek(l);
        this.dataFile.writeByte(0);
        this.dataFile.skipBytes(8);
        this.dataFile.writeLong(this.firstDel);
        this.firstDel = l;
        this.dataFile.seek(0L);
        this.dataFile.writeLong(this.firstDel);
    }

    public void rewind() throws IOException {
        this.dataFile.seek(8L);
    }

    public void skip() throws IOException {
        this.dataFile.skipBytes(5);
        int n = this.dataFile.readInt();
        this.dataFile.skipBytes(8 + n);
    }

    public void compact(ObjectDatabaseCallback objectDatabaseCallback) throws IOException, Throwable {
        File file = new File("TMP" + System.currentTimeMillis());
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.writeLong(-1L);
        try {
            while (true) {
                byte by = this.dataFile.readByte();
                int n = this.dataFile.readInt();
                int n2 = this.dataFile.readInt();
                if (by == 0) {
                    this.dataFile.skipBytes(8 + n2);
                    continue;
                }
                this.dataFile.skipBytes(8);
                byte[] byArray = new byte[n];
                this.dataFile.readFully(byArray);
                int n3 = n2 - n;
                if (n3 > 0) {
                    this.dataFile.skipBytes(n3);
                }
                long l = randomAccessFile.getFilePointer();
                randomAccessFile.writeByte(1);
                randomAccessFile.writeInt(n);
                randomAccessFile.writeInt(n);
                randomAccessFile.writeLong(-1L);
                randomAccessFile.write(byArray);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                if (objectDatabaseCallback == null) continue;
                objectDatabaseCallback.compactNotify(l, objectInputStream.readObject());
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        this.dataFile.close();
        File file2 = new File(this.fileName);
        file2.delete();
        randomAccessFile.close();
        file.renameTo(new File(this.fileName));
        this.dataFile = new RandomAccessFile(this.fileName, "rw");
        this.constructorHelper();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.dataFile.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.dataFile.getFilePointer();
    }

    public void seek(long l) throws IOException {
        this.dataFile.seek(l);
    }

    public long length() throws IOException {
        return this.dataFile.length();
    }

    public void close() throws IOException {
        this.dataFile.close();
    }
}

