/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.InputStream;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private InputStream input;
    private FieldInfos fieldInfos;
    int size;
    int position = -1;
    private Term term = new Term("", "");
    private TermInfo termInfo = new TermInfo();
    boolean isIndex = false;
    long indexPointer = 0L;
    Term prev;
    private char[] buffer = new char[0];

    SegmentTermEnum(InputStream i, FieldInfos fis, boolean isi) throws IOException {
        this.input = i;
        this.fieldInfos = fis;
        this.size = this.input.readInt();
        this.isIndex = isi;
    }

    protected Object clone() {
        SegmentTermEnum clone = null;
        try {
            clone = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        clone.input = (InputStream)this.input.clone();
        clone.termInfo = new TermInfo(this.termInfo);
        if (this.term != null) {
            clone.growBuffer(this.term.text.length());
        }
        return clone;
    }

    final void seek(long pointer, int p, Term t, TermInfo ti) throws IOException {
        this.input.seek(pointer);
        this.position = p;
        this.term = t;
        this.prev = null;
        this.termInfo.set(ti);
        this.growBuffer(this.term.text.length());
    }

    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1) {
            this.term = null;
            return false;
        }
        this.prev = this.term;
        this.term = this.readTerm();
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    private final Term readTerm() throws IOException {
        int length;
        int start = this.input.readVInt();
        int totalLength = start + (length = this.input.readVInt());
        if (this.buffer.length < totalLength) {
            this.growBuffer(totalLength);
        }
        this.input.readChars(this.buffer, start, length);
        return new Term(this.fieldInfos.fieldName(this.input.readVInt()), new String(this.buffer, 0, totalLength), false);
    }

    private final void growBuffer(int length) {
        this.buffer = new char[length];
        int i = 0;
        while (i < this.term.text.length()) {
            this.buffer[i] = this.term.text.charAt(i);
            ++i;
        }
    }

    public final Term term() {
        return this.term;
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo ti) {
        ti.set(this.termInfo);
    }

    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    public final void close() throws IOException {
        this.input.close();
    }
}

