/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;

final class SegmentMerger {
    private boolean useCompoundFile;
    private Directory directory;
    private String segment;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private static final String[] COMPOUND_EXTENSIONS = new String[]{"fnm", "frq", "prx", "fdx", "fdt", "tii", "tis"};
    private OutputStream freqOutput = null;
    private OutputStream proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private SegmentMergeQueue queue = null;
    private final TermInfo termInfo = new TermInfo();

    SegmentMerger(Directory dir, String name, boolean compoundFile) {
        this.directory = dir;
        this.segment = name;
        this.useCompoundFile = compoundFile;
    }

    final void add(IndexReader reader) {
        this.readers.addElement(reader);
    }

    final IndexReader segmentReader(int i) {
        return (IndexReader)this.readers.elementAt(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int merge() throws IOException {
        try {
            value = this.mergeFields();
            this.mergeTerms();
            this.mergeNorms();
        }
        finally {
            i = 0;
            ** while (i < this.readers.size())
        }
lbl-1000:
        // 1 sources

        {
            reader = (IndexReader)this.readers.elementAt(i);
            reader.close();
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        if (this.useCompoundFile) {
            this.createCompoundFile();
        }
        return value;
    }

    private final void createCompoundFile() throws IOException {
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, this.segment + ".cfs");
        ArrayList<String> files = new ArrayList<String>(COMPOUND_EXTENSIONS.length + this.fieldInfos.size());
        int i = 0;
        while (i < COMPOUND_EXTENSIONS.length) {
            files.add(this.segment + "." + COMPOUND_EXTENSIONS[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i2);
            if (fi.isIndexed) {
                files.add(this.segment + ".f" + i2);
            }
            ++i2;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
        it = files.iterator();
        while (it.hasNext()) {
            this.directory.deleteFile((String)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws IOException {
        this.fieldInfos = new FieldInfos();
        int docCount = 0;
        int i = 0;
        while (i < this.readers.size()) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            this.fieldInfos.add(reader.getFieldNames(true), true);
            this.fieldInfos.add(reader.getFieldNames(false), false);
            ++i;
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int i2 = 0;
            while (i2 < this.readers.size()) {
                IndexReader reader = (IndexReader)this.readers.elementAt(i2);
                int maxDoc = reader.maxDoc();
                int j = 0;
                while (j < maxDoc) {
                    if (!reader.isDeleted(j)) {
                        fieldsWriter.addDocument(reader.document(j));
                        ++docCount;
                    }
                    ++j;
                }
                ++i2;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fieldsWriter.close();
            throw throwable;
        }
        fieldsWriter.close();
        return docCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms() throws IOException {
        try {
            this.freqOutput = this.directory.createFile(this.segment + ".frq");
            this.proxOutput = this.directory.createFile(this.segment + ".prx");
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos);
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws IOException {
        this.queue = new SegmentMergeQueue(this.readers.size());
        int base = 0;
        int i = 0;
        while (i < this.readers.size()) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            TermEnum termEnum = reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            base += reader.numDocs();
            if (smi.next()) {
                this.queue.put(smi);
            } else {
                smi.close();
            }
            ++i;
        }
        SegmentMergeInfo[] match = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            this.mergeTermInfo(match, matchSize);
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match[--matchSize]).next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    private final void mergeTermInfo(SegmentMergeInfo[] smis, int n) throws IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput.getFilePointer();
        int df = this.appendPostings(smis, n);
        if (df > 0) {
            this.termInfo.set(df, freqPointer, proxPointer);
            this.termInfosWriter.add(smis[0].term, this.termInfo);
        }
    }

    private final int appendPostings(SegmentMergeInfo[] smis, int n) throws IOException {
        int lastDoc = 0;
        int df = 0;
        int i = 0;
        while (i < n) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.postings;
            int base = smi.base;
            int[] docMap = smi.docMap;
            postings.seek(smi.termEnum);
            while (postings.next()) {
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                if ((doc += base) < lastDoc) {
                    throw new IllegalStateException("docs out of order");
                }
                int docCode = doc - lastDoc << 1;
                lastDoc = doc;
                int freq = postings.freq();
                if (freq == 1) {
                    this.freqOutput.writeVInt(docCode | 1);
                } else {
                    this.freqOutput.writeVInt(docCode);
                    this.freqOutput.writeVInt(freq);
                }
                int lastPosition = 0;
                int j = 0;
                while (j < freq) {
                    int position = postings.nextPosition();
                    this.proxOutput.writeVInt(position - lastPosition);
                    lastPosition = position;
                    ++j;
                }
                ++df;
            }
            ++i;
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeNorms() throws IOException {
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed) {
                Object var11_10;
                OutputStream output = this.directory.createFile(this.segment + ".f" + i);
                try {
                    int j = 0;
                    while (j < this.readers.size()) {
                        IndexReader reader = (IndexReader)this.readers.elementAt(j);
                        byte[] input = reader.norms(fi.name);
                        int maxDoc = reader.maxDoc();
                        int k = 0;
                        while (k < maxDoc) {
                            byte norm;
                            byte by = norm = input != null ? input[k] : (byte)0;
                            if (!reader.isDeleted(k)) {
                                output.writeByte(norm);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    output.close();
                    throw throwable;
                }
                output.close();
                {
                }
            }
            ++i;
        }
    }
}

