/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.InterpreterFrame;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;

public class Interpreter
extends LabelTable {
    public static final boolean printICode = false;
    boolean itsInFunctionFlag;
    Vector itsFunctionList;
    InterpreterData itsData;
    VariableTable itsVariableTable;
    int itsTryDepth = 0;
    int itsStackDepth = 0;
    int itsEpilogLabel = -1;
    String itsSourceFile;
    int itsLineNumber = 0;
    InterpretedFunction[] itsNestedFunctions = null;
    static PrintWriter out;
    private int version;
    private boolean inLineStepMode;
    private StringBuffer debugSource;
    private static final Object DBL_MRK;

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, TokenStream tokenStream, Scriptable scriptable) {
        return new NodeTransformer().transform(node, null, tokenStream, scriptable);
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecuritySupport securitySupport, ClassNameHelper classNameHelper) throws IOException {
        this.version = context.getLanguageVersion();
        this.itsData = new InterpreterData(0, 0, object, context.hasCompileFunctionsWithDynamicScope(), false);
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            InterpretedFunction interpretedFunction = this.generateFunctionICode(context, scriptable, functionNode, object);
            interpretedFunction.itsData.itsFunctionType = functionNode.getFunctionType();
            Interpreter.createFunctionObject(interpretedFunction, scriptable);
            return interpretedFunction;
        }
        return this.generateScriptICode(context, scriptable, node, object);
    }

    private void generateICodeFromTree(Node node, VariableTable variableTable, boolean bl, Object object) {
        int n = 0;
        this.itsVariableTable = variableTable;
        this.itsData.itsNeedsActivation = bl;
        this.itsData.itsICodeTop = n = this.generateICode(node, n);
        if (this.itsEpilogLabel != -1) {
            this.markLabel(this.itsEpilogLabel, n);
        }
        int n2 = 0;
        while (n2 < this.itsLabelTableTop) {
            this.itsLabelTable[n2].fixGotos(this.itsData.itsICode);
            ++n2;
        }
    }

    private Object[] generateRegExpLiterals(Context context, Scriptable scriptable, Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        RegExpProxy regExpProxy = context.getRegExpProxy();
        int n = 0;
        while (n < vector.size()) {
            Node node = (Node)vector.elementAt(n);
            Node node2 = node.getFirstChild();
            Node node3 = node.getLastChild();
            objectArray[n] = regExpProxy.newRegExp(context, scriptable, node2.getString(), node2 != node3 ? node3.getString() : null, false);
            node.putIntProp(12, n);
            ++n;
        }
        return objectArray;
    }

    private InterpretedScript generateScriptICode(Context context, Scriptable scriptable, Node node, Object object) {
        this.itsData.itsSourceFile = this.itsSourceFile = (String)node.getProp(16);
        this.itsFunctionList = (Vector)node.getProp(5);
        this.debugSource = (StringBuffer)node.getProp(31);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scriptable, context, object);
        }
        Object[] objectArray = null;
        Vector vector = (Vector)node.getProp(12);
        if (vector != null) {
            objectArray = this.generateRegExpLiterals(context, scriptable, vector);
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        boolean bl = context.isGeneratingDebugChanged() && context.isGeneratingDebug();
        this.generateICodeFromTree(node, variableTable, bl, object);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = objectArray;
        String[] stringArray = this.itsVariableTable.getAllNames();
        short s = (short)this.itsVariableTable.getParameterCount();
        InterpretedScript interpretedScript = new InterpretedScript(context, this.itsData, stringArray, s);
        if (context.debugger != null) {
            context.debugger.handleCompilationDone(context, interpretedScript, this.debugSource);
        }
        return interpretedScript;
    }

    private void generateNestedFunctions(Scriptable scriptable, Context context, Object object) {
        this.itsNestedFunctions = new InterpretedFunction[this.itsFunctionList.size()];
        int n = 0;
        while (n < this.itsFunctionList.size()) {
            FunctionNode functionNode = (FunctionNode)this.itsFunctionList.elementAt(n);
            Interpreter interpreter = new Interpreter();
            interpreter.itsSourceFile = this.itsSourceFile;
            interpreter.itsData = new InterpreterData(0, 0, object, context.hasCompileFunctionsWithDynamicScope(), functionNode.getCheckThis());
            interpreter.itsData.itsFunctionType = functionNode.getFunctionType();
            interpreter.itsInFunctionFlag = true;
            interpreter.debugSource = this.debugSource;
            this.itsNestedFunctions[n] = interpreter.generateFunctionICode(context, scriptable, functionNode, object);
            functionNode.putIntProp(5, n);
            n = (short)(n + 1);
        }
    }

    private InterpretedFunction generateFunctionICode(Context context, Scriptable scriptable, FunctionNode functionNode, Object object) {
        this.itsFunctionList = (Vector)functionNode.getProp(5);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scriptable, context, object);
        }
        Object[] objectArray = null;
        Vector vector = (Vector)functionNode.getProp(12);
        if (vector != null) {
            objectArray = this.generateRegExpLiterals(context, scriptable, vector);
        }
        VariableTable variableTable = functionNode.getVariableTable();
        boolean bl = functionNode.requiresActivation() || context.isGeneratingDebugChanged() && context.isGeneratingDebug();
        this.generateICodeFromTree(functionNode.getLastChild(), variableTable, bl, object);
        this.itsData.itsName = functionNode.getFunctionName();
        this.itsData.itsSourceFile = (String)functionNode.getProp(16);
        this.itsData.itsSource = (String)functionNode.getProp(17);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = objectArray;
        String[] stringArray = this.itsVariableTable.getAllNames();
        short s = (short)this.itsVariableTable.getParameterCount();
        InterpretedFunction interpretedFunction = new InterpretedFunction(context, this.itsData, stringArray, s);
        if (context.debugger != null) {
            context.debugger.handleCompilationDone(context, interpretedFunction, this.debugSource);
        }
        return interpretedFunction;
    }

    private int updateLineNumber(Node node, int n) {
        Object object = node.getDatum();
        if (object == null || !(object instanceof Number)) {
            return n;
        }
        short s = ((Number)object).shortValue();
        if (s != this.itsLineNumber) {
            this.itsLineNumber = s;
            if (this.itsData.itsLineNumberTable == null && Context.getCurrentContext().isGeneratingDebug()) {
                this.itsData.itsLineNumberTable = new UintMap();
            }
            if (s > 0 && this.itsData.itsLineNumberTable != null) {
                this.itsData.itsLineNumberTable.put((int)s, n);
            }
            n = this.addByte(147, n);
            n = this.addShort(s, n);
        }
        return n;
    }

    private void badTree(Node node) {
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : " + node.toString());
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Un-handled node : " + node.toString());
    }

    private int generateICode(Node node, int n) {
        Node node2;
        int n2 = node.getType();
        Node node3 = node2 = node.getFirstChild();
        block0 : switch (n2) {
            case 110: {
                n = this.addByte(55, n);
                Node node4 = (Node)node.getProp(5);
                int n3 = node4.getExistingIntProp(5);
                n = this.addByte(n3 >> 8, n);
                n = this.addByte(n3 & 0xFF, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 146: {
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    if (node2.getType() != 110) {
                        n = this.generateICode(node2, n);
                    }
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 116: {
                n = this.updateLineNumber(node, n);
                node2 = node2.getNextSibling();
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 117: 
            case 124: 
            case 128: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 96: {
                n = this.generateICode(node2, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                break;
            }
            case 115: {
                Node node5;
                Node node6;
                Node node7;
                n = this.updateLineNumber(node, n);
                n = this.generateICode(node2, n);
                int n4 = this.itsData.itsMaxLocals++;
                n = this.addByte(69, n);
                n = this.addByte(n4, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                Vector vector = (Vector)node.getProp(13);
                int n5 = 0;
                while (n5 < vector.size()) {
                    node7 = (Node)vector.elementAt(n5);
                    node6 = node7.getFirstChild();
                    n = this.generateICode(node6, n);
                    n = this.addByte(70, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addByte(n4, n);
                    n = this.addByte(53, n);
                    node5 = new Node(137);
                    node7.addChildAfter(node5, node6);
                    Node node8 = new Node(7);
                    node8.putProp(1, node5);
                    n = this.addGoto(node8, 7, n);
                    --this.itsStackDepth;
                    ++n5;
                }
                node7 = (Node)node.getProp(14);
                if (node7 != null) {
                    node6 = new Node(137);
                    node7.getFirstChild().addChildToFront(node6);
                    node5 = new Node(6);
                    node5.putProp(1, node6);
                    n = this.addGoto(node5, 6, n);
                }
                node6 = (Node)node.getProp(2);
                node5 = new Node(6);
                node5.putProp(1, node6);
                n = this.addGoto(node5, 6, n);
                break;
            }
            case 137: {
                int n6 = node.getIntProp(20, -1);
                if (n6 == -1) {
                    n6 = this.acquireLabel();
                    node.putIntProp(20, n6);
                }
                this.markLabel(n6, n);
                if (node.getProp(21) == null) break;
                this.itsStackDepth = 1;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 102: 
            case 103: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                int n7 = node.getInt();
                if (this.version == 120) {
                    if (n7 == 14) {
                        n7 = 53;
                    } else if (n7 == 15) {
                        n7 = 54;
                    }
                }
                n = this.addByte(n7, n);
                --this.itsStackDepth;
                break;
            }
            case 30: 
            case 43: {
                if (!(this.itsSourceFile == null || this.itsData.itsSourceFile != null && this.itsSourceFile.equals(this.itsData.itsSourceFile))) {
                    this.itsData.itsSourceFile = this.itsSourceFile;
                }
                n = this.addByte(148, n);
                int n8 = 0;
                int n9 = -1;
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    if (n9 == -1) {
                        if (node2.getType() == 44) {
                            n9 = (short)(this.itsData.itsStringTableIndex - 1);
                        } else if (node2.getType() == 39) {
                            n9 = (short)(this.itsData.itsStringTableIndex - 1);
                        }
                    }
                    node2 = node2.getNextSibling();
                    ++n8;
                }
                if (node.getProp(30) != null) {
                    n = this.addByte(67, n);
                    n = this.addShort(this.itsLineNumber, n);
                    n = this.addString(this.itsSourceFile, n);
                } else {
                    n = this.addByte(n2, n);
                    n = this.addShort(n9, n);
                }
                this.itsStackDepth -= n8 - 1;
                n8 = n2 == 30 ? --n8 : (n8 -= 2);
                n = this.addShort(n8, n);
                if (n8 > this.itsData.itsMaxArgs) {
                    this.itsData.itsMaxArgs = n8;
                }
                n = this.addByte(148, n);
                break;
            }
            case 69: 
            case 144: {
                n = this.generateICode(node2, n);
                n = this.addByte(69, n);
                n = this.addLocalRef(node, n);
                break;
            }
            case 145: {
                if (node.getProp(1) != null) {
                    n = this.addByte(66, n);
                } else {
                    n = this.addByte(70, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                Node node9 = (Node)node.getProp(7);
                n = this.addLocalRef(node9, n);
                break;
            }
            case 70: {
                n = this.addByte(70, n);
                Node node10 = (Node)node.getProp(6);
                n = this.addLocalRef(node10, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 7: 
            case 8: {
                n = this.generateICode(node2, n);
                --this.itsStackDepth;
            }
            case 6: {
                n = this.addGoto(node, (int)((byte)n2), n);
                break;
            }
            case 143: {
                Node node11 = (Node)node.getProp(1);
                node11.putProp(21, node);
                n = this.addGoto(node, 65, n);
                break;
            }
            case 101: {
                n = this.generateICode(node2, n);
                n = this.addByte(9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n10 = this.acquireLabel();
                n = this.addGoto(n10, 8, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                this.markLabel(n10, n);
                break;
            }
            case 100: {
                n = this.generateICode(node2, n);
                n = this.addByte(9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n11 = this.acquireLabel();
                n = this.addGoto(n11, 7, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                this.markLabel(n11, n);
                break;
            }
            case 39: {
                n = this.generateICode(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.addByte(81, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.addByte(86, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte(39, n);
                --this.itsStackDepth;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                --this.itsStackDepth;
                break;
            }
            case 142: {
                n = this.generateICode(node2, n);
                Object object = node.getProp(18);
                if (object == ScriptRuntime.NumberClass) {
                    n = this.addByte(58, n);
                    break;
                }
                this.badTree(node);
                break;
            }
            case 105: {
                n = this.generateICode(node2, n);
                switch (node.getInt()) {
                    case 132: {
                        n = this.addByte(57, n);
                        n = this.addByte(74, n);
                        break block0;
                    }
                    case 129: {
                        int n12 = this.acquireLabel();
                        int n13 = this.acquireLabel();
                        n = this.addGoto(n12, 7, n);
                        n = this.addByte(52, n);
                        n = this.addGoto(n13, 6, n);
                        this.markLabel(n12, n);
                        n = this.addByte(51, n);
                        this.markLabel(n13, n);
                        break block0;
                    }
                    case 28: {
                        n = this.addByte(28, n);
                        break block0;
                    }
                    case 32: {
                        n = this.addByte(32, n);
                        break block0;
                    }
                    case 24: {
                        n = this.addByte(29, n);
                        break block0;
                    }
                    case 23: {
                        n = this.addByte(58, n);
                        break block0;
                    }
                }
                this.badTree(node);
                break;
            }
            case 40: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.addByte(83, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.addByte(84, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte(40, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 42: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 10: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte(10, n);
                n = this.addString(node3.getString(), n);
                --this.itsStackDepth;
                break;
            }
            case 32: {
                String string = node.getString();
                int n14 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n14 = this.itsVariableTable.getOrdinal(string);
                }
                if (n14 == -1) {
                    n = this.addByte(78, n);
                    n = this.addString(string, n);
                } else {
                    n = this.addByte(72, n);
                    n = this.addByte(n14, n);
                    n = this.addByte(32, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 141: {
                n = this.generateICode(node2, n);
                n = this.addByte(82, n);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                n = this.addByte(n2, n);
                n = this.addString(node.getString(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 106: 
            case 107: {
                int n15 = node2.getType();
                switch (n15) {
                    case 72: {
                        String string = node2.getString();
                        if (this.itsData.itsNeedsActivation) {
                            n = this.addByte(85, n);
                            n = this.addByte(46, n);
                            n = this.addString(string, n);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            n = this.addByte(n2 == 106 ? 34 : 37, n);
                            --this.itsStackDepth;
                            break;
                        }
                        n = this.addByte(n2 == 106 ? 59 : 60, n);
                        int n16 = this.itsVariableTable.getOrdinal(string);
                        n = this.addByte(n16, n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 39: 
                    case 41: {
                        Node node12 = node2.getFirstChild();
                        n = this.generateICode(node12, n);
                        node12 = node12.getNextSibling();
                        n = this.generateICode(node12, n);
                        n = n15 == 39 ? this.addByte(n2 == 106 ? 34 : 37, n) : this.addByte(n2 == 106 ? 35 : 38, n);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        n = this.addByte(n2 == 106 ? 33 : 36, n);
                        n = this.addString(node2.getString(), n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 45: {
                double d = node.getDouble();
                int n17 = (int)d;
                if ((double)n17 == d) {
                    if (n17 == 0) {
                        n = this.addByte(47, n);
                    } else if (n17 == 1) {
                        n = this.addByte(48, n);
                    } else if ((short)n17 == n17) {
                        n = this.addByte(150, n);
                        n = this.addShort(n17, n);
                    } else {
                        n = this.addByte(151, n);
                        n = this.addInt(n17, n);
                    }
                } else {
                    n = this.addByte(45, n);
                    n = this.addDouble(d, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: 
            case 57: {
                n = this.updateLineNumber(node, n);
            }
            case 3: {
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                --this.itsStackDepth;
                break;
            }
            case 68: {
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                break;
            }
            case 77: {
                n = this.addByte(n2, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 4: {
                n = this.addByte(n2, n);
                break;
            }
            case 75: {
                ++this.itsTryDepth;
                if (this.itsTryDepth > this.itsData.itsMaxTryDepth) {
                    this.itsData.itsMaxTryDepth = this.itsTryDepth;
                }
                Node node13 = (Node)node.getProp(1);
                Node node14 = (Node)node.getProp(21);
                if (node13 == null) {
                    n = this.addByte(75, n);
                    n = this.addShort(0, n);
                } else {
                    n = this.addGoto(node, 75, n);
                }
                int n18 = 0;
                if (node14 != null) {
                    n18 = this.acquireLabel();
                    int n19 = n18 & Integer.MAX_VALUE;
                    this.itsLabelTable[n19].addFixup(n);
                }
                n = this.addShort(0, n);
                Node node15 = null;
                boolean bl = false;
                while (node2 != null) {
                    if (node13 != null && node15 == node13) {
                        this.itsStackDepth = 1;
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                    }
                    Node node16 = node2.getNextSibling();
                    if (!(bl || node16 == null || node16 != node13 && node16 != node14)) {
                        n = this.addByte(76, n);
                        bl = true;
                    }
                    n = this.generateICode(node2, n);
                    node15 = node2;
                    node2 = node2.getNextSibling();
                }
                this.itsStackDepth = 0;
                if (node14 != null) {
                    int n20 = this.acquireLabel();
                    n = this.addGoto(n20, 6, n);
                    this.markLabel(n18, n);
                    this.itsStackDepth = 1;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    int n21 = this.itsData.itsMaxLocals++;
                    n = this.addByte(69, n);
                    n = this.addByte(n21, n);
                    n = this.addByte(57, n);
                    int n22 = node14.getExistingIntProp(20);
                    n = this.addGoto(n22, 65, n);
                    n = this.addByte(70, n);
                    n = this.addByte(n21, n);
                    n = this.addByte(88, n);
                    this.itsStackDepth = 0;
                    this.markLabel(n20, n);
                }
                --this.itsTryDepth;
                break;
            }
            case 62: {
                n = this.updateLineNumber(node, n);
                n = this.generateICode(node2, n);
                n = this.addByte(62, n);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                n = this.updateLineNumber(node, n);
                if (node2 != null) {
                    n = this.generateICode(node2, n);
                } else {
                    n = this.addByte(74, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                n = this.addGoto(node, 5, n);
                --this.itsStackDepth;
                break;
            }
            case 72: {
                String string = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    n = this.addByte(85, n);
                    n = this.addByte(46, n);
                    n = this.addString(string, n);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addByte(39, n);
                    --this.itsStackDepth;
                    break;
                }
                int n23 = this.itsVariableTable.getOrdinal(string);
                n = this.addByte(72, n);
                n = this.addByte(n23, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 73: {
                if (this.itsData.itsNeedsActivation) {
                    node2.setType(61);
                    node.setType(10);
                    n = this.generateICode(node, n);
                    break;
                }
                String string = node2.getString();
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                int n24 = this.itsVariableTable.getOrdinal(string);
                n = this.addByte(73, n);
                n = this.addByte(n24, n);
                break;
            }
            case 109: {
                n = this.addByte(node.getInt(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 79: {
                n = this.generateICode(node2, n);
                n = this.addByte(79, n);
                n = this.addLocalRef(node, n);
                --this.itsStackDepth;
                break;
            }
            case 80: {
                n = this.addByte(80, n);
                Node node17 = (Node)node.getProp(4);
                n = this.addLocalRef(node17, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 139: {
                break;
            }
            case 56: {
                Node node18 = (Node)node.getProp(12);
                int n25 = node18.getExistingIntProp(12);
                n = this.addByte(56, n);
                n = this.addShort(n25, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
        }
        return n;
    }

    private int addLocalRef(Node node, int n) {
        int n2 = node.getIntProp(7, -1);
        if (n2 == -1) {
            n2 = this.itsData.itsMaxLocals++;
            node.putIntProp(7, n2);
        }
        n = this.addByte(n2, n);
        if (n2 >= this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = n2 + 1;
        }
        return n;
    }

    private int addGoto(Node node, int n, int n2) {
        int n3;
        if (node.getType() == 5) {
            if (this.itsEpilogLabel == -1) {
                this.itsEpilogLabel = this.acquireLabel();
            }
            n3 = this.itsEpilogLabel;
        } else {
            Node node2 = (Node)node.getProp(1);
            n3 = node2.getIntProp(20, -1);
            if (n3 == -1) {
                n3 = this.acquireLabel();
                node2.putIntProp(20, n3);
            }
        }
        n2 = this.addGoto(n3, (int)((byte)n), n2);
        return n2;
    }

    private int addGoto(int n, int n2, int n3) {
        int n4 = n3;
        n3 = this.addByte(n2, n3);
        int n5 = n & Integer.MAX_VALUE;
        short s = this.itsLabelTable[n5].getPC();
        if (s != -1) {
            int n6 = s - n4;
            n3 = this.addShort(n6, n3);
        } else {
            this.itsLabelTable[n5].addFixup(n4 + 1);
            n3 = this.addShort(0, n3);
        }
        return n3;
    }

    private int addByte(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (byArray.length == n2) {
            byte[] byArray2 = new byte[n2 * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
            this.itsData.itsICode = byArray2;
        }
        byArray[n2++] = (byte)n;
        return n2;
    }

    private int addShort(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byte[] byArray2 = new byte[(n2 + 2) * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
            this.itsData.itsICode = byArray2;
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int addInt(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byte[] byArray2 = new byte[(n2 + 4) * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
            this.itsData.itsICode = byArray2;
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        return n2 + 4;
    }

    private int addDouble(double d, int n) {
        int n2 = this.itsData.itsDoubleTableIndex;
        if (n2 == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n2) {
            double[] dArray = new double[n2 * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n2);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n2] = d;
        this.itsData.itsDoubleTableIndex = n2 + 1;
        n = this.addShort(n2, n);
        return n;
    }

    private int addString(String string, int n) {
        int n2 = this.itsData.itsStringTableIndex;
        if (this.itsData.itsStringTable.length == n2) {
            String[] stringArray = new String[n2 * 2];
            System.arraycopy(this.itsData.itsStringTable, 0, stringArray, 0, n2);
            this.itsData.itsStringTable = stringArray;
        }
        this.itsData.itsStringTable[n2] = string;
        this.itsData.itsStringTableIndex = n2 + 1;
        n = this.addShort(n2, n);
        return n;
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getTarget(byte[] byArray, int n) {
        int n2 = Interpreter.getShort(byArray, n);
        return n - 1 + n2;
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static void createFunctionObject(InterpretedFunction interpretedFunction, Scriptable scriptable) {
        interpretedFunction.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        interpretedFunction.setParentScope(scriptable);
        InterpreterData interpreterData = interpretedFunction.itsData;
        if (interpreterData.itsName.length() == 0) {
            return;
        }
        if (interpreterData.itsFunctionType == 1 && interpretedFunction.itsClosure == null || interpreterData.itsFunctionType == 3 && interpretedFunction.itsClosure != null) {
            ScriptRuntime.setProp(scriptable, interpretedFunction.itsData.itsName, interpretedFunction, scriptable);
        }
    }

    public static Object interpret(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, NativeFunction nativeFunction, InterpreterData interpreterData) throws JavaScriptException {
        int n;
        int n2 = interpreterData.itsMaxStack;
        int n3 = nativeFunction.argNames == null ? 0 : nativeFunction.argNames.length;
        int n4 = interpreterData.itsMaxLocals;
        int n5 = interpreterData.itsMaxTryDepth;
        int n6 = n2;
        int n7 = n6 + n3;
        int n8 = n7 + n4;
        Object object = DBL_MRK;
        Object[] objectArray2 = new Object[n8 + n5];
        double[] dArray = new double[n8];
        int n9 = -1;
        byte[] byArray = interpreterData.itsICode;
        String[] stringArray = interpreterData.itsStringTable;
        int n10 = 0;
        int n11 = interpreterData.itsICodeTop;
        Scriptable scriptable3 = Undefined.instance;
        if (n3 != 0) {
            int n12 = nativeFunction.argCount;
            if (n12 != 0) {
                if (n12 > objectArray.length) {
                    n12 = objectArray.length;
                }
                n = 0;
                while (n != n12) {
                    objectArray2[n6 + n] = objectArray[n];
                    ++n;
                }
            }
            n = n12;
            while (n != n3) {
                objectArray2[n6 + n] = scriptable3;
                ++n;
            }
        }
        if (interpreterData.itsNestedFunctions != null) {
            n = 0;
            while (n < interpreterData.itsNestedFunctions.length) {
                Interpreter.createFunctionObject(interpreterData.itsNestedFunctions[n], scriptable);
                ++n;
            }
        }
        String string = null;
        int[] nArray = null;
        int n13 = 0;
        InterpreterFrame interpreterFrame = null;
        if (context.debugger != null) {
            interpreterFrame = new InterpreterFrame(scriptable, interpreterData, nativeFunction);
            context.pushFrame(interpreterFrame);
        }
        if (n5 != 0) {
            nArray = new int[n5 * 2];
        }
        Object object2 = context.interpreterSecurityDomain;
        context.interpreterSecurityDomain = interpreterData.securityDomain;
        Object object3 = scriptable3;
        int n14 = n10;
        int n15 = context.instructionThreshold;
        int n16 = context.instructionCount;
        block98: while (n10 < n11) {
            try {
                switch (byArray[n10] & 0xFF) {
                    case 76: {
                        --n13;
                        break;
                    }
                    case 75: {
                        n = Interpreter.getTarget(byArray, n10 + 1);
                        if (n == n10) {
                            n = 0;
                        }
                        nArray[n13 * 2] = n;
                        n = Interpreter.getTarget(byArray, n10 + 3);
                        if (n == n10 + 2) {
                            n = 0;
                        }
                        nArray[n13 * 2 + 1] = n;
                        objectArray2[n8 + n13] = scriptable;
                        ++n13;
                        n10 += 4;
                        break;
                    }
                    case 19: {
                        boolean bl;
                        double d;
                        double d2;
                        Object object4 = objectArray2[--n9 + 1];
                        Object object5 = objectArray2[n9];
                        if (object4 == object || object5 == object) {
                            d2 = Interpreter.stack_double(objectArray2, dArray, n9 + 1);
                            d = Interpreter.stack_double(objectArray2, dArray, n9);
                            bl = d2 == d2 && d == d && d2 <= d;
                        } else {
                            bl = 1 == ScriptRuntime.cmp_LE(object4, object5);
                        }
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 17: {
                        boolean bl;
                        double d;
                        double d2;
                        Object object4 = objectArray2[--n9 + 1];
                        Object object5 = objectArray2[n9];
                        if (object4 == object || object5 == object) {
                            d2 = Interpreter.stack_double(objectArray2, dArray, n9 + 1);
                            d = Interpreter.stack_double(objectArray2, dArray, n9);
                            bl = d2 == d2 && d == d && d <= d2;
                        } else {
                            bl = 1 == ScriptRuntime.cmp_LE(object5, object4);
                        }
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 18: {
                        boolean bl;
                        double d;
                        double d2;
                        Object object4 = objectArray2[--n9 + 1];
                        Object object5 = objectArray2[n9];
                        if (object4 == object || object5 == object) {
                            d2 = Interpreter.stack_double(objectArray2, dArray, n9 + 1);
                            d = Interpreter.stack_double(objectArray2, dArray, n9);
                            bl = d2 == d2 && d == d && d2 < d;
                        } else {
                            bl = 1 == ScriptRuntime.cmp_LT(object4, object5);
                        }
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 16: {
                        boolean bl;
                        double d;
                        double d2;
                        Object object4 = objectArray2[--n9 + 1];
                        Object object5 = objectArray2[n9];
                        if (object4 == object || object5 == object) {
                            d2 = Interpreter.stack_double(objectArray2, dArray, n9 + 1);
                            d = Interpreter.stack_double(objectArray2, dArray, n9);
                            bl = d2 == d2 && d == d && d < d2;
                        } else {
                            bl = 1 == ScriptRuntime.cmp_LT(object5, object4);
                        }
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 63: {
                        boolean bl;
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = (bl = ScriptRuntime.in(object5, object4, scriptable)) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 64: {
                        boolean bl;
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = (bl = ScriptRuntime.instanceOf(scriptable, object5, object4)) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 14: {
                        boolean bl = Interpreter.do_eq(objectArray2, dArray, --n9);
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 15: {
                        boolean bl = !Interpreter.do_eq(objectArray2, dArray, --n9);
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 53: {
                        boolean bl = Interpreter.do_sheq(objectArray2, dArray, --n9);
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 54: {
                        boolean bl = !Interpreter.do_sheq(objectArray2, dArray, --n9);
                        objectArray2[n9] = bl ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 8: {
                        double d;
                        Object object6 = objectArray2[n9];
                        boolean bl = object6 != object ? !ScriptRuntime.toBoolean(object6) : (d = dArray[n9]) != d || d == 0.0;
                        --n9;
                        if (bl) {
                            if (n15 != 0 && (n16 += n10 + 3 - n14) > n15) {
                                context.observeInstructionCount(n16);
                                n16 = 0;
                            }
                            n14 = n10 = Interpreter.getTarget(byArray, n10 + 1);
                            continue block98;
                        }
                        n10 += 2;
                        break;
                    }
                    case 7: {
                        double d;
                        Object object6 = objectArray2[n9];
                        boolean bl = object6 != object ? ScriptRuntime.toBoolean(object6) : (d = dArray[n9]) == d && d != 0.0;
                        --n9;
                        if (bl) {
                            if (n15 != 0 && (n16 += n10 + 3 - n14) > n15) {
                                context.observeInstructionCount(n16);
                                n16 = 0;
                            }
                            n14 = n10 = Interpreter.getTarget(byArray, n10 + 1);
                            continue block98;
                        }
                        n10 += 2;
                        break;
                    }
                    case 6: {
                        if (n15 != 0 && (n16 += n10 + 3 - n14) > n15) {
                            context.observeInstructionCount(n16);
                            n16 = 0;
                        }
                        n14 = n10 = Interpreter.getTarget(byArray, n10 + 1);
                        continue block98;
                    }
                    case 65: {
                        dArray[++n9] = n10 + 3;
                        if (n15 != 0 && (n16 += n10 + 3 - n14) > n15) {
                            context.observeInstructionCount(n16);
                            n16 = 0;
                        }
                        n14 = n10 = Interpreter.getTarget(byArray, n10 + 1);
                        continue block98;
                    }
                    case 66: {
                        int n17 = byArray[n10 + 1] & 0xFF;
                        if (n15 != 0 && (n16 += n10 + 2 - n14) > n15) {
                            context.observeInstructionCount(n16);
                            n16 = 0;
                        }
                        n14 = n10 = (int)dArray[n7 + n17];
                        continue block98;
                    }
                    case 57: {
                        --n9;
                        break;
                    }
                    case 9: {
                        objectArray2[n9 + 1] = objectArray2[n9];
                        dArray[n9 + 1] = dArray[n9];
                        ++n9;
                        break;
                    }
                    case 2: {
                        object3 = objectArray2[n9];
                        if (object3 == object) {
                            object3 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        --n9;
                        break;
                    }
                    case 5: {
                        object3 = objectArray2[n9];
                        if (object3 == object) {
                            object3 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        --n9;
                        n10 = Interpreter.getTarget(byArray, n10 + 1);
                        break;
                    }
                    case 28: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9);
                        objectArray2[n9] = object;
                        dArray[n9] = ~n18;
                        break;
                    }
                    case 13: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9);
                        int n19 = Interpreter.stack_int32(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = n19 & n18;
                        break;
                    }
                    case 11: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9);
                        int n19 = Interpreter.stack_int32(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = n19 | n18;
                        break;
                    }
                    case 12: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9);
                        int n19 = Interpreter.stack_int32(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = n19 ^ n18;
                        break;
                    }
                    case 20: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9);
                        int n19 = Interpreter.stack_int32(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = n19 << n18;
                        break;
                    }
                    case 21: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9);
                        int n19 = Interpreter.stack_int32(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = n19 >> n18;
                        break;
                    }
                    case 22: {
                        int n18 = Interpreter.stack_int32(objectArray2, dArray, n9) & 0x1F;
                        double d = Interpreter.stack_double(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = ScriptRuntime.toUint32(d) >>> n18;
                        break;
                    }
                    case 23: {
                        Interpreter.do_add(objectArray2, dArray, --n9);
                        break;
                    }
                    case 24: {
                        double d2 = Interpreter.stack_double(objectArray2, dArray, n9);
                        double d = Interpreter.stack_double(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = d - d2;
                        break;
                    }
                    case 29: {
                        double d2 = Interpreter.stack_double(objectArray2, dArray, n9);
                        objectArray2[n9] = object;
                        dArray[n9] = -d2;
                        break;
                    }
                    case 58: {
                        double d2 = Interpreter.stack_double(objectArray2, dArray, n9);
                        objectArray2[n9] = object;
                        dArray[n9] = d2;
                        break;
                    }
                    case 25: {
                        double d2 = Interpreter.stack_double(objectArray2, dArray, n9);
                        double d = Interpreter.stack_double(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = d * d2;
                        break;
                    }
                    case 26: {
                        double d2 = Interpreter.stack_double(objectArray2, dArray, n9);
                        double d = Interpreter.stack_double(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = d / d2;
                        break;
                    }
                    case 27: {
                        double d2 = Interpreter.stack_double(objectArray2, dArray, n9);
                        double d = Interpreter.stack_double(objectArray2, dArray, --n9);
                        objectArray2[n9] = object;
                        dArray[n9] = d % d2;
                        break;
                    }
                    case 61: {
                        string = stringArray[Interpreter.getShort(byArray, n10 + 1)];
                        objectArray2[++n9] = ScriptRuntime.bind(scriptable, string);
                        n10 += 2;
                        break;
                    }
                    case 71: {
                        string = stringArray[Interpreter.getShort(byArray, n10 + 1)];
                        objectArray2[++n9] = ScriptRuntime.getBase(scriptable, string);
                        n10 += 2;
                        break;
                    }
                    case 10: {
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        Object object5 = objectArray2[--n9];
                        objectArray2[n9] = ScriptRuntime.setName((Scriptable)object5, object4, scriptable, stringArray[Interpreter.getShort(byArray, n10 + 1)]);
                        n10 += 2;
                        break;
                    }
                    case 31: {
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.delete(object5, object4);
                        break;
                    }
                    case 39: {
                        string = (String)objectArray2[n9];
                        Object object5 = objectArray2[--n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.getProp(object5, string, scriptable);
                        break;
                    }
                    case 40: {
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        string = (String)objectArray2[--n9];
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.setProp(object5, string, object4, scriptable);
                        break;
                    }
                    case 41: {
                        Interpreter.do_getElem(objectArray2, dArray, n9, scriptable);
                        --n9;
                        break;
                    }
                    case 42: {
                        Interpreter.do_setElem(objectArray2, dArray, n9, scriptable);
                        n9 -= 2;
                        break;
                    }
                    case 34: {
                        string = (String)objectArray2[n9];
                        Object object5 = objectArray2[--n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.postIncrement(object5, string, scriptable);
                        break;
                    }
                    case 37: {
                        string = (String)objectArray2[n9];
                        Object object5 = objectArray2[--n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.postDecrement(object5, string, scriptable);
                        break;
                    }
                    case 35: {
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.postIncrementElem(object5, object4, scriptable);
                        break;
                    }
                    case 38: {
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.postDecrementElem(object5, object4, scriptable);
                        break;
                    }
                    case 68: {
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.getThis((Scriptable)object5);
                        break;
                    }
                    case 69: {
                        int n17 = byArray[++n10] & 0xFF;
                        objectArray2[n7 + n17] = objectArray2[n9];
                        dArray[n7 + n17] = dArray[n9];
                        break;
                    }
                    case 70: {
                        int n17 = byArray[++n10] & 0xFF;
                        objectArray2[++n9] = objectArray2[n7 + n17];
                        dArray[n9] = dArray[n7 + n17];
                        break;
                    }
                    case 67: {
                        Object object5;
                        if (n15 != 0) {
                            context.instructionCount = n16 += 100;
                            n16 = -1;
                        }
                        int n20 = Interpreter.getShort(byArray, n10 + 1);
                        string = stringArray[Interpreter.getShort(byArray, n10 + 3)];
                        int n21 = Interpreter.getShort(byArray, n10 + 5);
                        Object[] objectArray3 = Interpreter.getArgsArray(objectArray2, dArray, n9, n21);
                        Object object4 = objectArray2[n9 -= n21];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.callSpecial(context, object5, object4, objectArray3, scriptable2, scriptable, string, n20);
                        n10 += 6;
                        n16 = context.instructionCount;
                        break;
                    }
                    case 43: {
                        Object object5;
                        if (n15 != 0) {
                            context.instructionCount = n16 += 100;
                            n16 = -1;
                        }
                        context.instructionCount = n16;
                        int n21 = Interpreter.getShort(byArray, n10 + 3);
                        Object[] objectArray3 = Interpreter.getArgsArray(objectArray2, dArray, n9, n21);
                        Object object4 = objectArray2[n9 -= n21];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if (object5 == scriptable3 && (n = Interpreter.getShort(byArray, n10 + 1)) != -1) {
                            object5 = stringArray[n];
                        }
                        Scriptable scriptable4 = scriptable;
                        if (interpreterData.itsNeedsActivation) {
                            scriptable4 = ScriptableObject.getTopLevelScope(scriptable);
                        }
                        objectArray2[n9] = ScriptRuntime.call(context, object5, object4, objectArray3, scriptable4);
                        n10 += 4;
                        n16 = context.instructionCount;
                        break;
                    }
                    case 30: {
                        if (n15 != 0) {
                            context.instructionCount = n16 += 100;
                            n16 = -1;
                        }
                        int n21 = Interpreter.getShort(byArray, n10 + 3);
                        Object[] objectArray3 = Interpreter.getArgsArray(objectArray2, dArray, n9, n21);
                        Object object5 = objectArray2[n9 -= n21];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if (object5 == scriptable3 && Interpreter.getShort(byArray, n10 + 1) != -1) {
                            object5 = stringArray[Interpreter.getShort(byArray, n10 + 1)];
                        }
                        objectArray2[n9] = ScriptRuntime.newObject(context, object5, objectArray3, scriptable);
                        n10 += 4;
                        n16 = context.instructionCount;
                        break;
                    }
                    case 32: {
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.typeof(object5);
                        break;
                    }
                    case 78: {
                        string = stringArray[Interpreter.getShort(byArray, n10 + 1)];
                        objectArray2[++n9] = ScriptRuntime.typeofName(scriptable, string);
                        n10 += 2;
                        break;
                    }
                    case 46: {
                        objectArray2[++n9] = stringArray[Interpreter.getShort(byArray, n10 + 1)];
                        n10 += 2;
                        break;
                    }
                    case 150: {
                        objectArray2[++n9] = object;
                        dArray[n9] = Interpreter.getShort(byArray, n10 + 1);
                        n10 += 2;
                        break;
                    }
                    case 151: {
                        objectArray2[++n9] = object;
                        dArray[n9] = Interpreter.getInt(byArray, n10 + 1);
                        n10 += 4;
                        break;
                    }
                    case 45: {
                        objectArray2[++n9] = object;
                        dArray[n9] = interpreterData.itsDoubleTable[Interpreter.getShort(byArray, n10 + 1)];
                        n10 += 2;
                        break;
                    }
                    case 44: {
                        objectArray2[++n9] = ScriptRuntime.name(scriptable, stringArray[Interpreter.getShort(byArray, n10 + 1)]);
                        n10 += 2;
                        break;
                    }
                    case 33: {
                        objectArray2[++n9] = ScriptRuntime.postIncrement(scriptable, stringArray[Interpreter.getShort(byArray, n10 + 1)]);
                        n10 += 2;
                        break;
                    }
                    case 36: {
                        objectArray2[++n9] = ScriptRuntime.postDecrement(scriptable, stringArray[Interpreter.getShort(byArray, n10 + 1)]);
                        n10 += 2;
                        break;
                    }
                    case 73: {
                        int n17 = byArray[++n10] & 0xFF;
                        objectArray2[n6 + n17] = objectArray2[n9];
                        dArray[n6 + n17] = dArray[n9];
                        break;
                    }
                    case 72: {
                        int n17 = byArray[++n10] & 0xFF;
                        objectArray2[++n9] = objectArray2[n6 + n17];
                        dArray[n9] = dArray[n6 + n17];
                        break;
                    }
                    case 59: {
                        int n17 = byArray[++n10] & 0xFF;
                        objectArray2[++n9] = objectArray2[n6 + n17];
                        dArray[n9] = dArray[n6 + n17];
                        objectArray2[n6 + n17] = object;
                        dArray[n6 + n17] = Interpreter.stack_double(objectArray2, dArray, n9) + 1.0;
                        break;
                    }
                    case 60: {
                        int n17 = byArray[++n10] & 0xFF;
                        objectArray2[++n9] = objectArray2[n6 + n17];
                        dArray[n9] = dArray[n6 + n17];
                        objectArray2[n6 + n17] = object;
                        dArray[n6 + n17] = Interpreter.stack_double(objectArray2, dArray, n9) - 1.0;
                        break;
                    }
                    case 47: {
                        objectArray2[++n9] = object;
                        dArray[n9] = 0.0;
                        break;
                    }
                    case 48: {
                        objectArray2[++n9] = object;
                        dArray[n9] = 1.0;
                        break;
                    }
                    case 49: {
                        objectArray2[++n9] = null;
                        break;
                    }
                    case 50: {
                        objectArray2[++n9] = scriptable2;
                        break;
                    }
                    case 87: {
                        objectArray2[++n9] = nativeFunction;
                        break;
                    }
                    case 51: {
                        objectArray2[++n9] = Boolean.FALSE;
                        break;
                    }
                    case 52: {
                        objectArray2[++n9] = Boolean.TRUE;
                        break;
                    }
                    case 74: {
                        objectArray2[++n9] = Undefined.instance;
                        break;
                    }
                    case 62: {
                        object3 = objectArray2[n9];
                        if (object3 == object) {
                            object3 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        --n9;
                        throw new JavaScriptException(object3);
                    }
                    case 88: {
                        object3 = objectArray2[n9];
                        --n9;
                        if (object3 instanceof JavaScriptException) {
                            throw (JavaScriptException)object3;
                        }
                        throw (RuntimeException)object3;
                    }
                    case 3: {
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        --n9;
                        scriptable = ScriptRuntime.enterWith(object5, scriptable);
                        break;
                    }
                    case 4: {
                        scriptable = ScriptRuntime.leaveWith(scriptable);
                        break;
                    }
                    case 77: {
                        objectArray2[++n9] = ScriptRuntime.newScope();
                        break;
                    }
                    case 79: {
                        int n17 = byArray[++n10] & 0xFF;
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        --n9;
                        objectArray2[n7 + n17] = ScriptRuntime.initEnum(object5, scriptable);
                        break;
                    }
                    case 80: {
                        int n17 = byArray[++n10] & 0xFF;
                        Object object6 = objectArray2[n7 + n17];
                        objectArray2[++n9] = ScriptRuntime.nextEnum((Enumeration)object6);
                        break;
                    }
                    case 81: {
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.getProto(object5, scriptable);
                        break;
                    }
                    case 82: {
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.getParent(object5);
                        break;
                    }
                    case 86: {
                        Object object5 = objectArray2[n9];
                        if (object5 == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.getParent(object5, scriptable);
                        break;
                    }
                    case 83: {
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.setProto(object5, object4, scriptable);
                        break;
                    }
                    case 84: {
                        Object object5;
                        Object object4 = objectArray2[n9];
                        if (object4 == object) {
                            object4 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        if ((object5 = objectArray2[--n9]) == object) {
                            object5 = Interpreter.doubleWrap(dArray[n9]);
                        }
                        objectArray2[n9] = ScriptRuntime.setParent(object5, object4, scriptable);
                        break;
                    }
                    case 85: {
                        objectArray2[++n9] = scriptable;
                        break;
                    }
                    case 55: {
                        n = Interpreter.getShort(byArray, n10 + 1);
                        objectArray2[++n9] = new InterpretedFunction(interpreterData.itsNestedFunctions[n], scriptable, context);
                        Interpreter.createFunctionObject((InterpretedFunction)objectArray2[n9], scriptable);
                        n10 += 2;
                        break;
                    }
                    case 56: {
                        n = Interpreter.getShort(byArray, n10 + 1);
                        objectArray2[++n9] = interpreterData.itsRegExpLiterals[n];
                        n10 += 2;
                        break;
                    }
                    case 148: {
                        context.interpreterSourceFile = interpreterData.itsSourceFile;
                        break;
                    }
                    case 147: 
                    case 149: {
                        context.interpreterLine = n = Interpreter.getShort(byArray, n10 + 1);
                        if (interpreterFrame != null) {
                            interpreterFrame.setLineNumber(n);
                        }
                        if ((byArray[n10] & 0xFF) == 149 || context.inLineStepMode) {
                            context.getDebuggableEngine().getDebugger().handleBreakpointHit(context);
                        }
                        n10 += 2;
                        break;
                    }
                    default: {
                        Interpreter.dumpICode(interpreterData);
                        throw new RuntimeException("Unknown icode : " + (byArray[n10] & 0xFF) + " @ pc : " + n10);
                    }
                }
                ++n10;
            }
            catch (Throwable throwable) {
                int n22;
                Object object7;
                context.interpreterSecurityDomain = null;
                if (n15 != 0) {
                    if (n16 < 0) {
                        n16 = context.instructionCount;
                    } else {
                        context.instructionCount = n16 += n10 - n14;
                    }
                }
                if (throwable instanceof JavaScriptException) {
                    object7 = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)throwable);
                    n22 = 0;
                } else if (throwable instanceof EcmaError) {
                    object7 = ((EcmaError)throwable).getErrorObject();
                    n22 = 1;
                } else if (throwable instanceof RuntimeException) {
                    object7 = throwable;
                    n22 = 2;
                } else {
                    object7 = throwable;
                    n22 = 3;
                }
                if (n22 != 3 && context.debugger != null) {
                    context.debugger.handleExceptionThrown(context, object7);
                }
                boolean bl = true;
                if (n22 != 3 && n13 > 0) {
                    if ((n22 == 0 || n22 == 1) && (n10 = nArray[--n13 * 2]) != 0) {
                        bl = false;
                    }
                    if (bl && (n10 = nArray[n13 * 2 + 1]) != 0) {
                        bl = false;
                        object7 = throwable;
                    }
                }
                if (bl) {
                    if (interpreterFrame != null) {
                        context.popFrame();
                    }
                    if (n22 == 0) {
                        throw (JavaScriptException)throwable;
                    }
                    if (n22 == 1 || n22 == 2) {
                        throw (RuntimeException)throwable;
                    }
                    throw (Error)throwable;
                }
                if (n15 != 0 && n16 > n15) {
                    context.observeInstructionCount(n16);
                    n16 = 0;
                }
                n14 = n10;
                scriptable = (Scriptable)objectArray2[n8 + n13];
                n9 = 0;
                objectArray2[0] = object7;
                context.interpreterSecurityDomain = interpreterData.securityDomain;
            }
        }
        context.interpreterSecurityDomain = object2;
        if (interpreterFrame != null) {
            context.popFrame();
        }
        if (n15 != 0) {
            if (n16 > n15) {
                context.observeInstructionCount(n16);
                n16 = 0;
            }
            context.instructionCount = n16;
        }
        return object3;
    }

    private static Object doubleWrap(double d) {
        return new Double(d);
    }

    private static int stack_int32(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != DBL_MRK ? ScriptRuntime.toInt32(object) : ScriptRuntime.toInt32(dArray[n]);
    }

    private static double stack_double(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != DBL_MRK ? ScriptRuntime.toNumber(object) : dArray[n];
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n + 1];
            if (object2 == DBL_MRK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
            } else {
                Interpreter.do_add(object2, d, objectArray, dArray, n, true);
            }
        } else if (object2 == DBL_MRK) {
            Interpreter.do_add(object, dArray[n], objectArray, dArray, n, false);
        } else {
            if (object2 instanceof Scriptable) {
                object2 = ((Scriptable)object2).getDefaultValue(null);
            }
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(null);
            }
            if (object2 instanceof String || object instanceof String) {
                objectArray[n] = ScriptRuntime.toString(object2) + ScriptRuntime.toString(object);
            } else {
                double d = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = DBL_MRK;
                dArray[n] = d + d2;
            }
        }
    }

    private static void do_add(Object object, double d, Object[] objectArray, double[] dArray, int n, boolean bl) {
        if (object instanceof Scriptable) {
            object = object == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)object).getDefaultValue(null);
        }
        if (object instanceof String) {
            objectArray[n] = bl ? (String)object + ScriptRuntime.toString(d) : ScriptRuntime.toString(d) + (String)object;
        } else {
            double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
            objectArray[n] = DBL_MRK;
            dArray[n] = d2 + d;
        }
    }

    private static boolean do_eq(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        boolean bl = object == DBL_MRK ? (object2 == DBL_MRK ? dArray[n] == dArray[n + 1] : Interpreter.do_eq(dArray[n + 1], object2)) : (object2 == DBL_MRK ? Interpreter.do_eq(dArray[n], object) : ScriptRuntime.eq(object2, object));
        return bl;
    }

    private static boolean do_eq(double d, Object object) {
        while (true) {
            if (object instanceof Number) {
                return d == ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return d == ScriptRuntime.toNumber((String)object);
            }
            if (object instanceof Boolean) {
                return d == ((Boolean)object != false ? 1.0 : 0.0);
            }
            if (!(object instanceof Scriptable)) break;
            if (object == Undefined.instance) {
                return false;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    private static boolean do_sheq(Object[] objectArray, double[] dArray, int n) {
        boolean bl;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n + 1];
            if (object2 == DBL_MRK) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (object2 == DBL_MRK) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else {
            bl = ScriptRuntime.shallowEq(object2, object);
        }
        return bl;
    }

    private static void do_getElem(Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3 = objectArray[n - 1];
        if (object3 == DBL_MRK) {
            object3 = Interpreter.doubleWrap(dArray[n - 1]);
        }
        if ((object2 = objectArray[n]) != DBL_MRK) {
            object = ScriptRuntime.getElem(object3, object2, scriptable);
        } else {
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(scriptable, object3);
            double d = dArray[n];
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.getElem(scriptable2, n2);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.getStrIdElem(scriptable2, string);
            }
        }
        objectArray[n - 1] = object;
    }

    private static void do_setElem(Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = objectArray[n];
        if (object4 == DBL_MRK) {
            object4 = Interpreter.doubleWrap(dArray[n]);
        }
        if ((object3 = objectArray[n - 2]) == DBL_MRK) {
            object3 = Interpreter.doubleWrap(dArray[n - 2]);
        }
        if ((object2 = objectArray[n - 1]) != DBL_MRK) {
            object = ScriptRuntime.setElem(object3, object2, object4, scriptable);
        } else {
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(scriptable, object3);
            double d = dArray[n - 1];
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.setElem(scriptable2, n2, object4);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.setStrIdElem(scriptable2, string, object4, scriptable);
            }
        }
        objectArray[n - 2] = object;
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        do {
            Object object;
            if ((object = objectArray[n]) == DBL_MRK) {
                object = Interpreter.doubleWrap(dArray[n]);
            }
            objectArray2[--n2] = object;
            --n;
        } while (n2 != 0);
        return objectArray2;
    }

    static {
        DBL_MRK = new Object();
    }
}

