/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoader m_classLoader;

    public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
        this.m_classLoader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.m_classLoader.loadClass(objectStreamClass.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (null != clazz) {
            return clazz;
        }
        return super.resolveClass(objectStreamClass);
    }

    private void printCLs() {
        ClassLoader cl = this.m_classLoader;
        System.out.println("Cl1>" + cl);
        while (cl != null) {
            System.out.println("Cl?>" + cl);
            cl = cl.getParent();
        }
    }
}

