/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLContentSpec;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dtd.XMLNotationDecl;
import org.apache.xerces.impl.dtd.models.CMAny;
import org.apache.xerces.impl.dtd.models.CMBinOp;
import org.apache.xerces.impl.dtd.models.CMLeaf;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMUniOp;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.impl.dtd.models.DFAContentModel;
import org.apache.xerces.impl.dtd.models.MixedContentModel;
import org.apache.xerces.impl.dtd.models.SimpleContentModel;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.Grammar;

public abstract class AbstractDTDGrammar
implements EntityState,
Grammar {
    public static final int TOP_LEVEL_SCOPE = -1;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final short LIST_FLAG = 128;
    private static final short LIST_MASK = -129;
    private SymbolTable fSymbolTable;
    private String fTargetNamespace;
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private short[][] fElementDeclType = new short[4][];
    private String[][] fElementDeclDefaultValue = new String[4][];
    private short[][] fElementDeclDefaultType = new short[4][];
    private DatatypeValidator[][] fElementDeclDatatypeValidator = new DatatypeValidator[4][];
    private int[][] fElementDeclContentSpecIndex = new int[4][];
    private ContentModelValidator[][] fElementDeclContentModelValidator = new ContentModelValidator[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private short[][] fAttributeDeclType = new short[4][];
    private String[][][] fAttributeDeclEnumeration = new String[4][][];
    private short[][] fAttributeDeclDefaultType = new short[4][];
    private DatatypeValidator[][] fAttributeDeclDatatypeValidator = new DatatypeValidator[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private String[][] fAttributeDeclNonNormalizedDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private int fContentSpecCount = 0;
    private short[][] fContentSpecType = new short[4][];
    private Object[][] fContentSpecValue = new Object[4][];
    private Object[][] fContentSpecOtherValue = new Object[4][];
    private int fEntityCount = 0;
    private String[][] fEntityName = new String[4][];
    private String[][] fEntityValue = new String[4][];
    private String[][] fEntityPublicId = new String[4][];
    private String[][] fEntitySystemId = new String[4][];
    private String[][] fEntityBaseSystemId = new String[4][];
    private String[][] fEntityNotation = new String[4][];
    private byte[][] fEntityIsPE = new byte[4][];
    private byte[][] fEntityInExternal = new byte[4][];
    private int fNotationCount = 0;
    private String[][] fNotationName = new String[4][];
    private String[][] fNotationPublicId = new String[4][];
    private String[][] fNotationSystemId = new String[4][];
    private String[][] fNotationBaseSystemId = new String[4][];
    private TupleHashtable fScopeMapping = new TupleHashtable();
    private QName fQName1 = new QName();
    private QName fQName2 = new QName();
    protected XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private int fLeafCount = 0;
    private int fEpsilonIndex = -1;

    protected AbstractDTDGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public String getGrammarType() {
        return "DTD";
    }

    public abstract boolean isNamespaceAware();

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public int getFirstElementDeclIndex() {
        return this.fElementDeclCount > 0 ? this.fElementDeclCount : -1;
    }

    public int getNextElementDeclIndex(int n) {
        return n < this.fElementDeclCount - 1 ? n + 1 : -1;
    }

    public int getElementDeclIndex(String string, int n) {
        int n2 = this.fScopeMapping.get(n, string, null);
        return n2;
    }

    public int getElementDeclIndex(QName qName, int n) {
        int n2 = this.fScopeMapping.get(n, qName.localpart, qName.uri);
        return n2;
    }

    public boolean getElementDecl(int n, XMLElementDecl xMLElementDecl) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLElementDecl.name.setValues(this.fElementDeclName[n2][n3]);
        if (this.fElementDeclType[n2][n3] == -1) {
            xMLElementDecl.type = (short)-1;
            xMLElementDecl.simpleType.list = false;
        } else {
            xMLElementDecl.type = (short)(this.fElementDeclType[n2][n3] & 0xFFFFFF7F);
            boolean bl = xMLElementDecl.simpleType.list = (this.fElementDeclType[n2][n3] & 0x80) != 0;
        }
        if (xMLElementDecl.type == 3 || xMLElementDecl.type == 2) {
            xMLElementDecl.contentModelValidator = this.getElementContentModelValidator(n);
        }
        xMLElementDecl.simpleType.datatypeValidator = this.fElementDeclDatatypeValidator[n2][n3];
        xMLElementDecl.simpleType.defaultType = this.fElementDeclDefaultType[n2][n3];
        xMLElementDecl.simpleType.defaultValue = this.fElementDeclDefaultValue[n2][n3];
        return true;
    }

    public int getFirstAttributeDeclIndex(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[n2][n3];
    }

    public int getNextAttributeDeclIndex(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[n2][n3];
    }

    public int getAttributeDeclIndex(int n, String string) {
        return -1;
    }

    public boolean getAttributeDecl(int n, XMLAttributeDecl xMLAttributeDecl) {
        boolean bl;
        short s;
        if (n < 0 || n >= this.fAttributeDeclCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLAttributeDecl.name.setValues(this.fAttributeDeclName[n2][n3]);
        if (this.fAttributeDeclType[n2][n3] == -1) {
            s = -1;
            bl = false;
        } else {
            s = (short)(this.fAttributeDeclType[n2][n3] & 0xFFFFFF7F);
            bl = (this.fAttributeDeclType[n2][n3] & 0x80) != 0;
        }
        xMLAttributeDecl.simpleType.setValues(s, this.fAttributeDeclName[n2][n3].localpart, this.fAttributeDeclEnumeration[n2][n3], bl, this.fAttributeDeclDefaultType[n2][n3], this.fAttributeDeclDefaultValue[n2][n3], this.fAttributeDeclNonNormalizedDefaultValue[n2][n3], this.fAttributeDeclDatatypeValidator[n2][n3]);
        return true;
    }

    public boolean isCDATAAttribute(QName qName, QName qName2) {
        int n = this.getElementDeclIndex(qName, -1);
        int n2 = this.getAttributeDeclIndex(n, qName2.rawname);
        return !this.getAttributeDecl(n, this.fAttributeDecl) || this.fAttributeDecl.simpleType.type == 0;
    }

    public int getFirstEntityDeclIndex() {
        throw new RuntimeException("implement Grammar#getFirstEntityDeclIndex():int");
    }

    public int getNextEntityDeclIndex(int n) {
        throw new RuntimeException("implement Grammar#getNextEntityDeclIndex(int):int");
    }

    public int getEntityDeclIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < this.fEntityCount) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            if (this.fEntityName[n2][n3] == string || string.equals(this.fEntityName[n2][n3])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean getEntityDecl(int n, XMLEntityDecl xMLEntityDecl) {
        if (n < 0 || n >= this.fEntityCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLEntityDecl.setValues(this.fEntityName[n2][n3], this.fEntityPublicId[n2][n3], this.fEntitySystemId[n2][n3], this.fEntityBaseSystemId[n2][n3], this.fEntityNotation[n2][n3], this.fEntityValue[n2][n3], this.fEntityIsPE[n2][n3] != 0, this.fEntityInExternal[n2][n3] != 0);
        return true;
    }

    public int getFirstNotationDeclIndex() {
        throw new RuntimeException("implement Grammar#getFirstNotationDeclIndex():int");
    }

    public int getNextNotationDeclIndex(int n) {
        throw new RuntimeException("implement Grammar#getNextNotationDeclIndex(int):int");
    }

    public int getNotationDeclIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < this.fNotationCount) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            if (this.fNotationName[n2][n3] == string || string.equals(this.fNotationName[n2][n3])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean getNotationDecl(int n, XMLNotationDecl xMLNotationDecl) {
        if (n < 0 || n >= this.fNotationCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLNotationDecl.setValues(this.fNotationName[n2][n3], this.fNotationPublicId[n2][n3], this.fNotationSystemId[n2][n3], this.fNotationBaseSystemId[n2][n3]);
        return true;
    }

    public boolean getContentSpec(int n, XMLContentSpec xMLContentSpec) {
        if (n < 0 || n >= this.fContentSpecCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLContentSpec.type = this.fContentSpecType[n2][n3];
        xMLContentSpec.value = this.fContentSpecValue[n2][n3];
        xMLContentSpec.otherValue = this.fContentSpecOtherValue[n2][n3];
        return true;
    }

    public String getContentSpecAsString(int n) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        int n4 = this.fElementDeclContentSpecIndex[n2][n3];
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        if (this.getContentSpec(n4, xMLContentSpec)) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = xMLContentSpec.type & 0xF;
            switch (n5) {
                case 0: {
                    stringBuffer.append('(');
                    if (xMLContentSpec.value == null && xMLContentSpec.otherValue == null) {
                        stringBuffer.append("#PCDATA");
                    } else {
                        stringBuffer.append(xMLContentSpec.value);
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 1: {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    short s = xMLContentSpec.type;
                    if (s == 0) {
                        stringBuffer.append('(');
                        stringBuffer.append(xMLContentSpec.value);
                        stringBuffer.append(')');
                    } else if (s == 3 || s == 2 || s == 1) {
                        stringBuffer.append('(');
                        this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                        stringBuffer.append(')');
                    } else {
                        this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                    }
                    stringBuffer.append('?');
                    break;
                }
                case 2: {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    short s = xMLContentSpec.type;
                    if (s == 0) {
                        stringBuffer.append('(');
                        if (xMLContentSpec.value == null && xMLContentSpec.otherValue == null) {
                            stringBuffer.append("#PCDATA");
                        } else if (xMLContentSpec.otherValue != null) {
                            stringBuffer.append("##any:uri=" + xMLContentSpec.otherValue);
                        } else if (xMLContentSpec.value == null) {
                            stringBuffer.append("##any");
                        } else {
                            this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                        }
                        stringBuffer.append(')');
                    } else if (s == 3 || s == 2 || s == 1) {
                        stringBuffer.append('(');
                        this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                        stringBuffer.append(')');
                    } else {
                        this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                    }
                    stringBuffer.append('*');
                    break;
                }
                case 3: {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    short s = xMLContentSpec.type;
                    if (s == 0) {
                        stringBuffer.append('(');
                        if (xMLContentSpec.value == null && xMLContentSpec.otherValue == null) {
                            stringBuffer.append("#PCDATA");
                        } else if (xMLContentSpec.otherValue != null) {
                            stringBuffer.append("##any:uri=" + xMLContentSpec.otherValue);
                        } else if (xMLContentSpec.value == null) {
                            stringBuffer.append("##any");
                        } else {
                            stringBuffer.append(xMLContentSpec.value);
                        }
                        stringBuffer.append(')');
                    } else if (s == 3 || s == 2 || s == 1) {
                        stringBuffer.append('(');
                        this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                        stringBuffer.append(')');
                    } else {
                        this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                    }
                    stringBuffer.append('+');
                    break;
                }
                case 4: 
                case 5: {
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n5);
                    break;
                }
                case 6: {
                    stringBuffer.append("##any");
                    if (xMLContentSpec.otherValue == null) break;
                    stringBuffer.append(":uri=");
                    stringBuffer.append(xMLContentSpec.otherValue);
                    break;
                }
                case 7: {
                    stringBuffer.append("##other:uri=");
                    stringBuffer.append(xMLContentSpec.otherValue);
                    break;
                }
                case 8: {
                    stringBuffer.append("##local");
                    break;
                }
                default: {
                    stringBuffer.append("???");
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void printElements() {
        int n = 0;
        XMLElementDecl xMLElementDecl = new XMLElementDecl();
        while (this.getElementDecl(n++, xMLElementDecl)) {
            System.out.println("element decl: " + xMLElementDecl.name + ", " + xMLElementDecl.name.rawname);
        }
    }

    public void printAttributes(int n) {
        int n2 = this.getFirstAttributeDeclIndex(n);
        System.out.print(n);
        System.out.print(" [");
        while (n2 != -1) {
            System.out.print(' ');
            System.out.print(n2);
            this.printAttribute(n2);
            n2 = this.getNextAttributeDeclIndex(n2);
            if (n2 == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    protected ContentModelValidator getElementContentModelValidator(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        ContentModelValidator contentModelValidator = this.fElementDeclContentModelValidator[n2][n3];
        if (contentModelValidator != null) {
            return contentModelValidator;
        }
        short s = this.fElementDeclType[n2][n3];
        if (s == 4) {
            return null;
        }
        int n4 = this.fElementDeclContentSpecIndex[n2][n3];
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        this.getContentSpec(n4, xMLContentSpec);
        if (s == 2) {
            ChildrenList childrenList = new ChildrenList();
            this.contentSpecTree(n4, xMLContentSpec, childrenList);
            contentModelValidator = new MixedContentModel(childrenList.qname, childrenList.type, 0, childrenList.length, false, this.isDTD());
        } else if (s == 3) {
            contentModelValidator = this.createChildModel(n4);
        } else {
            throw new RuntimeException("Unknown content type for a element decl in getElementContentModelValidator() in AbstractDTDGrammar class");
        }
        this.fElementDeclContentModelValidator[n2][n3] = contentModelValidator;
        return contentModelValidator;
    }

    protected int createElementDecl() {
        int n = this.fElementDeclCount >> 8;
        int n2 = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(n);
        this.fElementDeclName[n][n2] = new QName();
        this.fElementDeclType[n][n2] = -1;
        this.fElementDeclDatatypeValidator[n][n2] = null;
        this.fElementDeclContentModelValidator[n][n2] = null;
        this.fElementDeclFirstAttributeDeclIndex[n][n2] = -1;
        this.fElementDeclLastAttributeDeclIndex[n][n2] = -1;
        this.fElementDeclDefaultValue[n][n2] = null;
        this.fElementDeclDefaultType[n][n2] = -1;
        return this.fElementDeclCount++;
    }

    protected void setElementDecl(int n, XMLElementDecl xMLElementDecl) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        int n4 = xMLElementDecl.scope;
        this.fElementDeclName[n2][n3].setValues(xMLElementDecl.name);
        this.fElementDeclType[n2][n3] = xMLElementDecl.type;
        this.fElementDeclDatatypeValidator[n2][n3] = xMLElementDecl.simpleType.datatypeValidator;
        this.fElementDeclDefaultType[n2][n3] = xMLElementDecl.simpleType.defaultType;
        this.fElementDeclDefaultValue[n2][n3] = xMLElementDecl.simpleType.defaultValue;
        this.fElementDeclContentModelValidator[n2][n3] = xMLElementDecl.contentModelValidator;
        if (xMLElementDecl.simpleType.list) {
            short[] sArray = this.fElementDeclType[n2];
            int n5 = n3;
            sArray[n5] = (short)(sArray[n5] | 0x80);
        }
        if (this.isDTD()) {
            this.fScopeMapping.put(n4, xMLElementDecl.name.rawname, null, n);
        } else {
            this.fScopeMapping.put(n4, xMLElementDecl.name.localpart, xMLElementDecl.name.uri, n);
        }
    }

    protected void putElementNameMapping(QName qName, int n, int n2) {
    }

    protected void setFirstAttributeDeclIndex(int n, int n2) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[n3][n4] = n2;
    }

    protected void setContentSpecIndex(int n, int n2) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.fElementDeclContentSpecIndex[n3][n4] = n2;
    }

    protected int createAttributeDecl() {
        int n = this.fAttributeDeclCount >> 8;
        int n2 = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(n);
        this.fAttributeDeclName[n][n2] = new QName();
        this.fAttributeDeclType[n][n2] = -1;
        this.fAttributeDeclDatatypeValidator[n][n2] = null;
        this.fAttributeDeclEnumeration[n][n2] = null;
        this.fAttributeDeclDefaultType[n][n2] = 0;
        this.fAttributeDeclDefaultValue[n][n2] = null;
        this.fAttributeDeclNonNormalizedDefaultValue[n][n2] = null;
        this.fAttributeDeclNextAttributeDeclIndex[n][n2] = -1;
        return this.fAttributeDeclCount++;
    }

    protected void setAttributeDecl(int n, int n2, XMLAttributeDecl xMLAttributeDecl) {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        this.fAttributeDeclName[n3][n4].setValues(xMLAttributeDecl.name);
        this.fAttributeDeclType[n3][n4] = xMLAttributeDecl.simpleType.type;
        if (xMLAttributeDecl.simpleType.list) {
            short[] sArray = this.fAttributeDeclType[n3];
            int n5 = n4;
            sArray[n5] = (short)(sArray[n5] | 0x80);
        }
        this.fAttributeDeclEnumeration[n3][n4] = xMLAttributeDecl.simpleType.enumeration;
        this.fAttributeDeclDefaultType[n3][n4] = xMLAttributeDecl.simpleType.defaultType;
        this.fAttributeDeclDatatypeValidator[n3][n4] = xMLAttributeDecl.simpleType.datatypeValidator;
        this.fAttributeDeclDefaultValue[n3][n4] = xMLAttributeDecl.simpleType.defaultValue;
        this.fAttributeDeclNonNormalizedDefaultValue[n3][n4] = xMLAttributeDecl.simpleType.nonNormalizedDefaultValue;
        int n6 = n >> 8;
        int n7 = n & 0xFF;
        int n8 = this.fElementDeclFirstAttributeDeclIndex[n6][n7];
        while (n8 != -1) {
            if (n8 == n2) break;
            n3 = n8 >> 8;
            n4 = n8 & 0xFF;
            n8 = this.fAttributeDeclNextAttributeDeclIndex[n3][n4];
        }
        if (n8 == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[n6][n7] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[n6][n7] = n2;
            } else {
                n8 = this.fElementDeclLastAttributeDeclIndex[n6][n7];
                n3 = n8 >> 8;
                n4 = n8 & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[n3][n4] = n2;
            }
            this.fElementDeclLastAttributeDeclIndex[n6][n7] = n2;
        }
    }

    protected int createContentSpec() {
        int n = this.fContentSpecCount >> 8;
        int n2 = this.fContentSpecCount & 0xFF;
        this.ensureContentSpecCapacity(n);
        this.fContentSpecType[n][n2] = -1;
        this.fContentSpecValue[n][n2] = null;
        this.fContentSpecOtherValue[n][n2] = null;
        return this.fContentSpecCount++;
    }

    protected void setContentSpec(int n, XMLContentSpec xMLContentSpec) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.fContentSpecType[n2][n3] = xMLContentSpec.type;
        this.fContentSpecValue[n2][n3] = xMLContentSpec.value;
        this.fContentSpecOtherValue[n2][n3] = xMLContentSpec.otherValue;
    }

    protected int createEntityDecl() {
        int n = this.fEntityCount >> 8;
        int n2 = this.fEntityCount & 0xFF;
        this.ensureEntityDeclCapacity(n);
        this.fEntityIsPE[n][n2] = 0;
        this.fEntityInExternal[n][n2] = 0;
        return this.fEntityCount++;
    }

    protected void setEntityDecl(int n, XMLEntityDecl xMLEntityDecl) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.fEntityName[n2][n3] = xMLEntityDecl.name;
        this.fEntityValue[n2][n3] = xMLEntityDecl.value;
        this.fEntityPublicId[n2][n3] = xMLEntityDecl.publicId;
        this.fEntitySystemId[n2][n3] = xMLEntityDecl.systemId;
        this.fEntityBaseSystemId[n2][n3] = xMLEntityDecl.baseSystemId;
        this.fEntityNotation[n2][n3] = xMLEntityDecl.notation;
        this.fEntityIsPE[n2][n3] = xMLEntityDecl.isPE ? (byte)1 : 0;
        this.fEntityInExternal[n2][n3] = xMLEntityDecl.inExternal ? (byte)1 : 0;
    }

    protected int createNotationDecl() {
        int n = this.fNotationCount >> 8;
        int n2 = this.fNotationCount & 0xFF;
        this.ensureNotationDeclCapacity(n);
        return this.fNotationCount++;
    }

    protected void setNotationDecl(int n, XMLNotationDecl xMLNotationDecl) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.fNotationName[n2][n3] = xMLNotationDecl.name;
        this.fNotationPublicId[n2][n3] = xMLNotationDecl.publicId;
        this.fNotationSystemId[n2][n3] = xMLNotationDecl.systemId;
        this.fNotationBaseSystemId[n2][n3] = xMLNotationDecl.baseSystemId;
    }

    protected void setTargetNamespace(String string) {
        this.fTargetNamespace = string;
    }

    protected boolean isDTD() {
        return true;
    }

    private void appendContentSpec(XMLContentSpec xMLContentSpec, StringBuffer stringBuffer, boolean bl, int n) {
        int n2 = xMLContentSpec.type & 0xF;
        switch (n2) {
            case 0: {
                if (xMLContentSpec.value == null && xMLContentSpec.otherValue == null) {
                    stringBuffer.append("#PCDATA");
                    break;
                }
                if (xMLContentSpec.value == null && xMLContentSpec.otherValue != null) {
                    stringBuffer.append("##any:uri=" + xMLContentSpec.otherValue);
                    break;
                }
                if (xMLContentSpec.value == null) {
                    stringBuffer.append("##any");
                    break;
                }
                stringBuffer.append(xMLContentSpec.value);
                break;
            }
            case 1: {
                if (n == 3 || n == 2 || n == 1) {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    stringBuffer.append('(');
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                    stringBuffer.append(')');
                } else {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                }
                stringBuffer.append('?');
                break;
            }
            case 2: {
                if (n == 3 || n == 2 || n == 1) {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    stringBuffer.append('(');
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                    stringBuffer.append(')');
                } else {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                }
                stringBuffer.append('*');
                break;
            }
            case 3: {
                if (n == 3 || n == 2 || n == 1) {
                    stringBuffer.append('(');
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                    stringBuffer.append(')');
                } else {
                    this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                    this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                }
                stringBuffer.append('+');
                break;
            }
            case 4: 
            case 5: {
                if (bl) {
                    stringBuffer.append('(');
                }
                short s = xMLContentSpec.type;
                int n3 = ((int[])xMLContentSpec.otherValue)[0];
                this.getContentSpec(((int[])xMLContentSpec.value)[0], xMLContentSpec);
                this.appendContentSpec(xMLContentSpec, stringBuffer, xMLContentSpec.type != s, n2);
                if (s == 4) {
                    stringBuffer.append('|');
                } else {
                    stringBuffer.append(',');
                }
                this.getContentSpec(n3, xMLContentSpec);
                this.appendContentSpec(xMLContentSpec, stringBuffer, true, n2);
                if (!bl) break;
                stringBuffer.append(')');
                break;
            }
            case 6: {
                stringBuffer.append("##any");
                if (xMLContentSpec.otherValue == null) break;
                stringBuffer.append(":uri=");
                stringBuffer.append(xMLContentSpec.otherValue);
                break;
            }
            case 7: {
                stringBuffer.append("##other:uri=");
                stringBuffer.append(xMLContentSpec.otherValue);
                break;
            }
            case 8: {
                stringBuffer.append("##local");
                break;
            }
            default: {
                stringBuffer.append("???");
            }
        }
    }

    private void printAttribute(int n) {
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(n, xMLAttributeDecl)) {
            System.out.print(" { ");
            System.out.print(xMLAttributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    private ContentModelValidator createChildModel(int n) {
        Object object;
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        this.getContentSpec(n, xMLContentSpec);
        if ((xMLContentSpec.type & 0xF) != 6 && (xMLContentSpec.type & 0xF) != 7 && (xMLContentSpec.type & 0xF) != 8) {
            if (xMLContentSpec.type == 0) {
                if (xMLContentSpec.value == null && xMLContentSpec.otherValue == null) {
                    throw new RuntimeException("ImplementationMessages.VAL_NPCD");
                }
                this.fQName1.setValues(null, (String)xMLContentSpec.value, (String)xMLContentSpec.value, (String)xMLContentSpec.otherValue);
                return new SimpleContentModel(xMLContentSpec.type, this.fQName1, null, this.isDTD());
            }
            if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
                object = new XMLContentSpec();
                XMLContentSpec xMLContentSpec2 = new XMLContentSpec();
                this.getContentSpec(((int[])xMLContentSpec.value)[0], (XMLContentSpec)object);
                this.getContentSpec(((int[])xMLContentSpec.otherValue)[0], xMLContentSpec2);
                if (((XMLContentSpec)object).type == 0 && xMLContentSpec2.type == 0) {
                    this.fQName1.setValues(null, (String)((XMLContentSpec)object).value, (String)((XMLContentSpec)object).value, (String)((XMLContentSpec)object).otherValue);
                    this.fQName2.setValues(null, (String)xMLContentSpec2.value, (String)xMLContentSpec2.value, (String)xMLContentSpec2.otherValue);
                    return new SimpleContentModel(xMLContentSpec.type, this.fQName1, this.fQName2, this.isDTD());
                }
            } else if (xMLContentSpec.type == 1 || xMLContentSpec.type == 2 || xMLContentSpec.type == 3) {
                object = new XMLContentSpec();
                this.getContentSpec(((int[])xMLContentSpec.value)[0], (XMLContentSpec)object);
                if (((XMLContentSpec)object).type == 0) {
                    this.fQName1.setValues(null, (String)((XMLContentSpec)object).value, (String)((XMLContentSpec)object).value, (String)((XMLContentSpec)object).otherValue);
                    return new SimpleContentModel(xMLContentSpec.type, this.fQName1, null, this.isDTD());
                }
            } else {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        this.fLeafCount = 0;
        this.fLeafCount = 0;
        object = this.buildSyntaxTree(n, xMLContentSpec);
        return new DFAContentModel((CMNode)object, this.fLeafCount, this.isDTD(), false);
    }

    private final CMNode buildSyntaxTree(int n, XMLContentSpec xMLContentSpec) {
        CMNode cMNode = null;
        this.getContentSpec(n, xMLContentSpec);
        if ((xMLContentSpec.type & 0xF) == 6) {
            cMNode = new CMAny(xMLContentSpec.type, (String)xMLContentSpec.otherValue, this.fLeafCount++);
        } else if ((xMLContentSpec.type & 0xF) == 7) {
            cMNode = new CMAny(xMLContentSpec.type, (String)xMLContentSpec.otherValue, this.fLeafCount++);
        } else if ((xMLContentSpec.type & 0xF) == 8) {
            cMNode = new CMAny(xMLContentSpec.type, null, this.fLeafCount++);
        } else if (xMLContentSpec.type == 0) {
            this.fQName1.setValues(null, (String)xMLContentSpec.value, (String)xMLContentSpec.value, (String)xMLContentSpec.otherValue);
            cMNode = new CMLeaf(this.fQName1, this.fLeafCount++);
        } else {
            int n2 = ((int[])xMLContentSpec.value)[0];
            int n3 = ((int[])xMLContentSpec.otherValue)[0];
            if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
                cMNode = new CMBinOp(xMLContentSpec.type, this.buildSyntaxTree(n2, xMLContentSpec), this.buildSyntaxTree(n3, xMLContentSpec));
            } else if (xMLContentSpec.type == 2) {
                cMNode = new CMUniOp(xMLContentSpec.type, this.buildSyntaxTree(n2, xMLContentSpec));
            } else if (xMLContentSpec.type == 2 || xMLContentSpec.type == 1 || xMLContentSpec.type == 3) {
                cMNode = new CMUniOp(xMLContentSpec.type, this.buildSyntaxTree(n2, xMLContentSpec));
            } else {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return cMNode;
    }

    private void contentSpecTree(int n, XMLContentSpec xMLContentSpec, ChildrenList childrenList) {
        this.getContentSpec(n, xMLContentSpec);
        if (xMLContentSpec.type == 0 || (xMLContentSpec.type & 0xF) == 6 || (xMLContentSpec.type & 0xF) == 8 || (xMLContentSpec.type & 0xF) == 7) {
            if (childrenList.length == childrenList.qname.length) {
                QName[] qNameArray = new QName[childrenList.length * 2];
                System.arraycopy(childrenList.qname, 0, qNameArray, 0, childrenList.length);
                childrenList.qname = qNameArray;
                int[] nArray = new int[childrenList.length * 2];
                System.arraycopy(childrenList.type, 0, nArray, 0, childrenList.length);
                childrenList.type = nArray;
            }
            childrenList.qname[childrenList.length] = new QName(null, (String)xMLContentSpec.value, (String)xMLContentSpec.value, (String)xMLContentSpec.otherValue);
            childrenList.type[childrenList.length] = xMLContentSpec.type;
            ++childrenList.length;
            return;
        }
        int n2 = xMLContentSpec.value != null ? ((int[])xMLContentSpec.value)[0] : -1;
        int n3 = -1;
        if (xMLContentSpec.otherValue == null) {
            return;
        }
        n3 = ((int[])xMLContentSpec.otherValue)[0];
        if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
            this.contentSpecTree(n2, xMLContentSpec, childrenList);
            this.contentSpecTree(n3, xMLContentSpec, childrenList);
            return;
        }
        if (xMLContentSpec.type == 1 || xMLContentSpec.type == 2 || xMLContentSpec.type == 3) {
            this.contentSpecTree(n2, xMLContentSpec, childrenList);
            return;
        }
        throw new RuntimeException("Invalid content spec type seen in contentSpecTree() method of Grammar class : " + xMLContentSpec.type);
    }

    private boolean ensureElementDeclCapacity(int n) {
        try {
            return this.fElementDeclName[n][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fElementDeclName = AbstractDTDGrammar.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = AbstractDTDGrammar.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclDatatypeValidator = AbstractDTDGrammar.resize(this.fElementDeclDatatypeValidator, this.fElementDeclDatatypeValidator.length * 2);
            this.fElementDeclContentModelValidator = AbstractDTDGrammar.resize(this.fElementDeclContentModelValidator, this.fElementDeclContentModelValidator.length * 2);
            this.fElementDeclContentSpecIndex = AbstractDTDGrammar.resize(this.fElementDeclContentSpecIndex, this.fElementDeclContentSpecIndex.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = AbstractDTDGrammar.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = AbstractDTDGrammar.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
            this.fElementDeclDefaultValue = AbstractDTDGrammar.resize(this.fElementDeclDefaultValue, this.fElementDeclDefaultValue.length * 2);
            this.fElementDeclDefaultType = AbstractDTDGrammar.resize(this.fElementDeclDefaultType, this.fElementDeclDefaultType.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fElementDeclName[n] = new QName[256];
        this.fElementDeclType[n] = new short[256];
        this.fElementDeclDatatypeValidator[n] = new DatatypeValidator[256];
        this.fElementDeclContentModelValidator[n] = new ContentModelValidator[256];
        this.fElementDeclContentSpecIndex[n] = new int[256];
        this.fElementDeclFirstAttributeDeclIndex[n] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[n] = new int[256];
        this.fElementDeclDefaultValue[n] = new String[256];
        this.fElementDeclDefaultType[n] = new short[256];
        return true;
    }

    private boolean ensureAttributeDeclCapacity(int n) {
        try {
            return this.fAttributeDeclName[n][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fAttributeDeclName = AbstractDTDGrammar.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = AbstractDTDGrammar.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = AbstractDTDGrammar.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = AbstractDTDGrammar.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDatatypeValidator = AbstractDTDGrammar.resize(this.fAttributeDeclDatatypeValidator, this.fAttributeDeclDatatypeValidator.length * 2);
            this.fAttributeDeclDefaultValue = AbstractDTDGrammar.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNonNormalizedDefaultValue = AbstractDTDGrammar.resize(this.fAttributeDeclNonNormalizedDefaultValue, this.fAttributeDeclNonNormalizedDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = AbstractDTDGrammar.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fAttributeDeclName[n] = new QName[256];
        this.fAttributeDeclType[n] = new short[256];
        this.fAttributeDeclEnumeration[n] = new String[256][];
        this.fAttributeDeclDefaultType[n] = new short[256];
        this.fAttributeDeclDatatypeValidator[n] = new DatatypeValidator[256];
        this.fAttributeDeclDefaultValue[n] = new String[256];
        this.fAttributeDeclNonNormalizedDefaultValue[n] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[n] = new int[256];
        return true;
    }

    private boolean ensureEntityDeclCapacity(int n) {
        try {
            return this.fEntityName[n][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fEntityName = AbstractDTDGrammar.resize(this.fEntityName, this.fEntityName.length * 2);
            this.fEntityValue = AbstractDTDGrammar.resize(this.fEntityValue, this.fEntityValue.length * 2);
            this.fEntityPublicId = AbstractDTDGrammar.resize(this.fEntityPublicId, this.fEntityPublicId.length * 2);
            this.fEntitySystemId = AbstractDTDGrammar.resize(this.fEntitySystemId, this.fEntitySystemId.length * 2);
            this.fEntityBaseSystemId = AbstractDTDGrammar.resize(this.fEntityBaseSystemId, this.fEntityBaseSystemId.length * 2);
            this.fEntityNotation = AbstractDTDGrammar.resize(this.fEntityNotation, this.fEntityNotation.length * 2);
            this.fEntityIsPE = AbstractDTDGrammar.resize(this.fEntityIsPE, this.fEntityIsPE.length * 2);
            this.fEntityInExternal = AbstractDTDGrammar.resize(this.fEntityInExternal, this.fEntityInExternal.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fEntityName[n] = new String[256];
        this.fEntityValue[n] = new String[256];
        this.fEntityPublicId[n] = new String[256];
        this.fEntitySystemId[n] = new String[256];
        this.fEntityBaseSystemId[n] = new String[256];
        this.fEntityNotation[n] = new String[256];
        this.fEntityIsPE[n] = new byte[256];
        this.fEntityInExternal[n] = new byte[256];
        return true;
    }

    private boolean ensureNotationDeclCapacity(int n) {
        try {
            return this.fNotationName[n][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fNotationName = AbstractDTDGrammar.resize(this.fNotationName, this.fNotationName.length * 2);
            this.fNotationPublicId = AbstractDTDGrammar.resize(this.fNotationPublicId, this.fNotationPublicId.length * 2);
            this.fNotationSystemId = AbstractDTDGrammar.resize(this.fNotationSystemId, this.fNotationSystemId.length * 2);
            this.fNotationBaseSystemId = AbstractDTDGrammar.resize(this.fNotationBaseSystemId, this.fNotationBaseSystemId.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fNotationName[n] = new String[256];
        this.fNotationPublicId[n] = new String[256];
        this.fNotationSystemId[n] = new String[256];
        this.fNotationBaseSystemId[n] = new String[256];
        return true;
    }

    private boolean ensureContentSpecCapacity(int n) {
        try {
            return this.fContentSpecType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fContentSpecType = AbstractDTDGrammar.resize(this.fContentSpecType, this.fContentSpecType.length * 2);
            this.fContentSpecValue = AbstractDTDGrammar.resize(this.fContentSpecValue, this.fContentSpecValue.length * 2);
            this.fContentSpecOtherValue = AbstractDTDGrammar.resize(this.fContentSpecOtherValue, this.fContentSpecOtherValue.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fContentSpecType[n] = new short[256];
        this.fContentSpecValue[n] = new Object[256];
        this.fContentSpecOtherValue[n] = new Object[256];
        return true;
    }

    private static byte[][] resize(byte[][] byArray, int n) {
        byte[][] byArrayArray = new byte[n][];
        System.arraycopy(byArray, 0, byArrayArray, 0, byArray.length);
        return byArrayArray;
    }

    private static short[][] resize(short[][] sArray, int n) {
        short[][] sArrayArray = new short[n][];
        System.arraycopy(sArray, 0, sArrayArray, 0, sArray.length);
        return sArrayArray;
    }

    private static int[][] resize(int[][] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        System.arraycopy(nArray, 0, nArrayArray, 0, nArray.length);
        return nArrayArray;
    }

    private static DatatypeValidator[][] resize(DatatypeValidator[][] datatypeValidatorArray, int n) {
        DatatypeValidator[][] datatypeValidatorArray2 = new DatatypeValidator[n][];
        System.arraycopy(datatypeValidatorArray, 0, datatypeValidatorArray2, 0, datatypeValidatorArray.length);
        return datatypeValidatorArray2;
    }

    private static ContentModelValidator[][] resize(ContentModelValidator[][] contentModelValidatorArray, int n) {
        ContentModelValidator[][] contentModelValidatorArray2 = new ContentModelValidator[n][];
        System.arraycopy(contentModelValidatorArray, 0, contentModelValidatorArray2, 0, contentModelValidatorArray.length);
        return contentModelValidatorArray2;
    }

    private static Object[][] resize(Object[][] objectArray, int n) {
        Object[][] objectArray2 = new Object[n][];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    private static QName[][] resize(QName[][] qNameArray, int n) {
        QName[][] qNameArray2 = new QName[n][];
        System.arraycopy(qNameArray, 0, qNameArray2, 0, qNameArray.length);
        return qNameArray2;
    }

    private static String[][] resize(String[][] stringArray, int n) {
        String[][] stringArray2 = new String[n][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private static String[][][] resize(String[][][] stringArray, int n) {
        String[][][] stringArray2 = new String[n][][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public boolean isEntityDeclared(String string) {
        return this.getEntityDeclIndex(string) != -1;
    }

    public boolean isEntityUnparsed(String string) {
        int n = this.getEntityDeclIndex(string);
        if (n > -1) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            return this.fEntityNotation[n2][n3] != null;
        }
        return false;
    }

    protected static final class TupleHashtable {
        private static final int INITIAL_BUCKET_SIZE = 4;
        private static final int HASHTABLE_SIZE = 101;
        private Object[][] fHashTable = new Object[101][];

        protected TupleHashtable() {
        }

        public void put(int n, String string, String string2, int n2) {
            int n3 = (n + this.hash(string) + this.hash(string2) + 2) % 101;
            Object[] objectArray = this.fHashTable[n3];
            if (objectArray == null) {
                objectArray = new Object[17];
                objectArray[0] = new int[]{1};
                objectArray[1] = new int[]{n};
                objectArray[2] = string;
                objectArray[3] = string2;
                objectArray[4] = new int[]{n2};
                this.fHashTable[n3] = objectArray;
            } else {
                int n4;
                int n5 = ((int[])objectArray[0])[0];
                int n6 = 1 + 4 * n5;
                if (n6 == objectArray.length) {
                    n4 = n5 + 4;
                    Object[] objectArray2 = new Object[1 + 4 * n4];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n6);
                    objectArray = objectArray2;
                    this.fHashTable[n3] = objectArray;
                }
                n4 = 0;
                int n7 = 1;
                int n8 = 0;
                while (n8 < n5) {
                    if (((int[])objectArray[n7])[0] == n && (String)objectArray[n7 + 1] == string && (String)objectArray[n7 + 2] == string2) {
                        ((int[])objectArray[n7 + 3])[0] = n2;
                        n4 = 1;
                        break;
                    }
                    n7 += 4;
                    ++n8;
                }
                if (n4 == 0) {
                    objectArray[n6++] = new int[]{n};
                    objectArray[n6++] = string;
                    objectArray[n6++] = string2;
                    objectArray[n6] = new int[]{n2};
                    ((int[])objectArray[0])[0] = ++n5;
                }
            }
        }

        public int get(int n, String string, String string2) {
            int n2 = (n + this.hash(string) + this.hash(string2) + 2) % 101;
            Object[] objectArray = this.fHashTable[n2];
            if (objectArray == null) {
                return -1;
            }
            int n3 = ((int[])objectArray[0])[0];
            int n4 = 1;
            int n5 = 0;
            while (n5 < n3) {
                if (((int[])objectArray[n4])[0] == n && (String)objectArray[n4 + 1] == string && (String)objectArray[n4 + 2] == string2) {
                    return ((int[])objectArray[n4 + 3])[0];
                }
                n4 += 4;
                ++n5;
            }
            return -1;
        }

        protected int hash(String string) {
            if (string == null) {
                return 0;
            }
            int n = 0;
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                n = n * 37 + string.charAt(n3);
                ++n3;
            }
            return n & 0x7FFFFFF;
        }
    }

    private static class ChildrenList {
        public int length = 0;
        public QName[] qname = new QName[2];
        public int[] type = new int[2];

        private ChildrenList() {
        }
    }
}

