/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension.resolvers;

import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionResolver;

public class URLResolver
implements ExtensionResolver {
    private File m_destfile;
    private File m_destdir;
    private URL m_url;

    public void setUrl(URL url) {
        this.m_url = url;
    }

    public void setDestfile(File destfile) {
        this.m_destfile = destfile;
    }

    public void setDestdir(File destdir) {
        this.m_destdir = destdir;
    }

    public File resolve(Extension extension, Project project) throws BuildException {
        this.validate();
        File file = this.getDest();
        Get get = (Get)project.createTask("get");
        get.setDest(file);
        get.setSrc(this.m_url);
        get.execute();
        return file;
    }

    private File getDest() {
        if (null != this.m_destfile) {
            return this.m_destfile;
        }
        String file = this.m_url.getFile();
        String filename = null;
        if (null == file || file.length() <= 1) {
            filename = "default.file";
        } else {
            int index = file.lastIndexOf(47);
            if (-1 == index) {
                index = 0;
            }
            filename = file.substring(index);
        }
        return new File(this.m_destdir, filename);
    }

    private void validate() {
        if (null == this.m_url) {
            throw new BuildException("Must specify URL");
        }
        if (null == this.m_destdir && null == this.m_destfile) {
            throw new BuildException("Must specify destination file or directory");
        }
        if (null != this.m_destdir && null != this.m_destfile) {
            throw new BuildException("Must not specify both destination file or directory");
        }
    }

    public String toString() {
        return "URL[" + this.m_url + "]";
    }
}

