/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.ExtensionHandlerJava;
import org.apache.xalan.extensions.ExtensionHandlerJavaClass;
import org.apache.xalan.extensions.ExtensionHandlerJavaPackage;
import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.XPathProcessorException;

public class ExtensionsTable {
    public Hashtable m_extensionFunctionNamespaces = new Hashtable();

    public ExtensionsTable() {
        String uri = "http://xml.apache.org/xslt/java";
        ExtensionHandlerJava fh = new ExtensionHandlerJavaPackage(uri, "xslt-javaclass", "");
        this.addExtensionNamespace(uri, fh);
        uri = "http://xsl.lotus.com/java";
        this.addExtensionNamespace(uri, fh);
        uri = "http://xml.apache.org/xalan";
        fh = new ExtensionHandlerJavaClass(uri, "javaclass", "org.apache.xalan.lib.Extensions");
        this.addExtensionNamespace(uri, fh);
    }

    public ExtensionHandler get(String extns) {
        return (ExtensionHandler)this.m_extensionFunctionNamespaces.get(extns);
    }

    public void addExtensionNamespace(String uri, ExtensionHandler extNS) {
        this.m_extensionFunctionNamespaces.put(uri, extNS);
    }

    public boolean functionAvailable(String ns, String funcName) throws TransformerException {
        boolean isAvailable = false;
        if (null != ns) {
            ExtensionHandler extNS = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(ns);
            if (extNS == null) {
                extNS = this.makeJavaNamespace(ns);
                this.addExtensionNamespace(ns, extNS);
            }
            if (extNS != null) {
                isAvailable = extNS.isFunctionAvailable(funcName);
            }
        }
        return isAvailable;
    }

    public boolean elementAvailable(String ns, String elemName) throws TransformerException {
        boolean isAvailable = false;
        if (null != ns) {
            ExtensionHandler extNS = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(ns);
            if (extNS == null) {
                extNS = this.makeJavaNamespace(ns);
                this.addExtensionNamespace(ns, extNS);
            }
            if (extNS != null) {
                isAvailable = extNS.isElementAvailable(elemName);
            }
        }
        return isAvailable;
    }

    public Object extFunction(String ns, String funcName, Vector argVec, Object methodKey, ExpressionContext exprContext) throws TransformerException {
        Object result = null;
        if (null != ns) {
            ExtensionHandler extNS = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(ns);
            if (null == extNS) {
                extNS = this.makeJavaNamespace(ns);
                this.addExtensionNamespace(ns, extNS);
            }
            if (null != extNS) {
                try {
                    result = extNS.callFunction(funcName, argVec, methodKey, exprContext);
                }
                catch (TransformerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TransformerException(e);
                }
            } else {
                throw new XPathProcessorException(XSLMessages.createMessage(122, new Object[]{ns, funcName}));
            }
        }
        return result;
    }

    public ExtensionHandler makeJavaNamespace(String ns) throws TransformerException {
        int lastSlash;
        if (null == ns || ns.trim().length() == 0) {
            return null;
        }
        String className = ns;
        if (className.startsWith("class:")) {
            className = className.substring(6);
        }
        if (-1 != (lastSlash = className.lastIndexOf("/"))) {
            className = className.substring(lastSlash + 1);
        }
        if (null == className || className.trim().length() == 0) {
            return null;
        }
        try {
            ExtensionHandler.getClassForName(className);
            return new ExtensionHandlerJavaClass(ns, "javaclass", className);
        }
        catch (ClassNotFoundException e) {
            return new ExtensionHandlerJavaPackage(ns, "javapackage", className + ".");
        }
    }
}

