/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;

public class Macro
extends Directive {
    private static boolean debugMode = false;

    public String getName() {
        return "macro";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        return true;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
    }

    public static void processAndRegister(RuntimeServices rs, Node node, String sourceTemplate) throws IOException {
        int numArgs = node.jjtGetNumChildren();
        if (numArgs < 2) {
            rs.error("#macro error : Velocimacro must have name as 1st argument to #macro()");
            return;
        }
        String[] argArray = Macro.getArgArray(node);
        String[] macroArray = Macro.getASTAsStringArray(node.jjtGetChild(numArgs - 1));
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < macroArray.length) {
            temp.append(macroArray[i]);
            ++i;
        }
        String macroBody = temp.toString();
        boolean bRet = rs.addVelocimacro(argArray[0], macroBody, argArray, sourceTemplate);
    }

    private static String[] getArgArray(Node node) {
        int numArgs = node.jjtGetNumChildren();
        String[] argArray = new String[--numArgs];
        int i = 0;
        while (i < numArgs) {
            argArray[i] = node.jjtGetChild((int)i).getFirstToken().image;
            if (i > 0 && argArray[i].startsWith("$")) {
                argArray[i] = argArray[i].substring(1, argArray[i].length());
            }
            ++i;
        }
        if (debugMode) {
            System.out.println("Macro.getArgArray() : #args = " + numArgs);
            System.out.print(argArray[0] + "(");
            i = 1;
            while (i < numArgs) {
                System.out.print(" " + argArray[i]);
                ++i;
            }
            System.out.println(" )");
        }
        return argArray;
    }

    private static String[] getASTAsStringArray(Node rootNode) {
        Token t = rootNode.getFirstToken();
        Token tLast = rootNode.getLastToken();
        int count = 0;
        while (t != null && t != tLast) {
            ++count;
            t = t.next;
        }
        String[] arr = new String[++count];
        count = 0;
        t = rootNode.getFirstToken();
        while (t != tLast) {
            arr[count++] = t.image;
            t = t.next;
        }
        arr[count] = t.image;
        return arr;
    }
}

