/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.ClosableIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ResultSetIterator
implements Iterator,
ClosableIterator {
    protected ResultSet m_resultSet;
    protected SQLCache m_sqlCache;
    protected PreparedStatement m_statement;
    protected String m_opname;
    protected ArrayList m_row;
    protected int m_nCols;
    protected boolean m_finished = false;
    protected boolean m_prefetched = false;

    public ResultSetIterator() {
        this.m_finished = true;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement preparedStatement, SQLCache sQLCache, String string) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = sQLCache;
        this.m_statement = preparedStatement;
        this.m_opname = string;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement preparedStatement) {
        this.m_resultSet = resultSet;
        this.m_statement = preparedStatement;
    }

    public void reset(ResultSet resultSet, PreparedStatement preparedStatement, SQLCache sQLCache, String string) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = sQLCache;
        this.m_statement = preparedStatement;
        this.m_opname = string;
        this.m_finished = false;
        this.m_prefetched = false;
        this.m_row = null;
    }

    public boolean hasNext() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        return !this.m_finished;
    }

    public Object next() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        this.m_prefetched = false;
        if (this.m_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        throw new UnsupportedOperationException("ResultSetIterator can't remove database rows");
    }

    protected void moveForward() {
        try {
            if (!this.m_finished && this.m_resultSet.next()) {
                this.extractRow();
                this.m_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception exception) {
            Log.warning("Problem in iterator over db result set, op = " + this.m_opname, exception);
        }
    }

    protected void extractRow() throws Exception {
        int n;
        if (this.m_row == null) {
            this.m_nCols = this.m_resultSet.getMetaData().getColumnCount();
            this.m_row = new ArrayList(this.m_nCols);
            n = 0;
            while (n < this.m_nCols) {
                this.m_row.add(null);
                ++n;
            }
        }
        n = 0;
        while (n < this.m_nCols) {
            this.m_row.set(n, this.m_resultSet.getObject(n + 1));
            ++n;
        }
    }

    protected Object getRow() {
        return this.m_row;
    }

    public void close() {
        if (!this.m_finished) {
            if (this.m_resultSet != null) {
                try {
                    this.m_resultSet.close();
                }
                catch (SQLException sQLException) {
                    Log.warning("Error while finalizing result set iterator", sQLException);
                }
            }
            if (this.m_sqlCache != null && this.m_opname != null) {
                this.m_sqlCache.returnPreparedSQLStatement(this.m_statement, this.m_opname);
            } else {
                try {
                    this.m_statement.close();
                }
                catch (SQLException sQLException) {
                    Log.warning("Error while finalizing result set iterator", sQLException);
                }
            }
        }
        this.m_finished = true;
    }

    public Object getSingleton() throws SQLException {
        List list = (List)this.next();
        this.close();
        return list.get(0);
    }

    protected void finalize() throws SQLException {
        if (!this.m_finished && this.m_resultSet != null) {
            this.close();
        }
    }
}

