/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.common.SaxErrorHandler;
import com.hp.hpl.mesa.rdf.jena.common.XMLContentHandler;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.megginson.sax.rdf.RDFHandler;
import com.megginson.sax.rdf.RDFReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RDFXMLReader
implements RDFHandler,
com.hp.hpl.mesa.rdf.jena.model.RDFReader {
    static final String saxDriverPropName = "org.xml.sax.driver";
    static final String defaultSaxDriverProp = "org.apache.xerces.parsers.SAXParser";
    static final String namespacePrefixPropName = "http://org.xml.sax/features/namespace-prefixes";
    static final String namespacePropName = "http://org.xml.sax.features/namespace";
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    XMLContentHandler contentHandler = new XMLContentHandler();
    RDFReader rdfReader;
    int subjectType;
    String subject;
    String predicate;
    String language;
    String base;
    Model model;
    HashMap anonResources = new HashMap();

    RDFXMLReader() {
    }

    public void read(Model model, Reader reader, String string) throws RDFException {
        this.model = model;
        this.base = string;
        int n = string.lastIndexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        try {
            String string2 = System.getProperty(saxDriverPropName, defaultSaxDriverProp);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(string2);
            this.rdfReader = new RDFReader(xMLReader);
            this.rdfReader.setRDFHandler((RDFHandler)this);
            this.rdfReader.setContentHandler((ContentHandler)this.getContentHandler());
            this.rdfReader.setErrorHandler((ErrorHandler)new SaxErrorHandler(this.errorHandler));
            this.rdfReader.readRDF(reader);
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public void read(Model model, String string) throws RDFException {
        try {
            this.read(model, new InputStreamReader(new URL(string).openStream()), string);
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Object setProperty(String string, Object object) throws RDFException {
        this.errorHandler.error(new RDFException(22));
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        if (this.rdfReader != null) {
            this.rdfReader.setErrorHandler((ErrorHandler)new SaxErrorHandler(this.errorHandler));
        }
        return rDFErrorHandler2;
    }

    protected XMLContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void literalStatement(int n, String string, String string2, String string3, String string4) {
        this.literalStatement(n, string, string2, string3, string4, false);
    }

    public void literalStatement(int n, String string, String string2, String string3, String string4, boolean bl) {
        if (string4 == null) {
            string4 = "";
        }
        string3 = RDFXMLReader.translateCRLFtoNL(string3);
        try {
            if (n == 1) {
                this.model.add(this.model.createResource(this.translateURI(string)), this.model.createProperty(this.translateURI(string2)), string3, string4, bl);
            } else if (n == 4) {
                this.model.add(this.getAnonResource(string), this.model.createProperty(this.translateURI(string2)), string3, string4, bl);
            } else {
                ErrorHelper.logWarning("subject type not supported: " + string);
            }
        }
        catch (RDFException rDFException) {
            ErrorHelper.logInternalError("RDFLoader", 1, rDFException);
        }
    }

    public void resourceStatement(int n, String string, String string2, String string3) {
        try {
            Resource resource;
            if (n == 1) {
                resource = this.model.createResource(this.translateURI(string));
            } else if (n == 4) {
                resource = this.getAnonResource(string);
            } else {
                ErrorHelper.logWarning("subject type not supported: " + string);
                return;
            }
            Resource resource2 = string3.startsWith("{") ? this.getAnonResource(string3) : this.model.createResource(this.translateURI(string3));
            this.model.add(resource, this.model.createProperty(this.translateURI(string2)), resource2);
        }
        catch (RDFException rDFException) {
            ErrorHelper.logInternalError("RDFLoader", 2, rDFException);
        }
    }

    public void startXMLStatement(int n, String string, String string2, String string3) {
        this.subjectType = n;
        this.subject = string;
        this.predicate = string2;
        this.language = string3;
        this.contentHandler.activate();
    }

    public void endXMLStatement() {
        this.literalStatement(this.subjectType, this.subject, this.predicate, this.contentHandler.deActivate(), this.language, true);
    }

    protected Resource getAnonResource(String string) throws RDFException {
        Resource resource = (Resource)this.anonResources.get(string);
        if (resource == null) {
            resource = this.model.createResource();
            this.anonResources.put(string, resource);
        }
        return resource;
    }

    protected String translateURI(String string) {
        if (string.length() == 0) {
            return this.base;
        }
        if (string.charAt(0) == '#') {
            return this.base + string;
        }
        return string;
    }

    private static String translateCRLFtoNL(String string) {
        if (string.indexOf(13) == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        String.copyValueOf(cArray);
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length - 1) {
            if (cArray[n2] != '\r' || cArray[n2 + 1] != '\n') {
                cArray[n++] = cArray[n2];
            }
            ++n2;
        }
        cArray[n++] = cArray[cArray.length - 1];
        return new String(cArray, 0, n);
    }
}

