/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.LogHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class LogFileHandler
implements LogHandler {
    public static final char FIELD_SEP = '\t';
    protected FileWriter m_file = null;
    protected PrintWriter m_print = null;

    public LogFileHandler(String string, boolean bl) throws IOException {
        this.m_file = new FileWriter(string, bl);
        this.m_print = new PrintWriter(this.m_file);
    }

    public LogFileHandler(String string) throws IOException {
        this(string, false);
    }

    public void publish(int n, String string, String string2, String string3, Throwable throwable) {
        if (this.m_print != null) {
            this.m_print.print(Log.getLevelName(n));
            this.m_print.print('\t');
            this.m_print.print(Log.formatDate());
            this.m_print.print('\t');
            if (string2 != null) {
                this.m_print.print(string2);
                this.m_print.print('\t');
                this.m_print.print(string3);
                this.m_print.print('\t');
            }
            this.m_print.println(string);
            if (throwable != null) {
                throwable.printStackTrace(this.m_print);
            }
            try {
                this.m_file.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            this.m_file.close();
            this.m_file = null;
            this.m_print = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

