/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.test;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsFormatter;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Bag;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestQuery
extends TestCase {
    Model model = null;
    public boolean dumpModel = false;
    public boolean verbose = false;

    public TestQuery(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestQuery("testQuery"));
        return testSuite;
    }

    public static void addTests(TestSuite testSuite) {
        testSuite.addTest((Test)new TestQuery("RDQL Query "));
    }

    protected void runTest() throws Throwable {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SELECT ?x, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)");
        arrayList.add("SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1");
        arrayList.add("SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)");
        arrayList.add("SELECT ?x, ?y WHERE (<http://never/bag>, ?x, ?y) AND ?y ne <http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag>");
        arrayList.add("SELECT ?x, ?y WHERE (<http://never/bag>, ?x, ?y) AND ?x ne <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(string);
            }
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
            queryResultsFormatter.consume();
        }
    }

    public void setUp() throws Exception {
        this.model = TestQuery.makeModel();
    }

    public static Model makeModel() throws Exception {
        ModelMem modelMem = new ModelMem();
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < 2) {
                modelMem.add(modelMem.createResource("http://never/r-" + n), modelMem.createProperty("http://never/p-" + n2), n + n2);
                ++n2;
            }
            ++n;
        }
        Bag bag = modelMem.createBag("http://never/bag");
        bag.add("11");
        bag.add("22");
        modelMem.add(modelMem.createResource("http://never/path"), modelMem.createProperty("http://never/path"), modelMem.createResource("http://never/r-0"));
        return modelMem;
    }

    public void tearDown() {
        this.model = null;
    }
}

