/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import java.util.Iterator;

public class DAMLSelector
extends SelectorImpl {
    protected Resource m_subject = null;
    protected Property m_predicate = null;
    protected RDFNode m_object = null;

    public DAMLSelector(Resource resource, Property property, RDFNode rDFNode) {
        this.m_subject = resource;
        this.m_predicate = property;
        this.m_object = rDFNode;
    }

    public boolean test(Statement statement) {
        return !(this.m_subject != null && !this.matches(this.m_subject, statement.getSubject()) || this.m_predicate != null && !this.matches(this.m_predicate, statement.getPredicate()) || this.m_object != null && !this.matches(this.m_object, statement.getObject()));
    }

    protected boolean matches(RDFNode rDFNode, RDFNode rDFNode2) {
        if (rDFNode.equals(rDFNode2)) {
            return true;
        }
        if (rDFNode instanceof DAMLCommon && rDFNode2 instanceof Resource) {
            DAMLModel dAMLModel = ((DAMLCommon)rDFNode).getDAMLModel();
            if (dAMLModel == null) {
                DAMLModel dAMLModel2 = dAMLModel = rDFNode2 instanceof DAMLCommon ? ((DAMLCommon)rDFNode2).getDAMLModel() : null;
            }
            if (dAMLModel != null && dAMLModel.getUseEquivalence()) {
                return this.checkEquivalenceClass(((DAMLCommon)rDFNode).getEquivalentValues(), (Resource)rDFNode2);
            }
        }
        return false;
    }

    protected boolean checkEquivalenceClass(Iterator iterator, Resource resource) {
        while (iterator.hasNext()) {
            RDFNode rDFNode = (RDFNode)iterator.next();
            Log.finest("Checking equivalence of " + resource + ", and " + rDFNode);
            if (!resource.equals(rDFNode)) continue;
            Log.finest("Equivalence = true");
            return true;
        }
        return false;
    }
}

