/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.daml.PropertyIterator;
import com.hp.hpl.jena.daml.common.DAMLCommonImpl;
import com.hp.hpl.jena.daml.common.PropertyAccessorImpl;
import com.hp.hpl.jena.util.ConcatenatedIterator;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.util.Iterator;

public class DAMLClassImpl
extends DAMLCommonImpl
implements DAMLClass {
    private PropertyAccessor m_propSubClassOf = new PropertyAccessorImpl(RDFS.subClassOf, this);
    private PropertyAccessor m_propDisjointWith = null;
    private PropertyAccessor m_propDisjointUnionOf = null;
    private PropertyAccessor m_propSameClassAs = null;
    private PropertyAccessor m_propOneOf = null;
    private PropertyAccessor m_propUnionOf = null;
    private PropertyAccessor m_propIntersectionOf = null;
    private PropertyAccessor m_propComplementOf = null;

    public DAMLClassImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
        this.setRDFType(RDFS.Class);
    }

    public DAMLClassImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
        this.setRDFType(RDFS.Class);
    }

    public PropertyAccessor prop_subClassOf() {
        return this.m_propSubClassOf;
    }

    public PropertyAccessor prop_disjointWith() {
        if (this.m_propDisjointWith == null) {
            this.m_propDisjointWith = new PropertyAccessorImpl(this.getVocabulary().disjointWith(), this);
        }
        return this.m_propDisjointWith;
    }

    public PropertyAccessor prop_disjointUnionOf() {
        if (this.m_propDisjointUnionOf == null) {
            this.m_propDisjointUnionOf = new PropertyAccessorImpl(this.getVocabulary().disjointUnionOf(), this);
        }
        return this.m_propDisjointUnionOf;
    }

    public PropertyAccessor prop_sameClassAs() {
        if (this.m_propSameClassAs == null) {
            this.m_propSameClassAs = new PropertyAccessorImpl(this.getVocabulary().sameClassAs(), this);
        }
        return this.m_propSameClassAs;
    }

    public PropertyAccessor prop_unionOf() {
        if (this.m_propUnionOf == null) {
            this.m_propUnionOf = new PropertyAccessorImpl(this.getVocabulary().unionOf(), this);
        }
        return this.m_propUnionOf;
    }

    public PropertyAccessor prop_intersectionOf() {
        if (this.m_propIntersectionOf == null) {
            this.m_propIntersectionOf = new PropertyAccessorImpl(this.getVocabulary().intersectionOf(), this);
        }
        return this.m_propIntersectionOf;
    }

    public PropertyAccessor prop_complementOf() {
        if (this.m_propComplementOf == null) {
            this.m_propComplementOf = new PropertyAccessorImpl(this.getVocabulary().complementOf(), this);
        }
        return this.m_propComplementOf;
    }

    public PropertyAccessor prop_oneOf() {
        if (this.m_propOneOf == null) {
            this.m_propOneOf = new PropertyAccessorImpl(this.getVocabulary().oneOf(), this);
        }
        return this.m_propOneOf;
    }

    public boolean isEnumeration() {
        try {
            return this.hasProperty(this.getVocabulary().oneOf());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }

    public boolean isNamedClass() {
        return !this.isAnon();
    }

    public boolean isRestriction() {
        return false;
    }

    public boolean isIntersection() {
        try {
            return this.hasProperty(this.getVocabulary().intersectionOf());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }

    public boolean isUnion() {
        try {
            return this.hasProperty(this.getVocabulary().unionOf());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }

    public boolean isDisjointUnion() {
        try {
            return this.hasProperty(this.getVocabulary().disjointUnionOf());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }

    public boolean isComplement() {
        try {
            return this.hasProperty(this.getVocabulary().complementOf());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }

    public Iterator getSubClasses() {
        return this.getSubClasses(true);
    }

    public Iterator getSubClasses(boolean bl) {
        return new PropertyIterator(this, null, this.getVocabulary().subClassOf(), bl, false);
    }

    public Iterator getSuperClasses() {
        return this.getSuperClasses(true);
    }

    public Iterator getSuperClasses(boolean bl) {
        PropertyIterator propertyIterator = new PropertyIterator(this, this.getVocabulary().subClassOf(), null, bl, false);
        if (bl) {
            propertyIterator.setDefaultValue(this.getVocabulary().Thing());
        }
        return propertyIterator;
    }

    Object getKey() {
        return DAML_OIL.Class.getURI();
    }

    public Iterator getSameClasses() {
        return new PropertyIterator(this, this.getVocabulary().sameClassAs(), this.getVocabulary().sameClassAs(), true, true);
    }

    public Iterator getEquivalentValues() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(super.getEquivalentValues(), new PropertyIterator(this, this.getVocabulary().sameClassAs(), this.getVocabulary().sameClassAs(), true, false, false));
        concatenatedIterator.setDefaultValue(this);
        return concatenatedIterator;
    }

    public boolean hasSubClass(DAMLClass dAMLClass) {
        Iterator iterator = this.getSubClasses();
        while (iterator.hasNext()) {
            if (!((DAMLClass)iterator.next()).equals(dAMLClass)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSuperClass(DAMLClass dAMLClass) {
        Iterator iterator = this.getSuperClasses();
        while (iterator.hasNext()) {
            if (!((DAMLClass)iterator.next()).equals(dAMLClass)) continue;
            return true;
        }
        return false;
    }

    public Iterator getInstances() {
        return new PropertyIterator(new ConcatenatedIterator(this.getSelfIterator(), this.getSubClasses()), null, RDF.type, false, false, true);
    }

    public Iterator getDefinedProperties() {
        return this.getDefinedProperties(true);
    }

    public Iterator getDefinedProperties(boolean bl) {
        Iterator iterator = bl ? new ConcatenatedIterator(this.getSelfIterator(), this.getSuperClasses(true)) : this.getSelfIterator();
        return new PropertyIterator(iterator, null, this.getVocabulary().domain(), false, false, true);
    }
}

