/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullElementPointer
extends PropertyOwnerPointer {
    public NullElementPointer(NodePointer parent, int index) {
        super(parent);
        this.index = index;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getNodeValue() {
        return null;
    }

    public PropertyPointer getPropertyPointer() {
        return new NullPropertyPointer(this);
    }

    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, this.getName());
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (!(this.parent instanceof PropertyPointer)) {
            throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property");
        }
        this.parent.setValue(value);
    }

    public boolean isActual() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.parent instanceof PropertyPointer) {
            return this.parent.getParent().createChild(context, this.parent.getName(), this.index, value);
        }
        return this.parent.createChild(context, null, this.index, value);
    }

    public NodePointer createPath(JXPathContext context) {
        if (this.parent instanceof PropertyPointer) {
            return this.parent.getParent().createChild(context, this.parent.getName(), this.index);
        }
        return this.parent.createChild(context, null, this.index);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        if (index != 0 && index != NodePointer.WHOLE_COLLECTION) {
            throw new JXPathException("Internal error. Indexed passed to NullElementPointer.createChild() is not 0: " + index);
        }
        if (this.parent instanceof PropertyPointer) {
            return this.parent.getParent().createChild(context, this.parent.getName(), this.getIndex(), value);
        }
        return this.parent.createChild(context, name, this.getIndex(), value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        if (index != 0 && index != NodePointer.WHOLE_COLLECTION) {
            throw new JXPathException("Internal error. Indexed passed to NullElementPointer.createChild() is not 0: " + index);
        }
        if (this.parent instanceof PropertyPointer) {
            return this.parent.getParent().createChild(context, this.parent.getName(), this.getIndex());
        }
        return this.parent.createChild(context, name, this.getIndex());
    }

    public int hashCode() {
        return this.getParent().hashCode() + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullElementPointer)) {
            return false;
        }
        NullElementPointer other = (NullElementPointer)object;
        return this.getParent() == other.getParent() && this.index == other.index;
    }

    public String asPath() {
        return this.parent.asPath() + "[" + (this.index + 1) + "]";
    }

    public int getLength() {
        return 0;
    }
}

