/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml.xpath;

import java.util.HashMap;
import java.util.List;
import org.apache.avalon.excalibur.xml.xpath.EmptyNodeList;
import org.apache.avalon.excalibur.xml.xpath.SimpleNodeList;
import org.apache.avalon.excalibur.xml.xpath.XPathProcessor;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.jaxen.NamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JaxenProcessorImpl
extends AbstractLogEnabled
implements XPathProcessor,
Configurable,
Component,
ThreadSafe,
NamespaceContext {
    private final HashMap m_mappings = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration namespaceMappings = configuration.getChild("namespace-mappings", true);
        Configuration[] namespaces = namespaceMappings.getChildren("namespace");
        int i = 0;
        while (i < namespaces.length) {
            String prefix = namespaces[i].getAttribute("prefix");
            String uri = namespaces[i].getAttribute("uri");
            this.m_mappings.put(prefix, uri);
            ++i;
        }
    }

    public Node selectSingleNode(Node contextNode, String str) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)this);
            return (Node)path.selectSingleNode((Object)contextNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)this);
            List list = path.selectNodes((Object)contextNode);
            return new SimpleNodeList(list);
        }
        catch (Exception e) {
            return new EmptyNodeList();
        }
    }

    public boolean evaluateAsBoolean(Node contextNode, String str) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)this);
            return path.booleanValueOf((Object)contextNode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)this);
            return path.numberValueOf((Object)contextNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)this);
            return path.stringValueOf((Object)contextNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String translateNamespacePrefixToUri(String prefix) {
        return (String)this.m_mappings.get(prefix);
    }
}

