/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.xml.EntityResolver;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public final class JaxpParser
extends AbstractLogEnabled
implements Parser,
ErrorHandler,
Serviceable,
Parameterizable,
Poolable {
    private SAXParserFactory m_factory;
    private DocumentBuilderFactory m_docFactory;
    private XMLReader m_reader;
    private DocumentBuilder m_docBuilder;
    private EntityResolver m_resolver;
    private boolean m_nsPrefixes;
    private boolean m_reuseParsers;
    private boolean m_stopOnWarning;
    private boolean m_stopOnRecoverableError;

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(EntityResolver.ROLE)) {
            this.m_resolver = (EntityResolver)manager.lookup(EntityResolver.ROLE);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JaxpParser: Using EntityResolver: " + this.m_resolver);
            }
        }
    }

    public void parameterize(Parameters params) throws ParameterException {
        boolean validate = params.getParameterAsBoolean("validate", false);
        this.m_nsPrefixes = params.getParameterAsBoolean("namespace-prefixes", false);
        this.m_reuseParsers = params.getParameterAsBoolean("reuse-parsers", true);
        this.m_stopOnWarning = params.getParameterAsBoolean("stop-on-warning", true);
        this.m_stopOnRecoverableError = params.getParameterAsBoolean("stop-on-recoverable-error", true);
        String saxParserFactoryName = params.getParameter("sax-parser-factory", "javax.xml.parsers.SAXParserFactory");
        if ("javax.xml.parsers.SAXParserFactory".equals(saxParserFactoryName)) {
            this.m_factory = SAXParserFactory.newInstance();
        } else {
            try {
                Class factoryClass = this.loadClass(saxParserFactoryName);
                this.m_factory = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Cannot load SAXParserFactory class " + saxParserFactoryName, (Throwable)e);
            }
        }
        this.m_factory.setNamespaceAware(true);
        this.m_factory.setValidating(validate);
        String documentBuilderFactoryName = params.getParameter("document-builder-factory", "javax.xml.parsers.DocumentBuilderFactory");
        if ("javax.xml.parsers.DocumentBuilderFactory".equals(documentBuilderFactoryName)) {
            this.m_docFactory = DocumentBuilderFactory.newInstance();
        } else {
            try {
                Class factoryClass = this.loadClass(documentBuilderFactoryName);
                this.m_docFactory = (DocumentBuilderFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Cannot load DocumentBuilderFactory class " + documentBuilderFactoryName, (Throwable)e);
            }
        }
        this.m_docFactory.setNamespaceAware(true);
        this.m_docFactory.setValidating(validate);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JaxpParser: validating: " + validate + ", namespace-prefixes: " + this.m_nsPrefixes + ", reuse parser: " + this.m_reuseParsers + ", stop on warning: " + this.m_stopOnWarning + ", stop on recoverable-error: " + this.m_stopOnRecoverableError + ", saxParserFactory: " + saxParserFactoryName + ", documentBuilderFactory: " + documentBuilderFactoryName);
        }
    }

    private Class loadClass(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader.loadClass(name);
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        if (consumer instanceof LexicalHandler) {
            this.parse(in, consumer, (LexicalHandler)((Object)consumer));
        } else {
            this.parse(in, consumer, null);
        }
    }

    public void parse(InputSource in, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException {
        this.setupXMLReader();
        XMLReader tmpReader = this.m_reader;
        this.m_reader = null;
        try {
            if (null != lexicalHandler) {
                tmpReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
        }
        catch (SAXException e) {
            String message = "SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'";
            this.getLogger().warn("SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'");
        }
        tmpReader.setErrorHandler(this);
        tmpReader.setContentHandler(contentHandler);
        if (null != this.m_resolver) {
            tmpReader.setEntityResolver(this.m_resolver);
        }
        tmpReader.parse(in);
        if (this.m_reuseParsers) {
            this.m_reader = tmpReader;
        }
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        this.setupDocumentBuilder();
        DocumentBuilder tmpBuilder = this.m_docBuilder;
        this.m_docBuilder = null;
        if (null != this.m_resolver) {
            tmpBuilder.setEntityResolver(this.m_resolver);
        }
        Document result = tmpBuilder.parse(input);
        if (this.m_reuseParsers) {
            this.m_docBuilder = tmpBuilder;
        }
        return result;
    }

    private void setupXMLReader() throws SAXException {
        if (null == this.m_reader) {
            try {
                this.m_reader = this.m_factory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException pce) {
                String message = "Cannot produce a valid parser";
                throw new SAXException("Cannot produce a valid parser", pce);
            }
            if (this.m_nsPrefixes) {
                try {
                    this.m_reader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.m_nsPrefixes);
                }
                catch (SAXException se) {
                    String message = "SAX2 XMLReader does not support setting feature: 'http://xml.org/sax/features/namespace-prefixes'";
                    this.getLogger().warn("SAX2 XMLReader does not support setting feature: 'http://xml.org/sax/features/namespace-prefixes'");
                }
            }
        }
    }

    private void setupDocumentBuilder() throws SAXException {
        if (null == this.m_docBuilder) {
            try {
                this.m_docBuilder = this.m_docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                String message = "Could not create DocumentBuilder";
                throw new SAXException("Could not create DocumentBuilder", pce);
            }
        }
    }

    public Document createDocument() throws SAXException {
        this.setupDocumentBuilder();
        return this.m_docBuilder.newDocument();
    }

    public void error(SAXParseException spe) throws SAXException {
        String message = "Error parsing " + spe.getSystemId() + " (line " + spe.getLineNumber() + " col. " + spe.getColumnNumber() + "): " + spe.getMessage();
        if (this.m_stopOnRecoverableError) {
            throw new SAXException(message, spe);
        }
        this.getLogger().error(message, (Throwable)spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        String message = "Fatal error parsing " + spe.getSystemId() + " (line " + spe.getLineNumber() + " col. " + spe.getColumnNumber() + "): " + spe.getMessage();
        throw new SAXException(message, spe);
    }

    public void warning(SAXParseException spe) throws SAXException {
        String message = "Warning parsing " + spe.getSystemId() + " (line " + spe.getLineNumber() + " col. " + spe.getColumnNumber() + "): " + spe.getMessage();
        if (this.m_stopOnWarning) {
            throw new SAXException(message, spe);
        }
        this.getLogger().warn(message, (Throwable)spe);
    }
}

