/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String TYPE_SUFFIX = ".type";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
        this.buttonGroup = null;
    }

    public JMenuBar createJMenuBar(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar jMenuBar = new JMenuBar();
        List list = this.getStringList(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jMenuBar.add(this.createJMenuComponent((String)iterator.next()));
        }
        return jMenuBar;
    }

    protected JComponent createJMenuComponent(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (string.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String string2 = this.getString(string + TYPE_SUFFIX);
        JMenuItem jMenuItem = null;
        if (string2.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (string2.equals(TYPE_MENU)) {
            jMenuItem = this.createJMenu(string);
        } else if (string2.equals(TYPE_ITEM)) {
            jMenuItem = this.createJMenuItem(string);
        } else if (string2.equals(TYPE_RADIO)) {
            jMenuItem = this.createJRadioButtonMenuItem(string);
            this.buttonGroup.add(jMenuItem);
        } else if (string2.equals(TYPE_CHECK)) {
            jMenuItem = this.createJCheckBoxMenuItem(string);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), string + TYPE_SUFFIX);
        }
        return jMenuItem;
    }

    public JMenu createJMenu(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu jMenu = new JMenu(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jMenu, string);
        List list = this.getStringList(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jMenu.add(this.createJMenuComponent((String)iterator.next()));
        }
        return jMenu;
    }

    public JMenuItem createJMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem jMenuItem = new JMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jMenuItem, string);
        return jMenuItem;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jRadioButtonMenuItem, string);
        try {
            jRadioButtonMenuItem.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jRadioButtonMenuItem;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jCheckBoxMenuItem, string);
        try {
            jCheckBoxMenuItem.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCheckBoxMenuItem;
    }

    protected void initializeJMenuItem(JMenuItem jMenuItem, String string) throws ResourceFormatException, MissingListenerException {
        Object object;
        block15: {
            Serializable serializable;
            try {
                object = this.getString(string + ICON_SUFFIX);
                serializable = this.actions.getClass().getResource((String)object);
                if (serializable != null) {
                    jMenuItem.setIcon(new ImageIcon((URL)serializable));
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getString(string + MNEMONIC_SUFFIX);
                if (((String)object).length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), string + MNEMONIC_SUFFIX);
                }
                jMenuItem.setMnemonic(((String)object).charAt(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                if (jMenuItem instanceof JMenu) break block15;
                object = this.getString(string + ACCELERATOR_SUFFIX);
                serializable = this.toKeyStroke((String)object);
                if (serializable != null) {
                    jMenuItem.setAccelerator((KeyStroke)serializable);
                    break block15;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), string + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            object = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
            if (object == null) {
                throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
            }
            jMenuItem.addActionListener((ActionListener)object);
            if (object instanceof JComponentModifier) {
                ((JComponentModifier)object).addJComponent(jMenuItem);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            jMenuItem.setEnabled(this.getBoolean(string + ENABLED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected KeyStroke toKeyStroke(String string) {
        char c;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block31: for (n = 0; n2 != 100 && n < string.length(); ++n) {
            c = Character.toUpperCase(string.charAt(n));
            switch (n2) {
                case 0: {
                    n3 = c;
                    switch (c) {
                        case 'C': {
                            n2 = 1;
                            continue block31;
                        }
                        case 'A': {
                            n2 = 5;
                            continue block31;
                        }
                        case 'M': {
                            n2 = 8;
                            continue block31;
                        }
                        case 'S': {
                            n2 = 12;
                            continue block31;
                        }
                    }
                    n2 = 100;
                    continue block31;
                }
                case 1: {
                    n2 = c == 'T' ? 2 : 100;
                    continue block31;
                }
                case 2: {
                    n2 = c == 'R' ? 3 : 100;
                    continue block31;
                }
                case 3: {
                    n2 = c == 'L' ? 4 : 100;
                    continue block31;
                }
                case 4: {
                    int n5 = n2 = c == '+' ? 0 : 100;
                    if (n2 != 0) continue block31;
                    n4 |= 2;
                    continue block31;
                }
                case 5: {
                    n2 = c == 'L' ? 6 : 100;
                    continue block31;
                }
                case 6: {
                    n2 = c == 'T' ? 7 : 100;
                    continue block31;
                }
                case 7: {
                    int n6 = n2 = c == '+' ? 0 : 100;
                    if (n2 != 0) continue block31;
                    n4 |= 8;
                    continue block31;
                }
                case 8: {
                    n2 = c == 'E' ? 9 : 100;
                    continue block31;
                }
                case 9: {
                    n2 = c == 'T' ? 10 : 100;
                    continue block31;
                }
                case 10: {
                    n2 = c == 'A' ? 11 : 100;
                    continue block31;
                }
                case 11: {
                    int n7 = n2 = c == '+' ? 0 : 100;
                    if (n2 != 0) continue block31;
                    n4 |= 4;
                    continue block31;
                }
                case 12: {
                    n2 = c == 'H' ? 13 : 100;
                    continue block31;
                }
                case 13: {
                    n2 = c == 'I' ? 14 : 100;
                    continue block31;
                }
                case 14: {
                    n2 = c == 'F' ? 15 : 100;
                    continue block31;
                }
                case 15: {
                    n2 = c == 'T' ? 16 : 100;
                    continue block31;
                }
                case 16: {
                    int n8 = n2 = c == '+' ? 0 : 100;
                    if (n2 != 0) continue block31;
                    n4 |= 1;
                }
            }
        }
        if (n3 > 0 && n4 > 0) {
            if (n < string.length()) {
                c = Character.toUpperCase(string.charAt(n));
                switch (n3) {
                    case 85: {
                        if (string.length() - n != 1 || c != 'P') break;
                        n3 = 38;
                        break;
                    }
                    case 76: {
                        if (string.length() - n != 3 || c != 'E' || Character.toUpperCase(string.charAt(n + 1)) != 'F' || Character.toUpperCase(string.charAt(n + 2)) != 'T') break;
                        n3 = 37;
                        break;
                    }
                    case 68: {
                        if (string.length() - n != 3 || c != 'O' || Character.toUpperCase(string.charAt(n + 1)) != 'W' || Character.toUpperCase(string.charAt(n + 2)) != 'N') break;
                        n3 = 40;
                        break;
                    }
                    case 82: {
                        if (string.length() - n != 4 || c != 'I' || Character.toUpperCase(string.charAt(n + 1)) != 'G' || Character.toUpperCase(string.charAt(n + 2)) != 'H' || Character.toUpperCase(string.charAt(n + 3)) != 'T') break;
                        n3 = 39;
                    }
                }
            }
            return KeyStroke.getKeyStroke(n3, n4);
        }
        return null;
    }
}

