/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.LineInfo;

public class GlyphIterator {
    public static final AttributedCharacterIterator.Attribute PREFORMATTED = GVTAttributedCharacterIterator.TextAttribute.PREFORMATTED;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final char ZERO_WIDTH_JOINER = '\u200d';
    int idx = -1;
    int chIdx = -1;
    int lineIdx = -1;
    int aciIdx = -1;
    int charCount = -1;
    float adv = 0.0f;
    float adj = 0.0f;
    int runLimit = 0;
    int lineBreakRunLimit = 0;
    int lineBreakCount = 0;
    GVTFont font = null;
    int fontStart = 0;
    float maxAscent = 0.0f;
    float maxDescent = 0.0f;
    float maxFontSize = 0.0f;
    float width = 0.0f;
    char ch = '\u0000';
    int numGlyphs = 0;
    AttributedCharacterIterator aci;
    GVTGlyphVector gv;
    float[] gp;
    FontRenderContext frc;
    int[] leftShiftIdx = null;
    float[] leftShiftAmt = null;
    int leftShift = 0;
    Point2D gvBase = null;

    public GlyphIterator(AttributedCharacterIterator attributedCharacterIterator, GVTGlyphVector gVTGlyphVector) {
        this.aci = attributedCharacterIterator;
        this.gv = gVTGlyphVector;
        this.idx = 0;
        this.chIdx = 0;
        this.lineIdx = 0;
        this.aciIdx = attributedCharacterIterator.getBeginIndex();
        this.charCount = gVTGlyphVector.getCharacterCount(this.idx, this.idx);
        this.ch = attributedCharacterIterator.first();
        this.frc = gVTGlyphVector.getFontRenderContext();
        this.font = (GVTFont)attributedCharacterIterator.getAttribute(GVT_FONT);
        if (this.font == null) {
            this.font = new AWTGVTFont(attributedCharacterIterator.getAttributes());
        }
        this.fontStart = this.aciIdx;
        this.maxFontSize = -3.4028235E38f;
        this.maxAscent = -3.4028235E38f;
        this.maxDescent = -3.4028235E38f;
        this.runLimit = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
        this.lineBreakRunLimit = attributedCharacterIterator.getRunLimit(FLOW_LINE_BREAK);
        Object object = attributedCharacterIterator.getAttribute(FLOW_LINE_BREAK);
        this.lineBreakCount = object == null ? 0 : 1;
        this.numGlyphs = gVTGlyphVector.getNumGlyphs();
        this.gp = gVTGlyphVector.getGlyphPositions(0, this.numGlyphs + 1, null);
        this.gvBase = new Point2D.Float(this.gp[0], this.gp[1]);
        this.adv = this.getCharWidth();
        this.adj = this.getCharAdvance();
    }

    public GlyphIterator(GlyphIterator glyphIterator) {
        glyphIterator.copy(this);
    }

    public GlyphIterator copy() {
        return new GlyphIterator(this);
    }

    public GlyphIterator copy(GlyphIterator glyphIterator) {
        if (glyphIterator == null) {
            return new GlyphIterator(this);
        }
        glyphIterator.idx = this.idx;
        glyphIterator.chIdx = this.chIdx;
        glyphIterator.aciIdx = this.aciIdx;
        glyphIterator.charCount = this.charCount;
        glyphIterator.adv = this.adv;
        glyphIterator.adj = this.adj;
        glyphIterator.runLimit = this.runLimit;
        glyphIterator.ch = this.ch;
        glyphIterator.numGlyphs = this.numGlyphs;
        glyphIterator.gp = this.gp;
        glyphIterator.gvBase = this.gvBase;
        glyphIterator.lineBreakRunLimit = this.lineBreakRunLimit;
        glyphIterator.lineBreakCount = this.lineBreakCount;
        glyphIterator.frc = this.frc;
        glyphIterator.font = this.font;
        glyphIterator.fontStart = this.fontStart;
        glyphIterator.maxAscent = this.maxAscent;
        glyphIterator.maxDescent = this.maxDescent;
        glyphIterator.maxFontSize = this.maxFontSize;
        glyphIterator.leftShift = this.leftShift;
        glyphIterator.leftShiftIdx = this.leftShiftIdx;
        glyphIterator.leftShiftAmt = this.leftShiftAmt;
        return glyphIterator;
    }

    public int getGlyphIndex() {
        return this.idx;
    }

    public char getChar() {
        return this.ch;
    }

    public int getACIIndex() {
        return this.aciIdx;
    }

    public float getAdv() {
        return this.adv;
    }

    public Point2D getOrigin() {
        return this.gvBase;
    }

    public float getAdj() {
        return this.adj;
    }

    public float getMaxFontSize() {
        if (this.aciIdx >= this.fontStart) {
            int n = this.aciIdx + this.charCount;
            this.updateLineMetrics(n);
            this.fontStart = n;
        }
        return this.maxFontSize;
    }

    public float getMaxAscent() {
        if (this.aciIdx >= this.fontStart) {
            int n = this.aciIdx + this.charCount;
            this.updateLineMetrics(n);
            this.fontStart = n;
        }
        return this.maxAscent;
    }

    public float getMaxDescent() {
        if (this.aciIdx >= this.fontStart) {
            int n = this.aciIdx + this.charCount;
            this.updateLineMetrics(n);
            this.fontStart = n;
        }
        return this.maxDescent;
    }

    public boolean isLastChar() {
        return this.idx == this.numGlyphs - 1;
    }

    public boolean done() {
        return this.idx >= this.numGlyphs;
    }

    public boolean isBreakChar() {
        switch (this.ch) {
            case '\u200b': {
                return true;
            }
            case '\u200d': {
                return false;
            }
            case '\u00ad': {
                return true;
            }
            case '\t': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected boolean isPrinting(char c) {
        switch (this.ch) {
            case '\u200b': {
                return false;
            }
            case '\u200d': {
                return false;
            }
            case '\u00ad': {
                return true;
            }
            case '\t': 
            case ' ': {
                return false;
            }
        }
        return true;
    }

    public int getLineBreaks() {
        int n = 0;
        if (this.aciIdx + this.charCount >= this.lineBreakRunLimit) {
            n = this.lineBreakCount;
            this.aci.setIndex(this.aciIdx + this.charCount);
            this.lineBreakRunLimit = this.aci.getRunLimit(FLOW_LINE_BREAK);
            this.aci.setIndex(this.aciIdx);
            Object object = this.aci.getAttribute(FLOW_LINE_BREAK);
            this.lineBreakCount = object == null ? 0 : 1;
        }
        return n;
    }

    public void nextChar() {
        float f;
        if (this.ch == '\u00ad' || this.ch == '\u200b' || this.ch == '\u200d') {
            this.gv.setGlyphVisible(this.idx, false);
            f = this.getCharAdvance();
            this.adj -= f;
            this.addLeftShift(this.idx, f);
        }
        this.aciIdx += this.charCount;
        this.ch = this.aci.setIndex(this.aciIdx);
        ++this.idx;
        this.charCount = this.gv.getCharacterCount(this.idx, this.idx);
        if (this.idx == this.numGlyphs) {
            return;
        }
        if (this.aciIdx >= this.runLimit) {
            this.updateLineMetrics(this.aciIdx);
            this.runLimit = this.aci.getRunLimit(TEXT_COMPOUND_DELIMITER);
            this.font = (GVTFont)this.aci.getAttribute(GVT_FONT);
            if (this.font == null) {
                this.font = new AWTGVTFont(this.aci.getAttributes());
            }
            this.fontStart = this.aciIdx;
        }
        f = this.getCharAdvance();
        this.adj += f;
        if (this.isPrinting()) {
            this.chIdx = this.idx;
            float f2 = this.getCharWidth();
            this.adv = this.adj - (f - f2);
        }
    }

    protected void addLeftShift(int n, float f) {
        if (this.leftShiftIdx == null) {
            this.leftShiftIdx = new int[1];
            this.leftShiftIdx[0] = n;
            this.leftShiftAmt = new float[1];
            this.leftShiftAmt[0] = f;
        } else {
            int[] nArray = new int[this.leftShiftIdx.length + 1];
            for (int i = 0; i < this.leftShiftIdx.length; ++i) {
                nArray[i] = this.leftShiftIdx[i];
            }
            nArray[this.leftShiftIdx.length] = n;
            this.leftShiftIdx = nArray;
            float[] fArray = new float[this.leftShiftAmt.length + 1];
            for (int i = 0; i < this.leftShiftAmt.length; ++i) {
                fArray[i] = this.leftShiftAmt[i];
            }
            fArray[this.leftShiftAmt.length] = f;
            this.leftShiftAmt = fArray;
        }
    }

    protected void updateLineMetrics(int n) {
        GVTLineMetrics gVTLineMetrics = this.font.getLineMetrics(this.aci, this.fontStart, n, this.frc);
        float f = gVTLineMetrics.getAscent();
        float f2 = gVTLineMetrics.getDescent();
        float f3 = this.font.getSize();
        if (f > this.maxAscent) {
            this.maxAscent = f;
        }
        if (f2 > this.maxDescent) {
            this.maxDescent = f2;
        }
        if (f3 > this.maxFontSize) {
            this.maxFontSize = f3;
        }
    }

    public LineInfo newLine(Point2D.Float float_, float f, boolean bl, Point2D.Float float_2) {
        int n;
        float f2;
        if (this.ch == '\u00ad') {
            this.gv.setGlyphVisible(this.idx, true);
        }
        int n2 = 0;
        int n3 = this.leftShiftIdx != null ? this.leftShiftIdx[n2] : this.idx + 1;
        for (int i = this.lineIdx; i <= this.idx; ++i) {
            if (i == n3) {
                this.leftShift = (int)((float)this.leftShift + this.leftShiftAmt[n2++]);
                if (n2 < this.leftShiftIdx.length) {
                    n3 = this.leftShiftIdx[n2];
                }
            }
            this.gv.setGlyphPosition(i, new Point2D.Float(this.gp[2 * i] - (float)this.leftShift, this.gp[2 * i + 1]));
        }
        this.leftShiftIdx = null;
        this.leftShiftAmt = null;
        if (this.chIdx != 0 || this.isPrinting()) {
            f2 = this.getCharWidth(this.chIdx);
            n = this.chIdx + 1;
        } else {
            f2 = 0.0f;
            n = 0;
        }
        int n4 = this.idx + 1;
        float f3 = this.adv;
        float f4 = this.adj;
        while (!this.done()) {
            this.adv = 0.0f;
            this.adj = 0.0f;
            if (this.ch == '\u200b' || this.ch == '\u200d') {
                this.gv.setGlyphVisible(this.idx, false);
            }
            this.ch = '\u0000';
            this.nextChar();
            if (this.isPrinting()) break;
            n4 = this.idx + 1;
            f4 += this.adj;
        }
        for (int i = n; i < n4; ++i) {
            this.gv.setGlyphVisible(i, false);
        }
        this.maxAscent = -3.4028235E38f;
        this.maxDescent = -3.4028235E38f;
        this.maxFontSize = -3.4028235E38f;
        LineInfo lineInfo = new LineInfo(float_, this.aci, this.gv, this.lineIdx, n4, f4, f3, f2, f, bl, float_2);
        this.lineIdx = this.idx;
        return lineInfo;
    }

    public boolean isPrinting() {
        if (this.aci.getAttribute(PREFORMATTED) == Boolean.TRUE) {
            return true;
        }
        return this.isPrinting(this.ch);
    }

    public float getCharAdvance() {
        return this.getCharAdvance(this.idx);
    }

    public float getCharWidth() {
        return this.getCharWidth(this.idx);
    }

    protected float getCharAdvance(int n) {
        return this.gp[2 * n + 2] - this.gp[2 * n];
    }

    protected float getCharWidth(int n) {
        Rectangle2D rectangle2D = this.gv.getGlyphVisualBounds(n).getBounds2D();
        Point2D point2D = this.gv.getGlyphPosition(n);
        return (float)(rectangle2D.getX() + rectangle2D.getWidth() - point2D.getX());
    }
}

