/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class HttpConnectionManager {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HttpConnectionManager");
    private HashMap mapHosts = new HashMap();
    private HashMap mapNumConnections = new HashMap();
    private int maxConnections = 2;
    private String proxyHost = null;
    private int proxyPort = -1;

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setMaxConnectionsPerHost(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnections;
    }

    public HttpConnection getConnection(String sURL) throws HttpException, MalformedURLException {
        return this.getConnection(sURL, 0L);
    }

    public HttpConnection getConnection(String sURL, long timeout) throws HttpException, MalformedURLException {
        HttpConnection conn = null;
        if (sURL == null) {
            throw new MalformedURLException("sURL = null");
        }
        URL url = null;
        try {
            url = new URL(sURL);
        }
        catch (MalformedURLException e) {
            log.error("HttpConnectionManager.getConnection:  Invalid url '" + sURL + "'.  Exception = " + e.toString());
            throw e;
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        boolean isSecure = protocol.equalsIgnoreCase("HTTPS");
        if (port == -1) {
            port = isSecure ? 443 : 80;
        }
        String key = host + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug("HttpConnectionManager.getConnection:  key = " + key);
        }
        LinkedList listConnections = null;
        HashMap hashMap = this.mapHosts;
        synchronized (hashMap) {
            listConnections = (LinkedList)this.mapHosts.get(key);
            if (listConnections == null) {
                listConnections = new LinkedList();
                this.mapHosts.put(key, listConnections);
                this.mapNumConnections.put(key, new Integer(0));
            }
        }
        LinkedList linkedList = listConnections;
        synchronized (linkedList) {
            if (listConnections.size() > 0) {
                conn = (HttpConnection)listConnections.removeFirst();
            } else {
                Integer numConnections = (Integer)this.mapNumConnections.get(key);
                if (numConnections == null) {
                    log.error("HttpConnectionManager.getConnection:  No connection count for " + key);
                    numConnections = new Integer(0);
                    this.mapNumConnections.put(key, numConnections);
                }
                if (numConnections < this.maxConnections) {
                    if (log.isDebugEnabled()) {
                        log.debug("HttpConnectionManager.getConnection:  creating connection for " + host + ":" + port + " via " + this.proxyHost + ":" + this.proxyPort);
                    }
                    conn = new HttpConnection(this.proxyHost, this.proxyPort, host, port, isSecure);
                    numConnections = new Integer(numConnections + 1);
                    this.mapNumConnections.put(key, numConnections);
                } else {
                    TimeoutThread threadTimeout = new TimeoutThread();
                    threadTimeout.setTimeout(timeout);
                    threadTimeout.setWakeupThread(Thread.currentThread());
                    threadTimeout.start();
                    while (conn == null) {
                        try {
                            log.debug("HttpConnectionManager.getConnection:  waiting for connection for " + host + ":" + port);
                            listConnections.wait();
                        }
                        catch (InterruptedException e) {
                            throw new HttpException("Timeout waiting for connection.");
                        }
                        if (listConnections.size() <= 0) continue;
                        conn = (HttpConnection)listConnections.removeFirst();
                        threadTimeout.interrupt();
                    }
                }
            }
        }
        return conn;
    }

    public void releaseConnection(HttpConnection conn) {
        String host = conn.getHost();
        int port = conn.getPort();
        String key = host + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug("HttpConnectionManager.releaseConnection:  Release connection for " + host + ":" + port);
        }
        LinkedList<HttpConnection> listConnections = null;
        HashMap hashMap = this.mapHosts;
        synchronized (hashMap) {
            listConnections = (LinkedList<HttpConnection>)this.mapHosts.get(key);
            if (listConnections == null) {
                log.error("HttpConnectionManager.releaseConnection:  No connect list for " + key);
                listConnections = new LinkedList<HttpConnection>();
                this.mapHosts.put(key, listConnections);
                this.mapNumConnections.put(key, new Integer(1));
            }
        }
        LinkedList<HttpConnection> linkedList = listConnections;
        synchronized (linkedList) {
            listConnections.addFirst(conn);
            listConnections.notify();
        }
    }

    private class TimeoutThread
    extends Thread {
        private long timeout = 0L;
        private Thread thrdWakeup = null;

        private TimeoutThread() {
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setWakeupThread(Thread thrdWakeup) {
            this.thrdWakeup = thrdWakeup;
        }

        public Thread getWakeupThread() {
            return this.thrdWakeup;
        }

        public void run() {
            if (this.timeout == 0L) {
                return;
            }
            if (this.thrdWakeup == null) {
                return;
            }
            try {
                Thread.sleep(this.timeout);
                this.thrdWakeup.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

