/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class HeaderElement
extends NameValuePair {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HeaderElement");
    private static final BitSet SEPARATORS = new BitSet(128);
    private static final BitSet TOKEN_CHAR = new BitSet(128);
    private static final BitSet UNSAFE_CHAR = new BitSet(128);
    protected NameValuePair[] parameters = null;

    public HeaderElement() {
        this(null, null, null);
    }

    public HeaderElement(String name, String value) {
        this(name, value, null);
    }

    public HeaderElement(String name, String value, NameValuePair[] parameters) {
        super(name, value);
        this.parameters = parameters;
    }

    public NameValuePair[] getParameters() {
        return this.parameters;
    }

    public static final HeaderElement[] parse(String headerValue) throws HttpException {
        if (headerValue == null) {
            return null;
        }
        Vector<HeaderElement> elements = new Vector<HeaderElement>();
        StringTokenizer tokenizer = new StringTokenizer(headerValue.trim(), ",");
        while (tokenizer.countTokens() > 0) {
            String nextToken = tokenizer.nextToken();
            try {
                while (HeaderElement.hasOddNumberOfQuotationMarks(nextToken)) {
                    nextToken = nextToken + "," + tokenizer.nextToken();
                }
            }
            catch (NoSuchElementException exception) {
                throw new HttpException("Bad header format: wrong number of quotation marks");
            }
            try {
                if (tokenizer.hasMoreTokens() && (nextToken.endsWith("Mon") || nextToken.endsWith("Tue") || nextToken.endsWith("Wed") || nextToken.endsWith("Thu") || nextToken.endsWith("Fri") || nextToken.endsWith("Sat") || nextToken.endsWith("Sun") || nextToken.endsWith("Monday") || nextToken.endsWith("Tuesday") || nextToken.endsWith("Wednesday") || nextToken.endsWith("Thursday") || nextToken.endsWith("Friday") || nextToken.endsWith("Saturday") || nextToken.endsWith("Sunday"))) {
                    nextToken = nextToken + tokenizer.nextToken(",");
                }
            }
            catch (NoSuchElementException exception) {
                throw new HttpException("Bad header format: parsing with wrong header elements");
            }
            String tmp = nextToken.trim();
            if (!tmp.endsWith(";")) {
                tmp = tmp + ";";
            }
            char[] header = tmp.toCharArray();
            boolean inAString = false;
            int startPos = 0;
            HeaderElement element = new HeaderElement();
            Vector<NameValuePair> paramlist = new Vector<NameValuePair>();
            int i = 0;
            while (i < header.length) {
                if (header[i] == ';' && !inAString) {
                    NameValuePair pair = HeaderElement.parsePair(header, startPos, i);
                    if (pair == null) {
                        throw new HttpException("Bad header format: empty name/value pair in" + nextToken);
                    }
                    if (startPos == 0) {
                        element.setName(pair.getName());
                        element.setValue(pair.getValue());
                    } else {
                        paramlist.addElement(pair);
                    }
                    startPos = i + 1;
                } else if (!(header[i] != '\"' || inAString && i > 0 && header[i - 1] == '\\')) {
                    inAString = !inAString;
                }
                ++i;
            }
            if (paramlist.size() > 0) {
                Object[] tmp2 = new NameValuePair[paramlist.size()];
                paramlist.copyInto(tmp2);
                element.parameters = tmp2;
                paramlist.removeAllElements();
            }
            elements.addElement(element);
        }
        Object[] headerElements = new HeaderElement[elements.size()];
        elements.copyInto(headerElements);
        return headerElements;
    }

    private static final boolean hasOddNumberOfQuotationMarks(String string) {
        boolean odd = false;
        int start = -1;
        while ((start = string.indexOf(34, start + 1)) != -1) {
            boolean bl = odd = !odd;
        }
        return odd;
    }

    private static final NameValuePair parsePair(char[] header, int start, int end) throws HttpException {
        boolean done = false;
        NameValuePair pair = null;
        String name = new String(header, start, end - start).trim();
        String value = null;
        int index = name.indexOf("=");
        if (index >= 0) {
            if (index + 1 < name.length() && (value = name.substring(index + 1).trim()).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            name = name.substring(0, index).trim();
        }
        pair = new NameValuePair(name, value);
        return pair;
    }

    static {
        SEPARATORS.set(40);
        SEPARATORS.set(41);
        SEPARATORS.set(60);
        SEPARATORS.set(62);
        SEPARATORS.set(64);
        SEPARATORS.set(44);
        SEPARATORS.set(59);
        SEPARATORS.set(58);
        SEPARATORS.set(92);
        SEPARATORS.set(34);
        SEPARATORS.set(47);
        SEPARATORS.set(91);
        SEPARATORS.set(93);
        SEPARATORS.set(63);
        SEPARATORS.set(61);
        SEPARATORS.set(123);
        SEPARATORS.set(125);
        SEPARATORS.set(32);
        SEPARATORS.set(9);
        int ch = 32;
        while (ch < 127) {
            TOKEN_CHAR.set(ch);
            ++ch;
        }
        TOKEN_CHAR.xor(SEPARATORS);
        int ch2 = 0;
        while (ch2 < 32) {
            UNSAFE_CHAR.set(ch2);
            ++ch2;
        }
        UNSAFE_CHAR.set(32);
        UNSAFE_CHAR.set(60);
        UNSAFE_CHAR.set(62);
        UNSAFE_CHAR.set(34);
        UNSAFE_CHAR.set(123);
        UNSAFE_CHAR.set(125);
        UNSAFE_CHAR.set(124);
        UNSAFE_CHAR.set(92);
        UNSAFE_CHAR.set(94);
        UNSAFE_CHAR.set(126);
        UNSAFE_CHAR.set(91);
        UNSAFE_CHAR.set(93);
        UNSAFE_CHAR.set(96);
        UNSAFE_CHAR.set(127);
    }
}

