/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.avalon.excalibur.datasource.AbstractJdbcConnection;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.datasource.NoAvailableConnectionException;
import org.apache.avalon.excalibur.pool.AbstractPool;
import org.apache.avalon.excalibur.pool.DefaultPool;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.HardResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class JdbcConnectionPool
extends HardResourceLimitingPool
implements Runnable,
Disposable,
Initializable {
    private Thread m_initThread;
    private final boolean m_autoCommit;
    private boolean m_noConnections;
    private long m_wait = -1L;
    private HashSet m_waitingThreads = new HashSet();

    public JdbcConnectionPool(JdbcConnectionFactory factory, DefaultPoolController controller, int min, int max, boolean autoCommit) throws Exception {
        super((ObjectFactory)factory, (PoolController)controller, max);
        ((DefaultPool)this).m_min = min;
        this.m_autoCommit = autoCommit;
    }

    public Poolable get() throws Exception {
        AbstractJdbcConnection obj;
        if (!((AbstractPool)this).m_initialized) {
            if (this.m_noConnections) {
                throw new IllegalStateException("There are no connections in the pool, check your settings.");
            }
            if (this.m_initThread == null) {
                throw new IllegalStateException("You cannot get a Connection before the pool is initialized.");
            }
            this.m_initThread.join();
        }
        if ((obj = (AbstractJdbcConnection)super.get()).isClosed()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JdbcConnection was closed, creating one to take its place");
            }
            try {
                try {
                    this.lock();
                    if (((AbstractPool)this).m_active.contains(obj)) {
                        ((AbstractPool)this).m_active.remove(obj);
                    }
                    this.removePoolable((Poolable)obj);
                    obj = (AbstractJdbcConnection)this.newPoolable();
                    ((AbstractPool)this).m_active.add(obj);
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not get an open connection", (Throwable)e);
                    }
                    throw e;
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
        }
        if (obj.getAutoCommit() != this.m_autoCommit) {
            obj.setAutoCommit(this.m_autoCommit);
        }
        return obj;
    }

    public void initialize() {
        this.m_initThread = new Thread(this);
        this.m_initThread.start();
    }

    protected final Poolable newPoolable() throws Exception {
        AbstractJdbcConnection conn = null;
        if (this.m_wait < 1L) {
            conn = (AbstractJdbcConnection)super.newPoolable();
        } else {
            long curMillis = System.currentTimeMillis();
            long endTime = curMillis + this.m_wait;
            while (conn == null && curMillis < endTime) {
                Thread thread = Thread.currentThread();
                this.m_waitingThreads.add(thread);
                try {
                    curMillis = System.currentTimeMillis();
                    this.unlock();
                    thread.wait(endTime - curMillis);
                }
                finally {
                    Object var8_5 = null;
                    this.lock();
                }
                conn = (AbstractJdbcConnection)super.newPoolable();
            }
        }
        if (conn == null) {
            throw new NoAvailableConnectionException("All available connections are in use");
        }
        conn.setPool((Pool)this);
        return conn;
    }

    public void put(Poolable obj) {
        super.put(obj);
        Iterator i = this.m_waitingThreads.iterator();
        while (i.hasNext()) {
            Object thread = i.next();
            thread.notify();
            i.remove();
        }
    }

    public void run() {
        block5: {
            try {
                this.grow(((DefaultPool)this).m_min);
                if (this.size() > 0) {
                    ((AbstractPool)this).m_initialized = true;
                } else {
                    this.m_noConnections = true;
                    if (this.getLogger().isFatalErrorEnabled()) {
                        this.getLogger().fatalError("Excalibur could not create any connections.  Examine your settings to make sure they are correct.  Make sure you can connect with the same settings on your machine.");
                    }
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block5;
                this.getLogger().debug("Caught an exception during initialization", (Throwable)e);
            }
        }
    }

    public void setTimeout(long timeout) {
        if (((AbstractPool)this).m_initialized) {
            throw new IllegalStateException("You cannot change the timeout after the pool is initialized");
        }
        this.m_wait = timeout;
    }
}

