/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.ProcessProfile;
import com.hp.hpl.deli.ProfileAttribute;
import com.hp.hpl.deli.VectorUnique;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Selector;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

class JenaProcessProfile
extends ProcessProfile {
    private Vector profileAttributes;
    private ModelMem jenaProfile;
    private boolean defaultFlag = false;
    private Property componentProperty;
    private Property typeProperty;
    private Workspace workspace;

    protected JenaProcessProfile(Workspace workspace) {
        this.workspace = workspace;
        this.profileAttributes = new Vector();
    }

    protected Vector process(String string) throws Exception {
        this.jenaProfile = new ModelMem();
        try {
            Reader reader = this.workspace.getResource(string);
            this.jenaProfile.read(reader, "");
        }
        catch (RDFException rDFException) {
            this.workspace.printDebug("JenaProcessProfile: Could not load profile " + string);
            throw rDFException;
        }
        return this.processModel();
    }

    protected Vector process(Vector vector) throws Exception {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.get(n);
            StringReader stringReader = new StringReader(string);
            this.jenaProfile = new ModelMem();
            try {
                this.jenaProfile.read((Reader)stringReader, "");
            }
            catch (Exception exception) {
                this.workspace.printDebug("JenaProcessProfile: Could not process profile-diff");
                throw exception;
            }
            this.processModel();
            ++n;
        }
        return this.profileAttributes;
    }

    /*
     * Unable to fully structure code
     */
    private Vector processModel() throws Exception {
        block6: {
            var1_1 = null;
            var2_2 = this.jenaProfile.listNameSpaces();
            while (var2_2.hasNext()) {
                var3_3 = var2_2.next();
                if (var3_3.equals(this.workspace.rdfUri)) continue;
                this.workspace.printDebug("Model uses " + var3_3);
                var1_1 = var3_3;
            }
            this.componentProperty = this.jenaProfile.createProperty(var1_1 + this.workspace.componentProperty);
            this.typeProperty = this.jenaProfile.createProperty(this.workspace.rdfUri + "type");
            var4_4 = this.jenaProfile.listObjectsOfProperty(this.componentProperty);
            if (var4_4.hasNext()) ** GOTO lbl31
            var5_5 = null;
            var6_7 = this.jenaProfile.listStatements().next().getObject();
            while (var5_5 == null) {
                var7_8 = this.jenaProfile.listStatements((Selector)new SelectorImpl((Resource)null, (Property)null, var6_7));
                if (var7_8.hasNext()) {
                    var6_7 = var7_8.next().getSubject();
                    continue;
                }
                var5_5 = (Resource)var6_7;
            }
            this.processAttributeList(var5_5, var1_1, null);
            break block6;
lbl-1000:
            // 1 sources

            {
                var5_6 = (Resource)var4_4.next();
                if (var5_6.hasProperty(this.typeProperty)) {
                    var3_3 = this.getID(var5_6.getProperty(this.typeProperty).getObject().toString());
                } else {
                    this.workspace.printDebug("Warning: profile omits type information");
                    var3_3 = null;
                }
                this.processAttributeList(var5_6, var1_1, var3_3);
lbl31:
                // 2 sources

                ** while (var4_4.hasNext())
            }
        }
        return this.profileAttributes;
    }

    private void processAttributeList(Resource resource, String string, String string2) throws Exception {
        Property property = this.jenaProfile.createProperty(string + "defaults");
        Property property2 = this.jenaProfile.createProperty(string + "Defaults");
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.next();
            if (statement.getPredicate().equals((Object)this.typeProperty)) continue;
            if (statement.getPredicate().equals((Object)property) || statement.getPredicate().equals((Object)property2)) {
                StmtIterator stmtIterator2 = ((Resource)statement.getObject()).listProperties();
                if (!stmtIterator2.hasNext()) {
                    String string3 = statement.getObject().toString();
                    this.workspace.printDebug("JenaProcessProfile: Retrieving profile " + string3);
                    JenaProcessProfile jenaProcessProfile = new JenaProcessProfile(this.workspace);
                    jenaProcessProfile.defaultFlag = true;
                    this.profileAttributes.addAll(jenaProcessProfile.process(string3));
                    continue;
                }
                this.defaultFlag = true;
                this.processAttributeList((Resource)statement.getObject(), string, string2);
                this.defaultFlag = false;
                continue;
            }
            this.processAttribute(statement, string, string2);
        }
    }

    private void processAttribute(Statement statement, String string, String string2) throws Exception {
        VectorUnique vectorUnique = new VectorUnique();
        String string3 = this.getID(statement.getPredicate().toString());
        int n = this.workspace.vocabulary.getAttributeRef(string + string3);
        if (n == -1) {
            this.workspace.printDebug("JenaProfile: Attribute is not in current vocabulary " + string3);
        } else {
            ProfileAttribute profileAttribute;
            if (statement.getObject() instanceof Literal) {
                vectorUnique.add(new String(statement.getObject().toString()));
            } else {
                NodeIterator nodeIterator;
                Seq seq;
                profileAttribute = this.jenaProfile.listStatements((Selector)new SelectorImpl((Resource)statement.getObject(), this.typeProperty, (RDFNode)this.jenaProfile.createResource(this.workspace.rdfUri + "Seq")));
                if (profileAttribute.hasNext()) {
                    seq = this.jenaProfile.getSeq((Resource)statement.getObject());
                    nodeIterator = seq.iterator();
                    while (nodeIterator.hasNext()) {
                        vectorUnique.add(new String(nodeIterator.next().toString()));
                    }
                }
                if ((profileAttribute = this.jenaProfile.listStatements((Selector)new SelectorImpl((Resource)statement.getObject(), this.typeProperty, (RDFNode)this.jenaProfile.createResource(this.workspace.rdfUri + "Bag")))).hasNext()) {
                    seq = this.jenaProfile.getBag((Resource)statement.getObject());
                    nodeIterator = seq.iterator();
                    while (nodeIterator.hasNext()) {
                        vectorUnique.add(new String(nodeIterator.next().toString()));
                    }
                }
            }
            if (string2 != null && !string2.equals(this.workspace.vocabulary.getComponent(n))) {
                this.workspace.printDebug("Error: " + string3 + " in wrong component");
            }
            profileAttribute = this.workspace.profileAttributeFactory();
            profileAttribute.set(n, vectorUnique, this.defaultFlag);
            this.profileAttributes.add(profileAttribute);
        }
    }

    private String getID(String string) {
        return string.substring(string.lastIndexOf(35) + 1, string.length());
    }
}

