/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSSFWorkbook {
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = 3;
    private Workbook workbook;
    private ArrayList sheets;
    private static POILogger log;
    static /* synthetic */ Class class$org$apache$poi$hssf$usermodel$HSSFWorkbook;

    public HSSFWorkbook() {
        this.workbook = Workbook.createWorkbook();
        this.sheets = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem fs) throws IOException {
        this.sheets = new ArrayList(3);
        DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
        List records = RecordFactory.createRecords(stream);
        this.workbook = Workbook.createWorkbook(records);
        this.setPropertiesFromWorkbook(this.workbook);
        int numRecords = this.workbook.getNumRecords();
        int sheetnum = 0;
        while (numRecords < records.size()) {
            Sheet sheet = Sheet.createSheet(records, sheetnum, numRecords);
            numRecords += sheet.getNumRecords();
            sheet.convertLabelRecords(this.workbook);
            HSSFSheet hsheet = new HSSFSheet(this.workbook, sheet);
            this.sheets.add(hsheet);
        }
    }

    public HSSFWorkbook(InputStream s) throws IOException {
        this(new POIFSFileSystem(s));
    }

    private void setPropertiesFromWorkbook(Workbook book) {
        this.workbook = book;
    }

    public void setSheetName(int sheet, String name) {
        if (sheet > this.sheets.size() - 1) {
            throw new RuntimeException("Sheet out of bounds");
        }
        this.workbook.setSheetName(sheet, name);
    }

    public String getSheetName(int sheet) {
        if (sheet > this.sheets.size() - 1) {
            throw new RuntimeException("Sheet out of bounds");
        }
        return this.workbook.getSheetName(sheet);
    }

    public int getSheetIndex(String name) {
        int retval = -1;
        int k = 0;
        while (k < this.sheets.size()) {
            String sheet = this.workbook.getSheetName(k);
            if (sheet.equals(name)) {
                retval = k;
                break;
            }
            ++k;
        }
        return retval;
    }

    public HSSFSheet createSheet() {
        HSSFSheet sheet = new HSSFSheet(this.workbook);
        this.sheets.add(sheet);
        this.workbook.setSheetName(this.sheets.size() - 1, "Sheet" + (this.sheets.size() - 1));
        WindowTwoRecord windowTwo = (WindowTwoRecord)sheet.getSheet().findFirstRecordBySid((short)574);
        windowTwo.setSelected(this.sheets.size() == 1);
        windowTwo.setPaged(this.sheets.size() == 1);
        return sheet;
    }

    public HSSFSheet createSheet(String sheetname) {
        HSSFSheet sheet = new HSSFSheet(this.workbook);
        this.sheets.add(sheet);
        this.workbook.setSheetName(this.sheets.size() - 1, sheetname);
        WindowTwoRecord windowTwo = (WindowTwoRecord)sheet.getSheet().findFirstRecordBySid((short)574);
        windowTwo.setSelected(this.sheets.size() == 1);
        windowTwo.setPaged(this.sheets.size() == 1);
        return sheet;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public HSSFSheet getSheetAt(int index) {
        return (HSSFSheet)this.sheets.get(index);
    }

    public HSSFSheet getSheet(String name) {
        HSSFSheet retval = null;
        int k = 0;
        while (k < this.sheets.size()) {
            String sheetname = this.workbook.getSheetName(k);
            if (sheetname.equals(name)) {
                retval = (HSSFSheet)this.sheets.get(k);
            }
            ++k;
        }
        return retval;
    }

    public void removeSheetAt(int index) {
        this.sheets.remove(index);
        this.workbook.removeSheet(index);
    }

    public void setBackupFlag(boolean backupValue) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(backupValue ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    public HSSFFont createFont() {
        FontRecord font = this.workbook.createNewFont();
        short fontindex = (short)(this.getNumberOfFonts() - 1);
        if (fontindex > 3) {
            fontindex = (short)(fontindex + 1);
        }
        HSSFFont retval = new HSSFFont(fontindex, font);
        return retval;
    }

    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    public HSSFFont getFontAt(short idx) {
        FontRecord font = this.workbook.getFontRecordAt(idx);
        HSSFFont retval = new HSSFFont(idx, font);
        return retval;
    }

    public HSSFCellStyle createCellStyle() {
        ExtendedFormatRecord xfr = this.workbook.createCellXF();
        short index = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle style = new HSSFCellStyle(index, xfr);
        return style;
    }

    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    public HSSFCellStyle getCellStyleAt(short idx) {
        ExtendedFormatRecord xfr = this.workbook.getExFormatAt(idx);
        HSSFCellStyle style = new HSSFCellStyle(idx, xfr);
        return style;
    }

    public void write(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        POIFSFileSystem fs = new POIFSFileSystem();
        fs.createDocument(new ByteArrayInputStream(bytes), "Workbook");
        fs.writeFilesystem(stream);
    }

    public byte[] getBytes() {
        int wbsize;
        log.log(1, "HSSFWorkbook.getBytes()");
        int totalsize = wbsize = this.workbook.getSize();
        int k = 0;
        while (k < this.sheets.size()) {
            this.workbook.setSheetBof(k, totalsize);
            totalsize += ((HSSFSheet)this.sheets.get(k)).getSheet().getSize();
            ++k;
        }
        if (totalsize < 4096) {
            totalsize = 4096;
        }
        byte[] retval = new byte[totalsize];
        int pos = this.workbook.serialize(0, retval);
        int k2 = 0;
        while (k2 < this.sheets.size()) {
            pos += ((HSSFSheet)this.sheets.get(k2)).getSheet().serialize(pos, retval);
            ++k2;
        }
        int k3 = pos;
        while (k3 < totalsize) {
            retval[k3] = 0;
            ++k3;
        }
        return retval;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(string);
    }

    public String getSSTString(int index) {
        return this.workbook.getSSTString(index);
    }

    Workbook getWorkbook() {
        return this.workbook;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEBUG = 1;
        INITIAL_CAPACITY = 3;
        log = POILogFactory.getLogger(class$org$apache$poi$hssf$usermodel$HSSFWorkbook == null ? (class$org$apache$poi$hssf$usermodel$HSSFWorkbook = HSSFWorkbook.class$("org.apache.poi.hssf.usermodel.HSSFWorkbook")) : class$org$apache$poi$hssf$usermodel$HSSFWorkbook);
    }
}

