/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class HSSFDateUtil {
    private static final int BAD_DATE = -1;
    private static final long DAY_MILLISECONDS = 86400000L;
    private static final double CAL_1900_ABSOLUTE;

    private HSSFDateUtil() {
    }

    public static double getExcelDate(Date date) {
        Calendar calStart = new GregorianCalendar();
        calStart.setTime(date);
        if (calStart.get(1) < 1900) {
            return -1.0;
        }
        calStart = HSSFDateUtil.dayStart(calStart);
        double fraction = (double)(date.getTime() - calStart.getTime().getTime()) / 8.64E7;
        return fraction + (double)HSSFDateUtil.absoluteDay(calStart) - CAL_1900_ABSOLUTE;
    }

    public static Date getJavaDate(double date) {
        if (HSSFDateUtil.isValidExcelDate(date)) {
            int wholeDaysSince1900 = (int)Math.floor(date);
            GregorianCalendar calendar = new GregorianCalendar(1900, 0, wholeDaysSince1900 - 1);
            int millisecondsInDay = (int)((date - Math.floor(date)) * 8.64E7 + 0.5);
            calendar.set(14, millisecondsInDay);
            return calendar.getTime();
        }
        return null;
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    private static int absoluteDay(Calendar cal) {
        return cal.get(6) + HSSFDateUtil.daysInPriorYears(cal.get(1));
    }

    private static int daysInPriorYears(int yr) {
        if (yr < 1601) {
            throw new IllegalArgumentException("'year' must be 1601 or greater");
        }
        int y = yr - 1601;
        int days = 365 * y + y / 4 - y / 100 + y / 400;
        return days;
    }

    private static Calendar dayStart(Calendar cal) {
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        return cal;
    }

    static {
        BAD_DATE = -1;
        DAY_MILLISECONDS = 86400000L;
        CAL_1900_ABSOLUTE = (double)HSSFDateUtil.absoluteDay(new GregorianCalendar(1900, 0, 1)) - 2.0;
    }
}

