/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.BinaryTree;
import org.apache.poi.util.LittleEndian;

public class SSTRecord
extends Record {
    private static final int _max = 8228;
    private static final int _std_record_overhead = 4;
    private static final int _sst_record_overhead = 12;
    private static final int _max_data_space = 8216;
    private static final int _string_minimal_overhead = 3;
    public static final short sid = 252;
    private int field_1_num_strings;
    private int field_2_num_unique_strings;
    private BinaryTree field_3_strings;
    private int __expected_chars;
    private String _unfinished_string;
    private int _total_length_bytes;
    private int _string_data_offset;
    private boolean _wide_char;
    private List _record_lengths = null;

    public SSTRecord() {
        this.field_1_num_strings = 0;
        this.field_2_num_unique_strings = 0;
        this.field_3_strings = new BinaryTree();
        this.setExpectedChars(0);
        this._unfinished_string = "";
        this._total_length_bytes = 0;
        this._string_data_offset = 0;
        this._wide_char = false;
    }

    public SSTRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SSTRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public int addString(String string) {
        int rval;
        if (string == null) {
            rval = this.addString("", false);
        } else {
            boolean useUTF16 = false;
            int strlen = string.length();
            int j = 0;
            while (j < strlen) {
                if (string.charAt(j) > '\u00ff') {
                    useUTF16 = true;
                    break;
                }
                ++j;
            }
            rval = this.addString(string, useUTF16);
        }
        return rval;
    }

    public int addString(String string, boolean useUTF16) {
        ++this.field_1_num_strings;
        String str = string == null ? "" : string;
        int rval = -1;
        UnicodeString ucs = new UnicodeString();
        ucs.setString(str);
        ucs.setCharCount((short)str.length());
        ucs.setOptionFlags((byte)(useUTF16 ? 1 : 0));
        Integer integer = (Integer)this.field_3_strings.getKeyForValue(ucs);
        if (integer != null) {
            rval = integer;
        } else {
            rval = this.field_3_strings.size();
            ++this.field_2_num_unique_strings;
            integer = new Integer(rval);
            this.field_3_strings.put(integer, ucs);
        }
        return rval;
    }

    public int getNumStrings() {
        return this.field_1_num_strings;
    }

    public int getNumUniqueStrings() {
        return this.field_2_num_unique_strings;
    }

    public void setNumStrings(int count) {
        this.field_1_num_strings = count;
    }

    public void getNumUniqueStrings(int count) {
        this.field_2_num_unique_strings = count;
    }

    public String getString(int id) {
        return ((UnicodeString)this.field_3_strings.get(new Integer(id))).getString();
    }

    public boolean getString16bit(int id) {
        return ((UnicodeString)this.field_3_strings.get(new Integer(id))).getOptionFlags() == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SST]\n");
        buffer.append("    .numstrings     = ").append(Integer.toHexString(this.getNumStrings())).append("\n");
        buffer.append("    .uniquestrings  = ").append(Integer.toHexString(this.getNumUniqueStrings())).append("\n");
        int k = 0;
        while (k < this.field_3_strings.size()) {
            buffer.append("    .string_" + k + "      = ").append(((UnicodeString)this.field_3_strings.get(new Integer(k))).toString()).append("\n");
            ++k;
        }
        buffer.append("[/SST]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int rval = this.getRecordSize();
        int record_length_index = 0;
        int unicodesize = this.calculateUnicodeSize();
        if (unicodesize > 8216) {
            byte[] stringreminant = null;
            int unipos = 0;
            boolean lastneedcontinue = false;
            int stringbyteswritten = 0;
            boolean first_record = true;
            int totalWritten = 0;
            int size = 0;
            while (totalWritten != rval) {
                int available;
                int pos = 0;
                if (first_record) {
                    size = (Integer)this._record_lengths.get(record_length_index++);
                    available = size - 8;
                    pos = this.writeSSTHeader(data, pos + offset + totalWritten, size);
                    size += 4;
                    first_record = false;
                } else {
                    pos = 0;
                    int to_be_written = unicodesize - stringbyteswritten + (lastneedcontinue ? 1 : 0);
                    available = size = ((Integer)this._record_lengths.get(record_length_index++)).intValue();
                    pos = this.writeContinueHeader(data, pos + offset + totalWritten, size);
                    size += 4;
                }
                if (lastneedcontinue) {
                    if (stringreminant.length <= available) {
                        System.arraycopy(stringreminant, 0, data, pos + offset + totalWritten, stringreminant.length);
                        stringbyteswritten += stringreminant.length - 1;
                        pos += stringreminant.length;
                        lastneedcontinue = false;
                        available -= stringreminant.length;
                    } else {
                        System.arraycopy(stringreminant, 0, data, pos + offset + totalWritten, available);
                        stringbyteswritten += available - 1;
                        pos += available;
                        byte[] leftover = new byte[stringreminant.length - available + 1];
                        System.arraycopy(stringreminant, available, leftover, 1, stringreminant.length - available);
                        leftover[0] = stringreminant[0];
                        stringreminant = leftover;
                        available = 0;
                        lastneedcontinue = true;
                    }
                }
                while (unipos < this.field_3_strings.size()) {
                    Integer intunipos = new Integer(unipos);
                    UnicodeString unistr = (UnicodeString)this.field_3_strings.get(intunipos);
                    if (unistr.getRecordSize() <= available) {
                        unistr.serialize(pos + offset + totalWritten, data);
                        int rsize = unistr.getRecordSize();
                        stringbyteswritten += rsize;
                        pos += rsize;
                        available -= rsize;
                    } else {
                        if (available < 3) break;
                        byte[] ucs = unistr.serialize();
                        System.arraycopy(ucs, 0, data, pos + offset + totalWritten, available);
                        stringbyteswritten += available;
                        stringreminant = new byte[ucs.length - available + 1];
                        System.arraycopy(ucs, available, stringreminant, 1, ucs.length - available);
                        stringreminant[0] = ucs[2];
                        available = 0;
                        lastneedcontinue = true;
                        ++unipos;
                        break;
                    }
                    ++unipos;
                }
                totalWritten += size;
            }
        } else {
            int datasize = 12 + unicodesize;
            this.writeSSTHeader(data, 0 + offset, 12 + (Integer)this._record_lengths.get(record_length_index++) - 4);
            int pos = 12;
            int k = 0;
            while (k < this.field_3_strings.size()) {
                UnicodeString unistr = (UnicodeString)this.field_3_strings.get(new Integer(k));
                System.arraycopy(unistr.serialize(), 0, data, pos + offset, unistr.getRecordSize());
                pos += unistr.getRecordSize();
                ++k;
            }
        }
        return rval;
    }

    private int calculateStringsize() {
        int retval = 0;
        int k = 0;
        while (k < this.field_3_strings.size()) {
            retval += ((UnicodeString)this.field_3_strings.get(new Integer(k))).getRecordSize();
            ++k;
        }
        return retval;
    }

    public void processContinueRecord(byte[] record) {
        if (this.getExpectedChars() == 0) {
            this._unfinished_string = "";
            this._total_length_bytes = 0;
            this._string_data_offset = 0;
            this._wide_char = false;
            this.manufactureStrings(record, 0, (short)record.length);
        } else {
            int data_length = record.length - 1;
            if (this.calculateByteCount(this.getExpectedChars()) > data_length) {
                byte[] input = new byte[record.length + 2];
                short size = (short)((record[0] & 1) == 1 ? data_length / 2 : data_length / 1);
                LittleEndian.putShort(input, 0, size);
                System.arraycopy(record, 0, input, 2, record.length);
                UnicodeString ucs = new UnicodeString(4095, (short)input.length, input);
                this._unfinished_string = this._unfinished_string + ucs.getString();
                this.setExpectedChars(this.getExpectedChars() - size);
            } else {
                this.setupStringParameters(record, -2, this.getExpectedChars());
                byte[] str_data = new byte[this._total_length_bytes];
                int length = 3 + this.calculateByteCount(this.getExpectedChars());
                byte[] bstring = new byte[length];
                System.arraycopy(record, 0, str_data, 2, str_data.length - 2);
                LittleEndian.putShort(bstring, 0, (short)this.getExpectedChars());
                bstring[2] = str_data[2];
                System.arraycopy(str_data, this._string_data_offset, bstring, 3, bstring.length - 3);
                UnicodeString string = new UnicodeString(4095, (short)bstring.length, bstring, this._unfinished_string);
                Integer integer = new Integer(this.field_3_strings.size());
                this.field_3_strings.put(integer, string);
                this.manufactureStrings(record, this._total_length_bytes - 2, (short)record.length);
            }
        }
    }

    public short getSid() {
        return 252;
    }

    public int hashCode() {
        return this.field_2_num_unique_strings;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SSTRecord other = (SSTRecord)o;
        return this.field_1_num_strings == other.field_1_num_strings && this.field_2_num_unique_strings == other.field_2_num_unique_strings && this.field_3_strings.equals(other.field_3_strings);
    }

    protected void validateSid(short id) throws RecordFormatException {
        if (id != 252) {
            throw new RecordFormatException("NOT An SST RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_num_strings = LittleEndian.getInt(data, 0 + offset);
        this.field_2_num_unique_strings = LittleEndian.getInt(data, 4 + offset);
        this.field_3_strings = new BinaryTree();
        this.setExpectedChars(0);
        this._unfinished_string = "";
        this._total_length_bytes = 0;
        this._string_data_offset = 0;
        this._wide_char = false;
        this.manufactureStrings(data, 8 + offset, size);
    }

    int getExpectedChars() {
        return this.__expected_chars;
    }

    Iterator getStrings() {
        return this.field_3_strings.values().iterator();
    }

    int countStrings() {
        return this.field_3_strings.size();
    }

    String getUnfinishedString() {
        return this._unfinished_string;
    }

    int getTotalLength() {
        return this._total_length_bytes;
    }

    int getStringDataOffset() {
        return this._string_data_offset;
    }

    boolean isWideChar() {
        return this._wide_char;
    }

    private int writeSSTHeader(byte[] data, int pos, int recsize) {
        int offset = pos;
        LittleEndian.putShort(data, offset, (short)252);
        LittleEndian.putShort(data, offset += 2, (short)recsize);
        LittleEndian.putInt(data, offset += 2, this.getNumStrings());
        LittleEndian.putInt(data, offset += 4, this.getNumUniqueStrings());
        return (offset += 4) - pos;
    }

    private int writeContinueHeader(byte[] data, int pos, int recsize) {
        int offset = pos;
        LittleEndian.putShort(data, offset, (short)60);
        LittleEndian.putShort(data, offset += 2, (short)recsize);
        return (offset += 2) - pos;
    }

    private int calculateUCArrayLength(byte[][] ucarray) {
        int retval = 0;
        int k = 0;
        while (k < ucarray.length) {
            retval += ucarray[k].length;
            ++k;
        }
        return retval;
    }

    private void manufactureStrings(byte[] data, int index, short size) {
        int offset = index;
        while (offset < size) {
            int remaining = size - offset;
            if (remaining > 0 && remaining < 2) {
                throw new RecordFormatException("Cannot get length of the last string in SSTRecord");
            }
            if (remaining == 2) {
                this.setExpectedChars(LittleEndian.getShort(data, offset));
                this._unfinished_string = "";
                break;
            }
            short char_count = LittleEndian.getShort(data, offset);
            this.setupStringParameters(data, offset, char_count);
            if (remaining < this._total_length_bytes) {
                this.setExpectedChars(this.calculateCharCount(this._total_length_bytes - remaining));
                char_count = (short)(char_count - this.getExpectedChars());
                this._total_length_bytes = remaining;
            } else {
                this.setExpectedChars(0);
            }
            this.processString(data, offset, char_count);
            offset += this._total_length_bytes;
            if (this.getExpectedChars() != 0) break;
        }
    }

    private void setupStringParameters(byte[] data, int index, int char_count) {
        byte flag = data[index + 2];
        this._wide_char = (flag & 1) == 1;
        boolean extended = (flag & 4) == 4;
        boolean formatted_run = (flag & 8) == 8;
        this._total_length_bytes = 3 + this.calculateByteCount(char_count);
        this._string_data_offset = 3;
        if (formatted_run) {
            short run_count = LittleEndian.getShort(data, index + this._string_data_offset);
            this._string_data_offset += 2;
            this._total_length_bytes += 2 + 4 * run_count;
        }
        if (extended) {
            int extension_length = LittleEndian.getInt(data, index + this._string_data_offset);
            this._string_data_offset += 4;
            this._total_length_bytes += 4 + extension_length;
        }
    }

    private void processString(byte[] data, int index, short char_count) {
        byte[] str_data = new byte[this._total_length_bytes];
        int length = 3 + this.calculateByteCount(char_count);
        byte[] bstring = new byte[length];
        System.arraycopy(data, index, str_data, 0, str_data.length);
        int offset = 0;
        LittleEndian.putShort(bstring, offset, char_count);
        bstring[offset += 2] = str_data[offset];
        System.arraycopy(str_data, this._string_data_offset, bstring, 3, bstring.length - 3);
        UnicodeString string = new UnicodeString(4095, (short)bstring.length, bstring);
        if (this.getExpectedChars() != 0) {
            this._unfinished_string = string.getString();
        } else {
            Integer integer = new Integer(this.field_3_strings.size());
            this.field_3_strings.put(integer, string);
        }
    }

    private void setExpectedChars(int count) {
        this.__expected_chars = count;
    }

    private int calculateByteCount(int character_count) {
        return character_count * (this._wide_char ? 2 : 1);
    }

    private int calculateCharCount(int byte_count) {
        return byte_count / (this._wide_char ? 2 : 1);
    }

    public int getRecordSize() {
        this._record_lengths = new ArrayList();
        int retval = 0;
        int unicodesize = this.calculateUnicodeSize();
        if (unicodesize > 8216) {
            UnicodeString unistr = null;
            int stringreminant = 0;
            int unipos = 0;
            boolean lastneedcontinue = false;
            int stringbyteswritten = 0;
            boolean finished = false;
            boolean first_record = true;
            int totalWritten = 0;
            while (!finished) {
                int shortrecord;
                int available;
                int record = 0;
                int pos = 0;
                if (first_record) {
                    record = 8228;
                    pos = 12;
                    first_record = false;
                    this._record_lengths.add(new Integer(record - 4));
                } else {
                    pos = 0;
                    int to_be_written = unicodesize - stringbyteswritten + (lastneedcontinue ? 1 : 0);
                    int size = Math.min(8224, to_be_written);
                    if (size == to_be_written) {
                        finished = true;
                    }
                    record = size + 4;
                    this._record_lengths.add(new Integer(size));
                    pos = 4;
                }
                if (lastneedcontinue) {
                    available = 8228 - pos;
                    if (stringreminant <= available) {
                        stringbyteswritten += stringreminant - 1;
                        pos += stringreminant;
                        lastneedcontinue = false;
                    } else {
                        int toBeWritten = unistr.maxBrokenLength(available);
                        if (available != toBeWritten) {
                            shortrecord = record - (available - toBeWritten);
                            this._record_lengths.set(this._record_lengths.size() - 1, new Integer(shortrecord - 4));
                            record = shortrecord;
                        }
                        stringbyteswritten += toBeWritten - 1;
                        pos += toBeWritten;
                        stringreminant -= toBeWritten - 1;
                        lastneedcontinue = true;
                    }
                }
                while (unipos < this.field_3_strings.size()) {
                    available = 8228 - pos;
                    Integer intunipos = new Integer(unipos);
                    unistr = (UnicodeString)this.field_3_strings.get(intunipos);
                    if (unistr.getRecordSize() <= available) {
                        stringbyteswritten += unistr.getRecordSize();
                        pos += unistr.getRecordSize();
                    } else {
                        if (available >= 3) {
                            int toBeWritten = unistr.maxBrokenLength(available);
                            stringbyteswritten += toBeWritten;
                            stringreminant = unistr.getRecordSize() - toBeWritten + 1;
                            if (available != toBeWritten) {
                                int shortrecord2 = record - (available - toBeWritten);
                                this._record_lengths.set(this._record_lengths.size() - 1, new Integer(shortrecord2 - 4));
                                record = shortrecord2;
                            }
                            lastneedcontinue = true;
                            ++unipos;
                            break;
                        }
                        shortrecord = record - available;
                        this._record_lengths.set(this._record_lengths.size() - 1, new Integer(shortrecord - 4));
                        record = shortrecord;
                        break;
                    }
                    ++unipos;
                }
                totalWritten += record;
            }
            retval = totalWritten;
        } else {
            retval = 12 + unicodesize;
            this._record_lengths.add(new Integer(unicodesize));
        }
        return retval;
    }

    private int calculateUnicodeSize() {
        int retval = 0;
        int k = 0;
        while (k < this.field_3_strings.size()) {
            UnicodeString string = (UnicodeString)this.field_3_strings.get(new Integer(k));
            retval += string.getRecordSize();
            ++k;
        }
        return retval;
    }

    static {
        _max = 8228;
        _std_record_overhead = 4;
        _sst_record_overhead = 12;
        _max_data_space = 8216;
        _string_minimal_overhead = 3;
        sid = (short)252;
    }
}

