/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.pizzadoc;

import net.sf.pizzacompiler.compiler.ClassSymbol;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.pizzadoc.DocConstants;
import net.sf.pizzacompiler.pizzadoc.DocException;
import net.sf.pizzacompiler.pizzadoc.DocHTML;
import net.sf.pizzacompiler.pizzadoc.DocName;
import net.sf.pizzacompiler.pizzadoc.DocSymbol;
import net.sf.pizzacompiler.pizzadoc.DocType;

class DocClassSymbol
implements DocConstants {
    static String toN_NoLink(ClassSymbol classSymbol) throws DocException {
        return DocName.toC(classSymbol.name);
    }

    static String toN(ClassSymbol classSymbol) throws DocException {
        if (!DocSymbol.isShown(classSymbol.modifiers)) {
            return DocClassSymbol.toN_NoLink(classSymbol);
        }
        return DocHTML.getClassLink(classSymbol, DocClassSymbol.toN_NoLink(classSymbol));
    }

    static String toFN_NoLink(ClassSymbol classSymbol) throws DocException {
        return DocName.toFN(classSymbol.fullName());
    }

    static String toFN(ClassSymbol classSymbol) throws DocException {
        if (!DocSymbol.isShown(classSymbol.modifiers)) {
            return DocClassSymbol.toFN_NoLink(classSymbol);
        }
        return DocHTML.getClassLink(classSymbol, DocClassSymbol.toFN_NoLink(classSymbol));
    }

    static String toNP(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(DocClassSymbol.toN(classSymbol)).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, true)));
    }

    static String toNP_NoLink(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(DocClassSymbol.toN_NoLink(classSymbol)).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, false)));
    }

    static String toFNP(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(DocClassSymbol.toFN(classSymbol)).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, true)));
    }

    static String toFNP_NoLink(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(DocClassSymbol.toFN_NoLink(classSymbol)).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, true)));
    }

    static String toMCN(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toN(classSymbol)));
    }

    static String toMCFN_NoLink(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toFN_NoLink(classSymbol)));
    }

    static String toMCNP(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toN(classSymbol)))).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, true)));
    }

    static String toMCNP_NoLink(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toN_NoLink(classSymbol)))).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, true)));
    }

    static String toMCFNP(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toN(classSymbol)))).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, true)));
    }

    static String toMCFNP_NoLink(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toFN_NoLink(classSymbol)))).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, false)));
    }

    static String toCFNP(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)).concat(String.valueOf(DocClassSymbol.toFN(classSymbol)))).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, false)));
    }

    static String toCFNP_NoLink(ClassSymbol classSymbol) throws DocException {
        return String.valueOf(String.valueOf(String.valueOf(DocSymbol.modifier2String(classSymbol.modifiers)).concat(String.valueOf(DocClassSymbol.classOrInterface(classSymbol)))).concat(String.valueOf(DocClassSymbol.toFN_NoLink(classSymbol)))).concat(String.valueOf(DocClassSymbol.parameter(classSymbol.type, false)));
    }

    private static String classOrInterface(ClassSymbol classSymbol) {
        return String.valueOf((classSymbol.modifiers & 0x200) != 0 ? "interface" : "class").concat(String.valueOf(" "));
    }

    private static String parameter(Type type, boolean bl) throws DocException {
        String string = "";
        Type[] typeArray = ((Type.ClassType)type).args();
        if (typeArray.length != 0) {
            string = String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("&lt;"))).concat(String.valueOf(DocType.toString(typeArray, bl)))).concat(String.valueOf("&gt;"));
        }
        return string;
    }

    static String sourceFile(ClassSymbol classSymbol) {
        return classSymbol.sourcefile().toString();
    }

    static boolean isInterface(ClassSymbol classSymbol) {
        return (classSymbol.modifiers & 0x200) != 0;
    }

    DocClassSymbol() {
    }
}

