/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: fglorieux
 * Date: 24 sept. 2002
 * Time: 21:25:14
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.sitemap;

import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ConfigurableServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

import java.util.HashMap;
import java.util.Map;


public class SuperuserAction extends ConfigurableServiceableAction
        implements ThreadSafe {
    fr.gouv.culture.sdx.framework.FrameworkImpl sdx_frame;

    public Map act(Redirector redirector,
                   SourceResolver resolver,
                   Map objectModel,
                   String source,
                   Parameters params) throws ServiceException {
        Map sitemapParams = new HashMap();
        sitemapParams.put("superuser", "true");

        try {
            ConfigurationUtils.checkServiceManager(this.manager);
            Object sdx_temp = this.manager.lookup(fr.gouv.culture.sdx.framework.Framework.ROLE);
            sdx_frame = (fr.gouv.culture.sdx.framework.FrameworkImpl) sdx_temp;
            if (sdx_frame == null || !sdx_frame.isSuperUserSet()) return null;
            return sitemapParams;
        } finally {
            if (sdx_frame != null) 
            	manager.release(sdx_frame);
        }
    }
}

