/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.ErrorTrail;
import net.sf.pizzacompiler.compiler.Type;

class Trail
implements Constants {
    int status = 0;
    Type.TypeVar tv = null;
    Trail next;
    static final Trail empty = new Trail(null, null);
    static final ErrorTrail error = new ErrorTrail(empty);

    Trail(Trail trail, Type.TypeVar typeVar) {
        this.next = trail;
        this.tv = typeVar;
    }

    void undoUpto(Trail trail) {
        Trail trail2 = this;
        while (trail2 != trail) {
            trail2.tv.value = null;
            trail2 = trail2.next;
        }
    }

    void undo() {
        this.undoUpto(empty);
    }

    void undoExcept(Type[] typeArray) {
        Trail trail = this;
        while (trail != empty) {
            int n;
            for (n = 0; n < typeArray.length && typeArray[n] != this.tv; ++n) {
            }
            if (n == typeArray.length) {
                this.tv.value = null;
            }
            trail = trail.next;
        }
    }

    Trail extend(Type.TypeVar typeVar) {
        return new Trail(this, typeVar);
    }

    Trail extend(Type[] typeArray) {
        Trail trail = this;
        for (int i = 0; i < typeArray.length; ++i) {
            trail = trail.extend((Type.TypeVar)typeArray[i]);
        }
        return trail;
    }

    boolean succeeds() {
        this.undo();
        return this.status == 0;
    }

    Trail error() {
        Trail.error.msg = "(no error message)";
        Trail.error.next = this;
        return error;
    }

    Trail error(String string) {
        Trail.error.msg = string;
        Trail.error.next = this;
        return error;
    }

    Trail error(String string, Object object) {
        Trail.error.msg = string;
        Trail.error.cause[0] = object;
        Trail.error.next = this;
        return error;
    }

    Trail error(String string, Object object, Object object2) {
        Trail.error.msg = string;
        Trail.error.cause[0] = object;
        Trail.error.cause[1] = object2;
        Trail.error.next = this;
        return error;
    }

    String errmsg() {
        throw new InternalError();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.tv).concat(String.valueOf(","))).concat(String.valueOf(this.next));
    }
}

