/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public final class RequestParameters
implements Serializable {
    private Map names = new HashMap(5);

    private String parseName(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public RequestParameters(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos == -1) continue;
                this.setParameter(this.parseName(pair.substring(0, pos)), this.parseName(pair.substring(pos + 1, pair.length())));
            }
        }
    }

    private void setParameter(String name, String value) {
        ArrayList list;
        if (this.names.containsKey(name)) {
            list = (ArrayList)this.names.get(name);
        } else {
            list = new ArrayList(3);
            this.names.put(name, list);
        }
        list.add(value);
    }

    public String getParameter(String name) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return null;
    }

    public String getParameter(String name, String defaultValue) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return defaultValue;
    }

    public String[] getParameterValues(String name) {
        if (this.names.containsKey(name)) {
            String[] values = null;
            ArrayList list = (ArrayList)this.names.get(name);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (values == null) {
                    values = new String[1];
                } else {
                    String[] copy = new String[values.length + 1];
                    System.arraycopy(values, 0, copy, 0, values.length);
                    values = copy;
                }
                values[values.length - 1] = (String)iter.next();
            }
            return values;
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return new EnumerationFromIterator(this.names.keySet().iterator());
    }

    final class EnumerationFromIterator
    implements Enumeration {
        private Iterator iter;

        EnumerationFromIterator(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

